/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.viewer;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javax.print.attribute.standard.MediaSize;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.doc.util.DcfBookUtil;
import jp.co.extreme.doc.util.DcfConstants;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.util.FxColorUtil;
import jp.co.extreme.fx.util.FxEffectUtil;
import jp.co.extreme.fx.viewer.FxxContent;
import jp.co.extreme.fx.viewer.FxxContentNode;
import jp.co.extreme.fx.viewer.FxxImageView;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfPageFormat;

public class FxxDocContent
extends BcLoggableObject
implements FxxContent {
    private DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();
    private DcfBook dcfBook;
    private int pageIndex;
    private Map<String, Image> imageMap;
    public static double dpiCoefficient = 100.0;

    public DcfShapeRenderer getShapeRenderer() {
        return this.shapeRenderer;
    }

    public void setShapeRenderer(DcfShapeRenderer shapeRenderer) {
        this.shapeRenderer = shapeRenderer;
    }

    public FxxDocContent(DcfBook dcfBook, int pageIndex) {
        this.dcfBook = dcfBook;
        this.pageIndex = pageIndex;
        this.imageMap = new HashMap<String, Image>();
    }

    @Override
    public FxxContentNode getNode(double scale) throws Exception {
        DcfPage dcfPage = this.dcfBook.getPage(this.pageIndex);
        double width = dcfPage.getPageFormat().getWidth() * scale;
        Image image = this.getImage(dcfPage, scale, true);
        FxxImageView imageView = new FxxImageView(image);
        FxxImageView bgNode = null;
        if (!BcStringUtil.isEmpty(dcfPage.getOverLayName())) {
            DcfPage bgPage = this.dcfBook.getBgPage(dcfPage.getOverLayName());
            if (bgPage != null) {
                Image bgImage = this.getImage(bgPage, scale, false);
                bgNode = new FxxImageView(bgImage);
            } else {
                BcLogUtil.debug("\u80cc\u666f\u540d '" + dcfPage.getOverLayName() + "' \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            }
        }
        if (bgNode == null) {
            MediaSize mediaSize = dcfPage.getMediaSize();
            DcfPageFormat pageFormat = dcfPage.getPageFormat();
            int dpi = (int)Math.round(100.0 * scale);
            Object[] values = DcfBookUtil.createAffineTransform(mediaSize, pageFormat, dpi);
            Dimension pixelDim = (Dimension)values[0];
            Pane bgPane = new Pane();
            bgPane.setPrefSize(pixelDim.getWidth(), pixelDim.getHeight());
            bgPane.setMaxSize(pixelDim.getWidth(), pixelDim.getHeight());
            Color paperColor = FxColorUtil.convFromAwt(DcfConstants.DEFAULT_PAPER_COLOR);
            if (dcfPage.paperColor != null) {
                paperColor = FxColorUtil.convFromAwt(dcfPage.paperColor);
            }
            String style1 = FxCssUtil.css_backgroundColor(paperColor);
            bgPane.setStyle(style1.toString());
            bgNode = bgPane;
        }
        bgNode.setEffect((Effect)FxEffectUtil.createDropShadow());
        StackPane stackPane = new StackPane();
        if (bgNode != null) {
            StackPane.setAlignment(bgNode, (Pos)Pos.TOP_LEFT);
            stackPane.getChildren().add(bgNode);
        }
        StackPane.setAlignment((Node)imageView, (Pos)Pos.TOP_LEFT);
        stackPane.getChildren().add((Object)imageView);
        FxxContentNode wrapperPane = new FxxContentNode();
        wrapperPane.setCenter((Node)stackPane);
        MediaSize mediaSize = dcfPage.getMediaSize();
        int pWidthMM = (int)mediaSize.getX(1000);
        int pHeightMM = (int)mediaSize.getY(1000);
        wrapperPane.text.setText(String.valueOf(this.pageIndex + 1) + "/" + this.dcfBook.getPageCount() + " " + pWidthMM + "x" + pHeightMM + "(mm)");
        return wrapperPane;
    }

    protected Image getImage(DcfPage dcfPage, double scale, boolean permeation) throws Exception {
        String key = this.crateKey(dcfPage.hashCode(), scale, permeation);
        Image image = this.imageMap.get(key);
        if (image != null) {
            return image;
        }
        int dpi = (int)Math.round(dpiCoefficient * scale);
        BufferedImage bufferedImage = DcfBookUtil.createImage(dcfPage, 2, dpi, this.shapeRenderer);
        if (permeation) {
            bufferedImage = AwtImageUtil.permeation(bufferedImage, DcfConstants.DEFAULT_PAPER_COLOR, 0);
        }
        image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        this.imageMap.put(key, image);
        return image;
    }

    protected String crateKey(int hashCode, double scale, boolean permeation) throws Exception {
        return String.valueOf(hashCode) + "-" + scale + "-" + permeation;
    }
}

