/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.tree;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.tree.FxTreeItemHelper;
import jp.co.extreme.swing.SwgUtil;

public class FxTreeCell<T>
extends TreeCell<T> {
    protected FxTextField textField;
    protected EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent ev) {
            try {
                FxTreeCell.this.keyEvent(ev);
            }
            catch (Exception ex) {
                FxTreeCell.this.handleException(ex);
            }
        }
    };

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setText(null);
        this.setGraphic((Node)this.textField);
        this.textField.selectAll();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(this.getTreeItem().getGraphic());
    }

    public void updateItem(T value, boolean empty) {
        super.updateItem(value, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getItemText());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getItemText());
            this.setGraphic(this.getTreeItem().getGraphic());
        }
        FxTreeItem treeItem = (FxTreeItem)this.getTreeItem();
        if (treeItem != null) {
            treeItem.setTreeCell(this);
            this.setTooltip(treeItem.tooltip);
        }
    }

    protected void createTextField() {
        try {
            this.textField = new FxTextField(this.getItemText());
            this.textField.setOnKeyPressed(this.keyEventHandler);
            this.textField.setOnKeyReleased(this.keyEventHandler);
            this.textField.setOnKeyTyped(this.keyEventHandler);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public String getItemText() {
        String str = null;
        try {
            str = this.getItemText_L2();
        }
        catch (Exception ex) {
            str = ex.getMessage();
            this.handleException(ex);
        }
        return str;
    }

    public String getItemText_L2() throws Exception {
        String str = null;
        FxTreeItem treeItem = (FxTreeItem)this.getTreeItem();
        FxTreeItemHelper treeIF = treeItem.getTreeIF();
        if (treeIF != null) {
            str = treeItem.getTreeIF().getItemText(treeItem);
        } else {
            Object object = this.getTreeItem().getValue();
            if (object == null) {
                object = this.getTreeItem();
            }
            str = BcStringUtil.toStringNotNull(object);
        }
        return str;
    }

    protected void keyEvent(KeyEvent ev) throws Exception {
        BcLogUtil.debug("ev=" + ev);
        if (ev.getSource() == this.textField && ev.getEventType() == KeyEvent.KEY_PRESSED && ev.getCode() != KeyCode.ENTER && ev.getCode() == KeyCode.ESCAPE) {
            this.cancelEdit();
        }
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

