/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.script;

import java.io.Reader;
import jp.co.extreme.base.core.BcStringUtil;

public abstract class BcAbstractScriptParser {
    public static final int INIT = -1;
    public static final int CLASS_NAME = 101;
    public static final int CLASS_INTERNAL = 102;
    public static final int CLASS_VARIABLE_VALUE = 103;
    public static final int METHOD_INTERNAL = 201;
    public static final int METHOD_VARIABLE_VALUE = 202;
    public static final int COMMAND_ARGUMENT = 203;
    public static final int VALUE = 301;
    public static final int EV_CLASS_NAME = 11;
    public static final int EV_CLASS_END = 12;
    public static final int EV_CLASS_VARIABLE_NAME = 21;
    public static final int EV_CLASS_VARIABLE_VALUE = 22;
    public static final int EV_METHOD_NAME = 31;
    public static final int EV_METHOD_END = 32;
    public static final int EV_COMMNAD_NAME = 41;
    public static final int EV_COMMNAD_PARAMETER = 42;
    public static final int EV_METHOD_VARIABLE_NAME = 51;
    public static final int EV_METHOD_VARIABLE_VALUE = 52;

    public void startParse(Reader reader) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        char[] chars = new char[1];
        char preChar = '\u0000';
        char curChar = '\u0000';
        int pos = -1;
        int preMode = -1;
        int curMode = 101;
        boolean isString = false;
        boolean isEscape = false;
        boolean isEvented = false;
        boolean isSecondDelimiter = false;
        int eventId = -1;
        int retMode = -1;
        while (true) {
            ++pos;
            if (reader.read(chars, 0, 1) < 0) break;
            curChar = chars[0];
            if (curMode != preMode) {
                isEvented = false;
                isSecondDelimiter = false;
                sb.delete(0, sb.length());
                preMode = curMode;
            }
            block0 : switch (curMode) {
                case 101: {
                    switch (curChar) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (!isSecondDelimiter || !isEvented) break block0;
                            this.scriptParserEvent(11, sb);
                            isEvented = true;
                            break block0;
                        }
                        case '!': 
                        case '\"': 
                        case '#': 
                        case '$': 
                        case '%': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case ';': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '?': 
                        case '@': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '_': 
                        case '`': 
                        case '|': 
                        case '}': 
                        case '~': {
                            new Exception("syntax erroe:1002 char=" + curChar);
                        }
                        case '{': {
                            if (!isEvented) {
                                this.scriptParserEvent(11, sb);
                            }
                            curMode = 102;
                            break block0;
                        }
                    }
                    sb.append(curChar);
                    isSecondDelimiter = true;
                    break;
                }
                case 102: {
                    switch (curChar) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case ';': {
                            if (!isSecondDelimiter || !isEvented) break block0;
                            this.scriptParserEvent(31, sb);
                            isEvented = true;
                            break block0;
                        }
                        case '!': 
                        case '\"': 
                        case '#': 
                        case '$': 
                        case '%': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '>': 
                        case '?': 
                        case '@': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '`': 
                        case '|': 
                        case '}': 
                        case '~': {
                            new Exception("syntax erroe:1004 char=" + curChar);
                        }
                        case '=': {
                            if (!isEvented) {
                                this.scriptParserEvent(21, sb);
                            }
                            eventId = 22;
                            retMode = 102;
                            curMode = 301;
                            break block0;
                        }
                        case '{': {
                            if (!isEvented) {
                                this.scriptParserEvent(31, sb);
                            }
                            curMode = 201;
                            break block0;
                        }
                    }
                    sb.append(curChar);
                    isSecondDelimiter = true;
                    break;
                }
                case 201: {
                    switch (curChar) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case ';': {
                            if (!isSecondDelimiter || !isEvented) break block0;
                            this.scriptParserEvent(41, sb);
                            isEvented = true;
                            break block0;
                        }
                        case '!': 
                        case '\"': 
                        case '#': 
                        case '$': 
                        case '%': 
                        case '&': 
                        case '\'': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '>': 
                        case '?': 
                        case '@': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '_': 
                        case '`': 
                        case '{': 
                        case '|': 
                        case '~': {
                            new Exception("syntax erroe:1005 char=" + curChar);
                        }
                        case '(': {
                            if (!isEvented) {
                                this.scriptParserEvent(41, sb);
                            }
                            curMode = 203;
                            break block0;
                        }
                        case '=': {
                            if (!isEvented) {
                                this.scriptParserEvent(51, sb);
                            }
                            eventId = 52;
                            retMode = 201;
                            curMode = 301;
                            break block0;
                        }
                        case '}': {
                            this.scriptParserEvent(32, sb);
                            curMode = 102;
                            break block0;
                        }
                    }
                    sb.append(curChar);
                    isSecondDelimiter = true;
                    break;
                }
                case 203: {
                    if (isString) {
                        if (isEscape) {
                            switch (curChar) {
                                case '\"': 
                                case '\\': {
                                    sb.append(curChar);
                                    isEscape = false;
                                    break block0;
                                }
                            }
                            if (BcStringUtil.isEscapeSequenceStr(curChar)) {
                                sb.append(curChar);
                                isEscape = false;
                                break;
                            }
                            new Exception("syntax erroe:COMMAND_ARGUMENT char=" + curChar);
                            break;
                        }
                        switch (curChar) {
                            case '\"': {
                                isString = false;
                                sb.append(curChar);
                                break block0;
                            }
                            case '\\': {
                                isEscape = true;
                                sb.append(curChar);
                                break block0;
                            }
                        }
                        sb.append(curChar);
                        break;
                    }
                    switch (curChar) {
                        case ')': {
                            this.scriptParserEvent(42, sb);
                            curMode = 201;
                            break block0;
                        }
                        case '\"': {
                            isString = true;
                            sb.append(curChar);
                            break block0;
                        }
                    }
                    sb.append(curChar);
                    break;
                }
                case 301: {
                    if (isString) {
                        if (isEscape) {
                            switch (curChar) {
                                case '\"': 
                                case '\\': {
                                    sb.append(curChar);
                                    isEscape = false;
                                    break block0;
                                }
                            }
                            if (BcStringUtil.isEscapeSequenceStr(curChar)) {
                                sb.append(curChar);
                                isEscape = false;
                                break;
                            }
                            new Exception("syntax erroe:VARIABLE_VALUE char=" + curChar);
                            break;
                        }
                        switch (curChar) {
                            case '\"': {
                                isString = false;
                                break block0;
                            }
                            case '\\': {
                                isEscape = true;
                                sb.append(curChar);
                                break block0;
                            }
                        }
                        sb.append(curChar);
                        break;
                    }
                    switch (curChar) {
                        case ' ': {
                            break block0;
                        }
                        case '\"': {
                            isString = true;
                            break block0;
                        }
                        case ';': {
                            this.scriptParserEvent(eventId, sb);
                            curMode = retMode;
                            break block0;
                        }
                        case '}': {
                            new Exception("syntax erroe: ';' \u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        }
                    }
                    if (BcStringUtil.isEscapeSequenceChar(curChar)) break;
                    sb.append(curChar);
                    break;
                }
            }
            preChar = curChar;
        }
        this.scriptParserEvent(12, sb);
    }

    protected abstract void scriptParserEvent(int var1, StringBuilder var2) throws Exception;
}

