/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.File;
import java.io.FileInputStream;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcBoolean;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.EncodingInformation;
import jp.co.extreme.base.util.StringRef;

public class BcCharsetDetector
extends BcLoggableObject {
    public static BcCharsetDetector getInstance() {
        return SingletonHolder.instance;
    }

    public String detectCharset(FileInputStream fis) throws Exception {
        int BufferSize = 1000;
        byte[] readBuffer = new byte[1000];
        readBuffer[2] = -1;
        readBuffer[3] = -1;
        int readCount = fis.read(readBuffer, 0, 1000);
        EncodingInformation ei = this.detectCharset(readBuffer, readCount);
        return ei.charsetName;
    }

    public String detectCharset(File file) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            return this.detectCharset(fis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public EncodingInformation detectCharset(byte[] buffer, int sizeOfBuffer) {
        EncodingInformation encodingInfo = new EncodingInformation();
        StringRef charsetName = new StringRef();
        if (this.IsBOM(buffer, charsetName)) {
            encodingInfo.BomExist = true;
            encodingInfo.charsetName = charsetName.value;
            return encodingInfo;
        }
        encodingInfo.BomExist = false;
        encodingInfo.charsetName = null;
        BcBoolean isJIS = new BcBoolean();
        boolean outOfSpecification = this.JISEncodingJudgment(buffer, sizeOfBuffer, isJIS);
        if (!outOfSpecification) {
            encodingInfo.charsetName = isJIS.value != false ? BcCharsetNames.ISO_2022_JP.value : BcCharsetNames.US_ASCII.value;
            return encodingInfo;
        }
        outOfSpecification = this.Utf8EncodingJudgment(buffer, sizeOfBuffer);
        if (!outOfSpecification) {
            encodingInfo.charsetName = BcCharsetNames.UTF_8.value;
            return encodingInfo;
        }
        outOfSpecification = BcCharsetDetector.EUCJPEncodingJudgment(buffer, sizeOfBuffer);
        if (!outOfSpecification) {
            encodingInfo.charsetName = BcCharsetNames.EUC_JP.value;
            return encodingInfo;
        }
        outOfSpecification = BcCharsetDetector.SJISEncodingJudgment(buffer, sizeOfBuffer);
        if (!outOfSpecification) {
            encodingInfo.charsetName = BcCharsetNames.SJIS.value;
            return encodingInfo;
        }
        encodingInfo.charsetName = null;
        return encodingInfo;
    }

    boolean IsBOM(byte[] bomByte, StringRef charsetName) {
        boolean result;
        byte[] bomUTF8 = new byte[]{-17, -69, -65};
        byte[] bomUTF16Little = new byte[]{-1, -2};
        byte[] bomUTF16Big = new byte[]{-2, -1};
        byte[] byArray = new byte[4];
        byArray[0] = -1;
        byArray[1] = -2;
        byte[] bomUTF32Little = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[2] = -2;
        byArray2[3] = -1;
        byte[] bomUTF32Big = byArray2;
        if (BcCharsetDetector.IsMatched(bomByte, bomUTF8)) {
            result = true;
            charsetName.value = BcCharsetNames.UTF_8.value;
        } else if (BcCharsetDetector.IsMatched(bomByte, bomUTF32Little)) {
            result = true;
            charsetName.value = BcCharsetNames.UTF_32LE.value;
        } else if (BcCharsetDetector.IsMatched(bomByte, bomUTF32Big)) {
            result = true;
            charsetName.value = BcCharsetNames.UTF_32BE.value;
        } else if (BcCharsetDetector.IsMatched(bomByte, bomUTF16Little)) {
            result = true;
            charsetName.value = BcCharsetNames.UTF_16LE.value;
        } else if (BcCharsetDetector.IsMatched(bomByte, bomUTF16Big)) {
            result = true;
            charsetName.value = BcCharsetNames.UTF_16BE.value;
        } else {
            result = false;
            charsetName.value = BcCharsetNames.SJIS.value;
        }
        return result;
    }

    static boolean IsMatched(byte[] data, byte[] bom) {
        boolean result = true;
        int i = 0;
        while (i < bom.length) {
            if (bom[i] != data[i]) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    boolean JISEncodingJudgment(byte[] buffer, int sizeOfBuffer, BcBoolean isJIS) {
        boolean outOfSpecification = false;
        boolean esc1 = false;
        boolean esc2 = false;
        byte[] byteESC1 = new byte[]{27, 40, 66};
        byte[] byteESC2 = new byte[]{27, 36, 66};
        byte[] backESC = new byte[3];
        int i = 0;
        while (i < sizeOfBuffer) {
            if (128 <= (buffer[i] & 0xFF)) {
                outOfSpecification = true;
                break;
            }
            backESC[0] = backESC[1];
            backESC[1] = backESC[2];
            backESC[2] = buffer[i];
            if (!esc1 && BcCharsetDetector.IsMatched(backESC, byteESC1)) {
                esc1 = true;
            }
            if (!esc2 && BcCharsetDetector.IsMatched(backESC, byteESC2)) {
                esc2 = true;
            }
            ++i;
        }
        isJIS.value = esc1 || esc2 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return outOfSpecification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean Utf8EncodingJudgment(byte[] buffer, int sizeOfBuffer) {
        boolean outOfSpecification = false;
        outOfSpecification = false;
        byte[] byteChar = new byte[6];
        int byteCharCount = 0;
        int i = 0;
        while (i < sizeOfBuffer) {
            int bufferByte = buffer[i] & 0xFF;
            if (128 <= (buffer[i] & 0xFF)) {
                byte char2byte = (byte)(0xE0 & bufferByte);
                if (char2byte == -64) {
                    outOfSpecification = BcCharsetDetector.Utf8OutOfSpecification(byteChar[0], byteCharCount, false);
                    if (outOfSpecification) return outOfSpecification;
                    byteChar[0] = char2byte;
                    byteCharCount = 1;
                } else {
                    byte char3byte = (byte)(0xF0 & bufferByte);
                    if (char3byte == -32) {
                        outOfSpecification = BcCharsetDetector.Utf8OutOfSpecification(byteChar[0], byteCharCount, false);
                        if (outOfSpecification) return outOfSpecification;
                        byteChar[0] = char3byte;
                        byteCharCount = 1;
                    } else {
                        byte char4byte = (byte)(0xF8 & bufferByte);
                        if (char4byte == -16) {
                            outOfSpecification = BcCharsetDetector.Utf8OutOfSpecification(byteChar[0], byteCharCount, false);
                            if (outOfSpecification) return outOfSpecification;
                            byteChar[0] = char4byte;
                            byteCharCount = 1;
                        } else {
                            byte charSecond = (byte)(0xC0 & bufferByte);
                            if (charSecond != -128) return true;
                            if (byteCharCount < 1) {
                                return true;
                            }
                            byteChar[byteCharCount] = charSecond;
                            if (outOfSpecification = BcCharsetDetector.Utf8OutOfSpecification(byteChar[0], ++byteCharCount, true)) {
                                return outOfSpecification;
                            }
                        }
                    }
                }
            } else {
                byteChar[0] = 0;
                byteCharCount = 0;
            }
            ++i;
        }
        return outOfSpecification;
    }

    static boolean Utf8OutOfSpecification(byte topByteChar, int byteCharCount, boolean checkBig) {
        boolean outOfSpecification = false;
        if (topByteChar == -64) {
            if (checkBig) {
                if (byteCharCount > 2) {
                    outOfSpecification = true;
                }
            } else if (byteCharCount < 2) {
                outOfSpecification = true;
            }
        } else if (topByteChar == -32) {
            if (checkBig) {
                if (byteCharCount > 3) {
                    outOfSpecification = true;
                }
            } else if (byteCharCount < 3) {
                outOfSpecification = true;
            }
        } else if (topByteChar == -16) {
            if (checkBig) {
                if (byteCharCount > 4) {
                    outOfSpecification = true;
                }
            } else if (byteCharCount < 4) {
                outOfSpecification = true;
            }
        }
        return outOfSpecification;
    }

    static boolean EUCJPEncodingJudgment(byte[] buffer, int sizeOfBuffer) {
        boolean outOfSpecification = false;
        BYTECODE beforeCode = BYTECODE.OneByteCode;
        int byteCharCount = 0;
        int i = 0;
        while (i < sizeOfBuffer) {
            int bufferByte = buffer[i] & 0xFF;
            if (161 <= bufferByte && bufferByte <= 254) {
                if (beforeCode == BYTECODE.KanaOneByte) {
                    if (byteCharCount == 1) {
                        byteCharCount = 2;
                    } else {
                        outOfSpecification = true;
                        break;
                    }
                }
                if (beforeCode == BYTECODE.TwoByteCode) {
                    if (byteCharCount == 1) {
                        byteCharCount = 2;
                    } else if (byteCharCount == 2) {
                        byteCharCount = 1;
                    }
                }
                beforeCode = BYTECODE.TwoByteCode;
            } else if (bufferByte <= 127) {
                if (beforeCode == BYTECODE.TwoByteCode && byteCharCount == 1) {
                    outOfSpecification = true;
                    break;
                }
                beforeCode = BYTECODE.OneByteCode;
                byteCharCount = 1;
            } else if (bufferByte == 142 && byteCharCount == 1) {
                beforeCode = BYTECODE.KanaOneByte;
                byteCharCount = 1;
            } else {
                outOfSpecification = true;
                break;
            }
            ++i;
        }
        return outOfSpecification;
    }

    static boolean SJISEncodingJudgment(byte[] buffer, int sizeOfBuffer) {
        boolean outOfSpecification = false;
        SJIS_BYTECODE sjisByte = SJIS_BYTECODE.OneByteCode;
        outOfSpecification = false;
        int i = 0;
        while (i < sizeOfBuffer) {
            int bufferByte = buffer[i] & 0xFF;
            if (bufferByte <= 127) {
                sjisByte = SJIS_BYTECODE.OneByteCode;
            } else if (161 <= bufferByte && bufferByte <= 223) {
                sjisByte = SJIS_BYTECODE.KanaOneByte;
            } else if (129 <= bufferByte && bufferByte <= 159) {
                sjisByte = SJIS_BYTECODE.TwoByteCommon;
            } else if (224 <= bufferByte && bufferByte <= 239) {
                if (sjisByte == SJIS_BYTECODE.TwoByteBefore) {
                    outOfSpecification = true;
                    break;
                }
                sjisByte = SJIS_BYTECODE.TwoByteBefore;
            } else if (64 <= bufferByte && bufferByte <= 126 || 128 <= bufferByte && bufferByte <= 252) {
                if (sjisByte == SJIS_BYTECODE.TwoByteAfter) {
                    outOfSpecification = true;
                    break;
                }
                sjisByte = SJIS_BYTECODE.TwoByteAfter;
            } else {
                outOfSpecification = true;
            }
            ++i;
        }
        return outOfSpecification;
    }

    static enum BYTECODE {
        OneByteCode,
        TwoByteCode,
        KanaOneByte;

    }

    static enum SJIS_BYTECODE {
        OneByteCode,
        TwoByteCommon,
        TwoByteBefore,
        TwoByteAfter,
        KanaOneByte;

    }

    private static final class SingletonHolder {
        private static final BcCharsetDetector instance = new BcCharsetDetector();

        private SingletonHolder() {
        }
    }
}

