/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.io;

import java.io.File;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileCircuiter;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.base.log.BcLogUtil;

public class BcFileCopier
extends BcFileCircuiter {
    private BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
    private File fromFile;
    private File toDir;
    public boolean doOverwrite;

    public void doCopy(File fromFile, File toDir) throws Exception {
        this.fromFile = fromFile;
        this.toDir = toDir;
        this.start(fromFile);
    }

    @Override
    public void fileWasFound(File targetFile, int dirCount, int fileCount) throws Exception {
        super.fileWasFound(targetFile, dirCount, fileCount);
        if (targetFile.isDirectory()) {
            boolean isSuccess;
            File destFile = this.toDestFile(targetFile);
            if (!destFile.exists() && !(isSuccess = destFile.mkdirs())) {
                throw new Exception("Can't create dir." + destFile.getPath());
            }
        } else {
            boolean isSuccess;
            File destFile = this.toDestFile(targetFile);
            if (destFile.exists() && this.doOverwrite && !(isSuccess = destFile.delete())) {
                throw new Exception("Can't delete " + destFile.getPath());
            }
            BcFileUtil.copyFile(targetFile, destFile, this.streamTransmitter);
        }
    }

    protected File toDestFile(File targetFile) throws Exception {
        String pathLower = "";
        pathLower = BcStringUtil.equals(this.fromFile.getPath(), targetFile.getPath()) ? String.valueOf(BcFileUtil.fileSep) + targetFile.getName() : BcStringUtil.replace((CharSequence)targetFile.getPath(), this.fromFile.getParentFile().getPath(), "").toString();
        String destFilePath = String.valueOf(this.toDir.getPath()) + pathLower;
        BcLogUtil.debug("toDestFile:destFilePath=" + destFilePath);
        return new File(destFilePath);
    }
}

