/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.core;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;

public final class BcByteUtil {
    private BcByteUtil() {
    }

    public static byte[] newByteArray(byte[] srcBytes, int offSet, int length) throws Exception {
        byte[] resBytes = new byte[length];
        System.arraycopy(srcBytes, offSet, resBytes, 0, length);
        return resBytes;
    }

    public static byte[] marge(byte[] bytes1, byte[] bytes2) throws Exception {
        byte[] newBytes = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, newBytes, 0, bytes1.length);
        System.arraycopy(bytes2, 0, newBytes, bytes1.length, bytes2.length);
        return newBytes;
    }

    public static byte[] marge(List bytesList) throws Exception {
        int offSet = 0;
        int i = 0;
        while (i < bytesList.size()) {
            Object obj = bytesList.get(i);
            if (obj instanceof Byte) {
                ++offSet;
            } else {
                byte[] srcBytes = (byte[])obj;
                offSet += srcBytes.length;
            }
            ++i;
        }
        byte[] resByteArray = new byte[offSet];
        offSet = 0;
        int i2 = 0;
        while (i2 < bytesList.size()) {
            Object obj = bytesList.get(i2);
            if (obj instanceof Byte) {
                resByteArray[offSet] = (Byte)obj;
                ++offSet;
            } else {
                byte[] srcBytes = (byte[])obj;
                System.arraycopy(srcBytes, 0, resByteArray, offSet, srcBytes.length);
                offSet += srcBytes.length;
            }
            ++i2;
        }
        return resByteArray;
    }

    public static byte[] reverse(byte[] srcBytes) throws Exception {
        byte[] newBytes = new byte[srcBytes.length];
        int i = 0;
        while (i < srcBytes.length) {
            newBytes[i] = srcBytes[srcBytes.length - i - 1];
            ++i;
        }
        return newBytes;
    }

    public static byte[] toByteArray(int intValue, ByteOrder byteOrder) throws Exception {
        byte[] bytes = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer = byteBuffer.order(byteOrder);
        byteBuffer.putInt(intValue);
        return bytes;
    }

    public static byte[] toByteArray(long longValue, ByteOrder byteOrder) throws Exception {
        byte[] bytes = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer = byteBuffer.order(byteOrder);
        byteBuffer.putLong(longValue);
        return bytes;
    }

    public static byte[] toByteArray(long srcValue, boolean isLittle, int length) throws Exception {
        BigInteger bigInteger = new BigInteger(Long.toString(srcValue));
        byte[] bytes = null;
        if (length > 0) {
            bytes = new byte[length];
            byte[] srcBytes2 = bigInteger.toByteArray();
            System.arraycopy(srcBytes2, srcBytes2.length - length, bytes, 0, length);
        } else {
            bytes = bigInteger.toByteArray();
        }
        if (isLittle) {
            bytes = BcByteUtil.reverse(bytes);
        }
        return bytes;
    }

    public static byte[] toByteArray(byte[] srcValue, boolean isLittle, int length) throws Exception {
        BigInteger bigInteger = new BigInteger(srcValue);
        byte[] newBytes = null;
        if (length > 0) {
            newBytes = new byte[length];
            byte[] srcBytes2 = bigInteger.toByteArray();
            BcLogUtil.debug("srcBytes2=" + BcNumberUtil.toHex(srcBytes2));
            System.arraycopy(srcBytes2, srcBytes2.length - length, newBytes, 0, length);
        } else {
            newBytes = bigInteger.toByteArray();
        }
        if (isLittle) {
            newBytes = BcByteUtil.reverse(newBytes);
        }
        return newBytes;
    }

    public static int toInt(byte[] srcBytes1, ByteOrder byteOrder) throws Exception {
        byte[] srcBytes2 = srcBytes1;
        if (srcBytes1.length < 4) {
            srcBytes2 = new byte[4];
            System.arraycopy(srcBytes1, 0, srcBytes2, 0, srcBytes1.length);
            int gap = 4 - srcBytes1.length;
            int i = 0;
            while (i < gap) {
                srcBytes2[srcBytes1.length + i] = 0;
                ++i;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(byteOrder);
        byteBuffer.put(srcBytes2);
        byteBuffer.flip();
        return byteBuffer.getInt();
    }

    public static int toInt(byte[] srcBytes, int offSet, int length, ByteOrder byteOrder) throws Exception {
        byte[] newBytes = BcByteUtil.newByteArray(srcBytes, offSet, length);
        return BcByteUtil.toInt(newBytes, byteOrder);
    }

    public static int toInt(byte[] srcBytes, BcInteger offSet, int length, ByteOrder byteOrder) throws Exception {
        int resValue = BcByteUtil.toInt(srcBytes, offSet.value, length, byteOrder);
        offSet.value += length;
        return resValue;
    }

    public static int[] toIntArray(byte[] srcBytes, int offSet, int length) throws Exception {
        int[] intArray = new int[length];
        int i = 0;
        while (i < length) {
            intArray[i] = srcBytes[i + offSet];
            ++i;
        }
        return intArray;
    }

    public static int[] toIntArray(byte[] srcBytes, BcInteger offSet, int length) throws Exception {
        int[] intArray = BcByteUtil.toIntArray(srcBytes, offSet.value, length);
        offSet.value += length;
        return intArray;
    }

    public static int[] toIntArray(byte[] srcBytes) throws Exception {
        return BcByteUtil.toIntArray(srcBytes, 0, srcBytes.length);
    }

    public static BigInteger getAsBigInteger(byte[] srcBytes, int offSet, int length, ByteOrder byteOrder) throws Exception {
        byte[] newBytes = BcByteUtil.newByteArray(srcBytes, offSet, length);
        if (byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) {
            newBytes = BcByteUtil.reverse(newBytes);
        }
        BigInteger bigInteger = new BigInteger(newBytes);
        return bigInteger;
    }

    public static String getAsString(byte[] srcBytes, int offSet, int length, String encode) throws Exception {
        String str = null;
        str = BcStringUtil.isEmpty(encode) ? new String(srcBytes, offSet, length) : new String(srcBytes, offSet, length, encode);
        return str;
    }

    public static String getAsString(byte[] srcBytes, BcInteger offSet, int length, String encode) throws Exception {
        String str = BcByteUtil.getAsString(srcBytes, offSet.value, length, encode);
        offSet.value += length;
        return str;
    }

    public static String getAsString(byte[] srcBytes, BcInteger offSet, int length) throws Exception {
        return BcByteUtil.getAsString(srcBytes, offSet, length, null);
    }

    public static String getAsString(byte[] srcBytes, int offSet, int length) throws Exception {
        return BcByteUtil.getAsString(srcBytes, offSet, length, null);
    }

    public static int getAsStringInt(byte[] srcBytes, BcInteger offSet, int length, String encode) throws Exception {
        return Integer.parseInt(BcByteUtil.getAsString(srcBytes, offSet, length, encode));
    }

    public static int getAsStringInt(byte[] srcBytes, BcInteger offSet, int length, String encode, int defaultValue) throws Exception {
        try {
            return Integer.parseInt(BcByteUtil.getAsString(srcBytes, offSet, length, encode));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static int getAsStringInt(byte[] srcBytes, BcInteger offSet, int length) throws Exception {
        return Integer.parseInt(BcByteUtil.getAsString(srcBytes, offSet, length, null));
    }

    public static int getAsStringInt(byte[] srcBytes, BcInteger offSet, int length, int defaultValue) throws Exception {
        try {
            return Integer.parseInt(BcByteUtil.getAsString(srcBytes, offSet, length, null));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static short getAsStringShort(byte[] srcBytes, BcInteger offSet, int length) throws Exception {
        return Short.parseShort(BcByteUtil.getAsString(srcBytes, offSet, length, null));
    }

    public static short getAsStringShort(byte[] srcBytes, BcInteger offSet, int length, short defaultValue) throws Exception {
        try {
            return BcByteUtil.getAsStringShort(srcBytes, offSet, length);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static double getAsStringDouble(byte[] srcBytes, BcInteger offSet, int length, String encode) throws Exception {
        return Double.parseDouble(BcByteUtil.getAsString(srcBytes, offSet, length, encode));
    }

    public static double getAsStringDouble(byte[] srcBytes, BcInteger offSet, int length, String encode, double defaultValue) throws Exception {
        try {
            return Double.parseDouble(BcByteUtil.getAsString(srcBytes, offSet, length, encode));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static double getAsStringDouble(byte[] srcBytes, BcInteger offSet, int length) throws Exception {
        return Double.parseDouble(BcByteUtil.getAsString(srcBytes, offSet, length, null));
    }

    public static double getAsStringDouble(byte[] srcBytes, BcInteger offSet, int length, double defaultValue) throws Exception {
        try {
            return Double.parseDouble(BcByteUtil.getAsString(srcBytes, offSet, length, null));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }
}

