/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.Ser;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Objects;

public final class LocalDateTime
implements Temporal,
TemporalAdjuster,
ChronoLocalDateTime<LocalDate>,
Serializable {
    public static final LocalDateTime MIN = LocalDateTime.of(LocalDate.MIN, LocalTime.MIN);
    public static final LocalDateTime MAX = LocalDateTime.of(LocalDate.MAX, LocalTime.MAX);
    private static final long serialVersionUID = 6207766400415563566L;
    private final LocalDate date;
    private final LocalTime time;

    public static LocalDateTime now() {
        return LocalDateTime.now(Clock.systemDefaultZone());
    }

    public static LocalDateTime now(ZoneId zoneId) {
        return LocalDateTime.now(Clock.system(zoneId));
    }

    public static LocalDateTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        ZoneOffset zoneOffset = clock.getZone().getRules().getOffset(instant);
        return LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        LocalTime localTime = LocalTime.of(n3, n4);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        LocalTime localTime = LocalTime.of(n3, n4, n5);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5, int n6) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        LocalTime localTime = LocalTime.of(n3, n4, n5, n6);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        LocalTime localTime = LocalTime.of(n4, n5);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        LocalTime localTime = LocalTime.of(n4, n5, n6);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        LocalTime localTime = LocalTime.of(n4, n5, n6, n7);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(LocalDate localDate, LocalTime localTime) {
        Objects.requireNonNull(localDate, "date");
        Objects.requireNonNull(localTime, "time");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime ofInstant(Instant instant, ZoneId zoneId) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        return LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
    }

    public static LocalDateTime ofEpochSecond(long l, int n, ZoneOffset zoneOffset) {
        Objects.requireNonNull(zoneOffset, "offset");
        ChronoField.NANO_OF_SECOND.checkValidValue(n);
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        long l3 = Math.floorDiv(l2, 86400L);
        int n2 = (int)Math.floorMod(l2, 86400L);
        LocalDate localDate = LocalDate.ofEpochDay(l3);
        LocalTime localTime = LocalTime.ofNanoOfDay((long)n2 * 1000000000L + (long)n);
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof LocalDateTime) {
            return (LocalDateTime)temporalAccessor;
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporalAccessor).toLocalDateTime();
        }
        if (temporalAccessor instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporalAccessor).toLocalDateTime();
        }
        try {
            LocalDate localDate = LocalDate.from(temporalAccessor);
            LocalTime localTime = LocalTime.from(temporalAccessor);
            return new LocalDateTime(localDate, localTime);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain LocalDateTime from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public static LocalDateTime parse(CharSequence charSequence) {
        return LocalDateTime.parse(charSequence, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, LocalDateTime::from);
    }

    private LocalDateTime(LocalDate localDate, LocalTime localTime) {
        this.date = localDate;
        this.time = localTime;
    }

    private LocalDateTime with(LocalDate localDate, LocalTime localTime) {
        if (this.date == localDate && this.time == localTime) {
            return this;
        }
        return new LocalDateTime(localDate, localTime);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isDateBased() || chronoField.isTimeBased();
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        return ChronoLocalDateTime.super.isSupported(temporalUnit);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isTimeBased() ? this.time.range(temporalField) : this.date.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isTimeBased() ? this.time.get(temporalField) : this.date.get(temporalField);
        }
        return ChronoLocalDateTime.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            return chronoField.isTimeBased() ? this.time.getLong(temporalField) : this.date.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Override
    public LocalDate toLocalDate() {
        return this.date;
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonthValue() {
        return this.date.getMonthValue();
    }

    public Month getMonth() {
        return this.date.getMonth();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    public int getHour() {
        return this.time.getHour();
    }

    public int getMinute() {
        return this.time.getMinute();
    }

    public int getSecond() {
        return this.time.getSecond();
    }

    public int getNano() {
        return this.time.getNano();
    }

    @Override
    public LocalDateTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            return this.with((LocalDate)temporalAdjuster, this.time);
        }
        if (temporalAdjuster instanceof LocalTime) {
            return this.with(this.date, (LocalTime)temporalAdjuster);
        }
        if (temporalAdjuster instanceof LocalDateTime) {
            return (LocalDateTime)temporalAdjuster;
        }
        return (LocalDateTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public LocalDateTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (chronoField.isTimeBased()) {
                return this.with(this.date, this.time.with(temporalField, l));
            }
            return this.with(this.date.with(temporalField, l), this.time);
        }
        return temporalField.adjustInto(this, l);
    }

    public LocalDateTime withYear(int n) {
        return this.with(this.date.withYear(n), this.time);
    }

    public LocalDateTime withMonth(int n) {
        return this.with(this.date.withMonth(n), this.time);
    }

    public LocalDateTime withDayOfMonth(int n) {
        return this.with(this.date.withDayOfMonth(n), this.time);
    }

    public LocalDateTime withDayOfYear(int n) {
        return this.with(this.date.withDayOfYear(n), this.time);
    }

    public LocalDateTime withHour(int n) {
        LocalTime localTime = this.time.withHour(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime withMinute(int n) {
        LocalTime localTime = this.time.withMinute(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime withSecond(int n) {
        LocalTime localTime = this.time.withSecond(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime withNano(int n) {
        LocalTime localTime = this.time.withNano(n);
        return this.with(this.date, localTime);
    }

    public LocalDateTime truncatedTo(TemporalUnit temporalUnit) {
        return this.with(this.date, this.time.truncatedTo(temporalUnit));
    }

    @Override
    public LocalDateTime plus(TemporalAmount temporalAmount) {
        if (temporalAmount instanceof Period) {
            Period period = (Period)temporalAmount;
            return this.with(this.date.plus(period), this.time);
        }
        Objects.requireNonNull(temporalAmount, "amountToAdd");
        return (LocalDateTime)temporalAmount.addTo(this);
    }

    @Override
    public LocalDateTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            switch (chronoUnit) {
                case NANOS: {
                    return this.plusNanos(l);
                }
                case MICROS: {
                    return this.plusDays(l / 86400000000L).plusNanos(l % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusDays(l / 86400000L).plusNanos(l % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(l);
                }
                case MINUTES: {
                    return this.plusMinutes(l);
                }
                case HOURS: {
                    return this.plusHours(l);
                }
                case HALF_DAYS: {
                    return this.plusDays(l / 256L).plusHours(l % 256L * 12L);
                }
            }
            return this.with(this.date.plus(l, temporalUnit), this.time);
        }
        return temporalUnit.addTo(this, l);
    }

    public LocalDateTime plusYears(long l) {
        LocalDate localDate = this.date.plusYears(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusMonths(long l) {
        LocalDate localDate = this.date.plusMonths(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusWeeks(long l) {
        LocalDate localDate = this.date.plusWeeks(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusDays(long l) {
        LocalDate localDate = this.date.plusDays(l);
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusHours(long l) {
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L, 1);
    }

    public LocalDateTime plusMinutes(long l) {
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L, 1);
    }

    public LocalDateTime plusSeconds(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L, 1);
    }

    public LocalDateTime plusNanos(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l, 1);
    }

    @Override
    public LocalDateTime minus(TemporalAmount temporalAmount) {
        if (temporalAmount instanceof Period) {
            Period period = (Period)temporalAmount;
            return this.with(this.date.minus(period), this.time);
        }
        Objects.requireNonNull(temporalAmount, "amountToSubtract");
        return (LocalDateTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public LocalDateTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public LocalDateTime minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public LocalDateTime minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public LocalDateTime minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    public LocalDateTime minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public LocalDateTime minusHours(long l) {
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L, -1);
    }

    public LocalDateTime minusMinutes(long l) {
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L, -1);
    }

    public LocalDateTime minusSeconds(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L, -1);
    }

    public LocalDateTime minusNanos(long l) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l, -1);
    }

    private LocalDateTime plusWithOverflow(LocalDate localDate, long l, long l2, long l3, long l4, int n) {
        if ((l | l2 | l3 | l4) == 0L) {
            return this.with(localDate, this.time);
        }
        long l5 = l4 / 86400000000000L + l3 / 86400L + l2 / 1440L + l / 24L;
        l5 *= (long)n;
        long l6 = l4 % 86400000000000L + l3 % 86400L * 1000000000L + l2 % 1440L * 60000000000L + l % 24L * 3600000000000L;
        long l7 = this.time.toNanoOfDay();
        l6 = l6 * (long)n + l7;
        long l8 = Math.floorMod(l6, 86400000000000L);
        LocalTime localTime = l8 == l7 ? this.time : LocalTime.ofNanoOfDay(l8);
        return this.with(localDate.plusDays(l5 += Math.floorDiv(l6, 86400000000000L)), localTime);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.localDate()) {
            return (R)this.date;
        }
        return ChronoLocalDateTime.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return ChronoLocalDateTime.super.adjustInto(temporal);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        LocalDateTime localDateTime = LocalDateTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            if (temporalUnit.isTimeBased()) {
                long l = this.date.daysUntil(localDateTime.date);
                if (l == 0L) {
                    return this.time.until(localDateTime.time, temporalUnit);
                }
                long l2 = localDateTime.time.toNanoOfDay() - this.time.toNanoOfDay();
                if (l > 0L) {
                    --l;
                    l2 += 86400000000000L;
                } else {
                    ++l;
                    l2 -= 86400000000000L;
                }
                switch ((ChronoUnit)temporalUnit) {
                    case NANOS: {
                        l = Math.multiplyExact(l, 86400000000000L);
                        break;
                    }
                    case MICROS: {
                        l = Math.multiplyExact(l, 86400000000L);
                        l2 /= 1000L;
                        break;
                    }
                    case MILLIS: {
                        l = Math.multiplyExact(l, 86400000L);
                        l2 /= 1000000L;
                        break;
                    }
                    case SECONDS: {
                        l = Math.multiplyExact(l, 86400L);
                        l2 /= 1000000000L;
                        break;
                    }
                    case MINUTES: {
                        l = Math.multiplyExact(l, 1440L);
                        l2 /= 60000000000L;
                        break;
                    }
                    case HOURS: {
                        l = Math.multiplyExact(l, 24L);
                        l2 /= 3600000000000L;
                        break;
                    }
                    case HALF_DAYS: {
                        l = Math.multiplyExact(l, 2L);
                        l2 /= 43200000000000L;
                    }
                }
                return Math.addExact(l, l2);
            }
            LocalDate localDate = localDateTime.date;
            if (localDate.isAfter(this.date) && localDateTime.time.isBefore(this.time)) {
                localDate = localDate.minusDays(1L);
            } else if (localDate.isBefore(this.date) && localDateTime.time.isAfter(this.time)) {
                localDate = localDate.plusDays(1L);
            }
            return this.date.until(localDate, temporalUnit);
        }
        return temporalUnit.between(this, localDateTime);
    }

    @Override
    public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public OffsetDateTime atOffset(ZoneOffset zoneOffset) {
        return OffsetDateTime.of(this, zoneOffset);
    }

    public ZonedDateTime atZone(ZoneId zoneId) {
        return ZonedDateTime.of(this, zoneId);
    }

    @Override
    public int compareTo(ChronoLocalDateTime<?> chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime);
        }
        return ChronoLocalDateTime.super.compareTo(chronoLocalDateTime);
    }

    private int compareTo0(LocalDateTime localDateTime) {
        int n = this.date.compareTo0(localDateTime.toLocalDate());
        if (n == 0) {
            n = this.time.compareTo(localDateTime.toLocalTime());
        }
        return n;
    }

    @Override
    public boolean isAfter(ChronoLocalDateTime<?> chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime) > 0;
        }
        return ChronoLocalDateTime.super.isAfter(chronoLocalDateTime);
    }

    @Override
    public boolean isBefore(ChronoLocalDateTime<?> chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime) < 0;
        }
        return ChronoLocalDateTime.super.isBefore(chronoLocalDateTime);
    }

    @Override
    public boolean isEqual(ChronoLocalDateTime<?> chronoLocalDateTime) {
        if (chronoLocalDateTime instanceof LocalDateTime) {
            return this.compareTo0((LocalDateTime)chronoLocalDateTime) == 0;
        }
        return ChronoLocalDateTime.super.isEqual(chronoLocalDateTime);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return this.date.equals(localDateTime.date) && this.time.equals(localDateTime.time);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.date.hashCode() ^ this.time.hashCode();
    }

    @Override
    public String toString() {
        return this.date.toString() + 'T' + this.time.toString();
    }

    private Object writeReplace() {
        return new Ser(5, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        this.date.writeExternal(dataOutput);
        this.time.writeExternal(dataOutput);
    }

    static LocalDateTime readExternal(DataInput dataInput) throws IOException {
        LocalDate localDate = LocalDate.readExternal(dataInput);
        LocalTime localTime = LocalTime.readExternal(dataInput);
        return LocalDateTime.of(localDate, localTime);
    }
}

