/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class SessionKeyRef
extends PhantomReference<P11Key>
implements Comparable<SessionKeyRef> {
    static ReferenceQueue<P11Key> refQueue = new ReferenceQueue();
    private static Set<SessionKeyRef> refList = Collections.synchronizedSortedSet(new TreeSet());
    private long keyID;
    Session session;

    SessionKeyRef(P11Key p11Key, long l, Session session) {
        super(p11Key, refQueue);
        this.keyID = l;
        this.session = session;
        this.session.addObject();
        refList.add(this);
    }

    void disposeNative(Session session) throws PKCS11Exception {
        this.session.token.p11.C_DestroyObject(session.id(), this.keyID);
    }

    void dispose() {
        refList.remove(this);
        this.clear();
        this.session.removeObject();
    }

    @Override
    public int compareTo(SessionKeyRef sessionKeyRef) {
        if (this.keyID == sessionKeyRef.keyID) {
            return 0;
        }
        return this.keyID < sessionKeyRef.keyID ? -1 : 1;
    }
}

