/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class P11TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private TlsKeyMaterialParameterSpec spec;
    private P11Key p11Key;
    private int version;
    private final boolean supportSSLv3;

    P11TlsKeyMaterialGenerator(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        this.supportSSLv3 = l == 882L;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        TlsKeyMaterialParameterSpec tlsKeyMaterialParameterSpec = (TlsKeyMaterialParameterSpec)algorithmParameterSpec;
        this.version = tlsKeyMaterialParameterSpec.getMajorVersion() << 8 | tlsKeyMaterialParameterSpec.getMinorVersion();
        if (this.version == 768 && !this.supportSSLv3 || this.version < 768 || this.version > 771) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, TLS 1.1, and TLS 1.2 are supported");
        }
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, tlsKeyMaterialParameterSpec.getMasterSecret(), "TlsMasterSecret");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
        this.spec = tlsKeyMaterialParameterSpec;
        if (this.version == 768) {
            this.mechanism = 882L;
        } else if (this.version == 769 || this.version == 770) {
            this.mechanism = 886L;
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        boolean bl;
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        int n = this.spec.getMacKeyLength() << 3;
        int n2 = this.spec.getIvLength() << 3;
        int n3 = this.spec.getExpandedCipherKeyLength() << 3;
        int n4 = this.spec.getCipherKeyLength() << 3;
        if (n3 != 0) {
            bl = true;
        } else {
            bl = false;
            n3 = n4;
        }
        CK_SSL3_RANDOM_DATA cK_SSL3_RANDOM_DATA = new CK_SSL3_RANDOM_DATA(this.spec.getClientRandom(), this.spec.getServerRandom());
        Object object = null;
        CK_MECHANISM cK_MECHANISM = null;
        if (this.version < 771) {
            object = new CK_SSL3_KEY_MAT_PARAMS(n, n4, n2, bl, cK_SSL3_RANDOM_DATA);
            cK_MECHANISM = new CK_MECHANISM(this.mechanism, (CK_SSL3_KEY_MAT_PARAMS)object);
        } else if (this.version == 771) {
            object = new CK_TLS12_KEY_MAT_PARAMS(n, n4, n2, bl, cK_SSL3_RANDOM_DATA, Functions.getHashMechId(this.spec.getPRFHashAlg()));
            cK_MECHANISM = new CK_MECHANISM(this.mechanism, (CK_TLS12_KEY_MAT_PARAMS)object);
        }
        String string = this.spec.getCipherAlgorithm();
        long l = P11SecretKeyFactory.getKeyType(string);
        if (l < 0L) {
            if (n4 != 0) {
                throw new ProviderException("Unknown algorithm: " + this.spec.getCipherAlgorithm());
            }
            l = 16L;
        }
        Session session = null;
        try {
            SecretKey secretKey;
            SecretKey secretKey2;
            SecretKey secretKey3;
            SecretKey secretKey4;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = n4 != 0 ? new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, l), new CK_ATTRIBUTE(353L, n3 >> 3)} : new CK_ATTRIBUTE[]{};
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, l, cK_ATTRIBUTEArray);
            long l2 = this.token.p11.C_DeriveKey(session.id(), cK_MECHANISM, this.p11Key.keyID, cK_ATTRIBUTEArray);
            CK_SSL3_KEY_MAT_OUT cK_SSL3_KEY_MAT_OUT = null;
            if (object instanceof CK_SSL3_KEY_MAT_PARAMS) {
                cK_SSL3_KEY_MAT_OUT = ((CK_SSL3_KEY_MAT_PARAMS)object).pReturnedKeyMaterial;
            } else if (object instanceof CK_TLS12_KEY_MAT_PARAMS) {
                cK_SSL3_KEY_MAT_OUT = ((CK_TLS12_KEY_MAT_PARAMS)object).pReturnedKeyMaterial;
            }
            if (n != 0) {
                secretKey4 = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hClientMacSecret, "MAC", n, cK_ATTRIBUTEArray);
                secretKey3 = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hServerMacSecret, "MAC", n, cK_ATTRIBUTEArray);
            } else {
                if (cK_SSL3_KEY_MAT_OUT.hClientMacSecret != 0L) {
                    this.token.p11.C_DestroyObject(session.id(), cK_SSL3_KEY_MAT_OUT.hClientMacSecret);
                }
                if (cK_SSL3_KEY_MAT_OUT.hServerMacSecret != 0L) {
                    this.token.p11.C_DestroyObject(session.id(), cK_SSL3_KEY_MAT_OUT.hServerMacSecret);
                }
                secretKey4 = null;
                secretKey3 = null;
            }
            if (n4 != 0) {
                secretKey2 = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hClientKey, string, n3, cK_ATTRIBUTEArray);
                secretKey = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hServerKey, string, n3, cK_ATTRIBUTEArray);
            } else {
                if (cK_SSL3_KEY_MAT_OUT.hClientKey != 0L) {
                    this.token.p11.C_DestroyObject(session.id(), cK_SSL3_KEY_MAT_OUT.hClientKey);
                }
                if (cK_SSL3_KEY_MAT_OUT.hServerKey != 0L) {
                    this.token.p11.C_DestroyObject(session.id(), cK_SSL3_KEY_MAT_OUT.hServerKey);
                }
                secretKey2 = null;
                secretKey = null;
            }
            IvParameterSpec ivParameterSpec = cK_SSL3_KEY_MAT_OUT.pIVClient == null ? null : new IvParameterSpec(cK_SSL3_KEY_MAT_OUT.pIVClient);
            IvParameterSpec ivParameterSpec2 = cK_SSL3_KEY_MAT_OUT.pIVServer == null ? null : new IvParameterSpec(cK_SSL3_KEY_MAT_OUT.pIVServer);
            TlsKeyMaterialSpec tlsKeyMaterialSpec = new TlsKeyMaterialSpec(secretKey4, secretKey3, secretKey2, ivParameterSpec, secretKey, ivParameterSpec2);
            return tlsKeyMaterialSpec;
        }
        catch (Exception exception) {
            throw new ProviderException("Could not generate key", exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

