/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import org.apache.commons.codec.binary.Hex;

public class SqlContext_MySQL
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";
    public static final String DRIVER_CLASS_NAME_v8 = "com.mysql.cj.jdbc.Driver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"com.mysql.jdbc.Driver"};
    public static final int PORT_DEFAULT = 3306;
    private Map<Character, String> escapeCharacterMap;
    boolean NO_BACKSLASH_ESCAPES = true;
    private List<String> reservedWordList;

    public SqlContext_MySQL(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public Map<Character, String> getEscapeCharacterMap() {
        if (this.escapeCharacterMap == null) {
            this.escapeCharacterMap = new HashMap<Character, String>();
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.BS.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.BS.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.HT.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.HT.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.LF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.LF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.FF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.FF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.CR.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.CR.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.percentSign.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.percentSign.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.reverseSolidus.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.reverseSolidus.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.SUB.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.SUB.char_));
            if (this.NO_BACKSLASH_ESCAPES) {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.quotationMark.char_)) + String.valueOf(BcUnicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.apostrophe.char_)) + String.valueOf(BcUnicode.apostrophe.char_));
            } else {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.apostrophe.char_));
            }
        }
        return this.escapeCharacterMap;
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "SMALLINT";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize > 65) break;
                definition = "NUMERIC(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
                break;
            }
            default: {
                definition = super.type_NUMBER(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        int dataSize = mmdField.dataSize;
        switch (mmdField.sqlTypeId) {
            case -15: 
            case 1: {
                if (dataSize > 255) {
                    dataSize = 255;
                }
                definition = "CHAR" + SqlUtil.toSizeStr(dataSize);
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (dataSize <= 16383) {
                    definition = "VARCHAR" + SqlUtil.toSizeStr(dataSize);
                    break;
                }
                if (dataSize <= 65535) {
                    definition = "TEXT";
                    break;
                }
                if (dataSize <= 16777255) {
                    definition = "MEDIUMTEXT";
                    break;
                }
                definition = "LONGTEXT";
                break;
            }
            case 2005: 
            case 2011: {
                definition = dataSize <= 255 ? "TINYTEXT" : (dataSize <= 65535 ? "TEXT" : (dataSize <= 16777255 ? "MEDIUMTEXT" : "LONGTEXT"));
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        int dataSize = mmdField.dataSize;
        switch (mmdField.sqlTypeId) {
            case -2: {
                if (dataSize > 255) {
                    dataSize = 255;
                }
                definition = "BINARY" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case -4: 
            case -3: 
            case 2004: {
                definition = dataSize <= 65535 ? "BLOB" : (dataSize <= 16777255 ? "MEDIUMBLOB" : "LONGBLOB");
            }
        }
        return definition;
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy-MM-dd";
    }

    @Override
    public String setLimit(String srcSql, long limit, long offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0L) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0L) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("MID(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    @Override
    public String createCreateTableQuery_primaryKey(MmdModel mmdModel, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            sb.append("PRIMARY KEY");
            sb.append(" (");
            int i = 0;
            while (i < primaryKey.indexElementList.size()) {
                MmdIndexElement indexElement = primaryKey.indexElementList.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(indexElement.columnName);
                ++i;
            }
            sb.append(")");
            sb.append(lineSep);
        }
        return sb.toString();
    }

    @Override
    public String createBinaryInsert(byte[] bytes) throws Exception {
        String hex = new String(Hex.encodeHex((byte[])bytes));
        return "UNHEX(" + BcStringUtil.singleQuotation(hex) + ")";
    }

    @Override
    public boolean isReservedWord(String word) throws Exception {
        if (this.reservedWordList == null) {
            this.reservedWordList = this.cretaeReservedWordList("mysql_8");
        }
        return this.reservedWordList.contains(word.toLowerCase());
    }

    public List<String> createReservedWordList(SqlConnection sqlConn) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        String query = "SELECT word FROM information_schema.KEYWORDS WHERE reserved = 1";
        SqlUtil.getValueCollection(sqlConn, query, 1, strList);
        int i = 0;
        while (i < strList.size()) {
            String word = (String)strList.get(i);
            strList.set(i, word.toLowerCase());
            ++i;
        }
        return strList;
    }
}

