/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

class JLogFormatter
extends SimpleFormatter {
    private String format;
    private int levelNameLength;
    private Map<Integer, String> levelNameMap = new HashMap<Integer, String>();

    public JLogFormatter() {
        this.levelNameMap.put(Level.OFF.intValue(), Level.OFF.getName());
        this.levelNameMap.put(Level.SEVERE.intValue(), Level.SEVERE.getName());
        this.levelNameMap.put(Level.WARNING.intValue(), "WARN");
        this.levelNameMap.put(Level.INFO.intValue(), Level.INFO.getName());
        this.levelNameMap.put(Level.CONFIG.intValue(), "DEBUG");
        this.levelNameMap.put(Level.FINE.intValue(), Level.FINE.getName());
        this.levelNameMap.put(Level.FINER.intValue(), Level.FINER.getName());
        this.levelNameMap.put(Level.FINEST.intValue(), Level.FINEST.getName());
        this.levelNameMap.put(Level.ALL.intValue(), Level.ALL.getName());
        for (Map.Entry<Integer, String> mapEntry : this.levelNameMap.entrySet()) {
            this.levelNameLength = Math.max(this.levelNameLength, mapEntry.getValue().length());
        }
        this.format = "%1$tF %1$tT.%1$tL %2$-" + this.levelNameLength + "s - %3$s%n";
    }

    @Override
    public synchronized String format(LogRecord logRecord) {
        String levelName = this.levelNameMap.get(logRecord.getLevel().intValue());
        return String.format(this.format, new Date(logRecord.getMillis()), levelName, logRecord.getMessage());
    }
}

