/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.renderer;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import jp.co.extreme.awt.AwtUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.doc.renderer.DcfShapeRenderingUtil;
import nlc.lib.barcode.DcfBarcodeRenderer;
import nlc.lib.doc.shape.barcode.DcfAbstractBarcodeShape;

public class DcfBarcodeShapeRenderer
implements Cloneable {
    protected DcfShapeRenderer shapeRenderer;

    public DcfBarcodeShapeRenderer(DcfShapeRenderer shapeRenderer) {
        this.shapeRenderer = shapeRenderer;
    }

    public void drawBarcodeShape(Graphics2D g2d, double bx, double by, DcfAbstractBarcodeShape barcodeShape) throws Exception {
        if (BcStringUtil.isEmpty(barcodeShape.value)) {
            return;
        }
        Rectangle2D.Double rectangle = new Rectangle2D.Double(bx + barcodeShape.getX(), by + barcodeShape.getY(), barcodeShape.getRectangle().width, barcodeShape.getRectangle().height);
        AwtUtil.crearClip(g2d);
        double stringHeight = 10.0;
        DcfBarcodeRenderer barcodeRenderer = DcfShapeRenderingUtil.createBarcodeRenderer(barcodeShape);
        double[] dim = barcodeRenderer.getSize(barcodeShape.value);
        double tx = ((RectangularShape)rectangle).getX() + (((RectangularShape)rectangle).getWidth() - dim[0]) / 2.0;
        double ty = ((RectangularShape)rectangle).getY() + (((RectangularShape)rectangle).getHeight() - dim[1]) / 2.0;
        barcodeRenderer.drawBarcode(g2d, tx, ty, barcodeShape.value);
    }
}

