/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TablePosition;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.layout.FxTitledPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableRow;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsDatasourcePane;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.model.XsysCompareCondition;
import jp.co.extreme.module.xdts.stub.XdtsSchemaStub;
import jp.co.extreme.scf6.fx.TmpTableViewPane;
import jp.co.extreme.sql.SqlWords;

public class XdtsSchemaComparePane
extends FxDecoratePane {
    FxFlowPane flowPane = new FxFlowPane(11);
    XdtsDatasourcePane datasourcePane1 = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.editDestination);
    XdtsDatasourcePane datasourcePane2 = new XdtsDatasourcePane(XdtsDatasourcePane.Mode.editDestination);
    Button executeButton;
    Button cancelButton;
    Stage stage = new FxStage();

    public XdtsSchemaComparePane() throws Exception {
        FxTitledPane titledPane1 = new FxTitledPane();
        titledPane1.setTitle(String.valueOf(SqlWords.getInstance().dataSource) + " 1");
        titledPane1.setPrefSize(this.datasourcePane1.getPrefWidth() + 20.0, this.datasourcePane1.getPrefHeight() + 20.0);
        titledPane1.setContentNode((Node)this.datasourcePane1);
        this.flowPane.addNodeUnit(new FxNodeUnit((Node)titledPane1, new Node[0]));
        this.flowPane.addNodeUnit(new FxNodeUnit((Node)new Label(), new Node[0]));
        FxTitledPane titledPane2 = new FxTitledPane();
        titledPane2.setTitle(String.valueOf(SqlWords.getInstance().dataSource) + " 2");
        titledPane2.setPrefSize(this.datasourcePane2.getPrefWidth() + 20.0, this.datasourcePane2.getPrefHeight() + 20.0);
        titledPane2.setContentNode((Node)this.datasourcePane2);
        this.flowPane.addNodeUnit(new FxNodeUnit((Node)titledPane2, new Node[0]));
        this.setCenter((Node)this.flowPane);
        this.executeButton = this.createButton(BcWords.getInstance().execute);
        this.cancelButton = this.createButton(BcWords.getInstance().cancel);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            XdtsProfile profile1 = new XdtsProfile();
            this.datasourcePane1.storeData(profile1);
            XdtsProfile profile2 = new XdtsProfile();
            this.datasourcePane2.storeData(profile2);
            XsysCompareCondition compareCondition = new XsysCompareCondition();
            compareCondition.profile1 = profile1;
            compareCondition.profile2 = profile2;
            compareCondition.isTable = true;
            compareCondition.isView = true;
            this.compare(compareCondition);
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void setProfile1(XdtsProfile profile) throws Exception {
        this.datasourcePane1.setData(profile);
    }

    protected void compare(XsysCompareCondition compareCondition) throws Exception {
        Object[] res = XdtsSchemaStub.getInstance().schemaCompare(compareCondition, FxUtil.getWindow((Node)this));
        BcResult result = (BcResult)res[0];
        BcTableModel tableTable = (BcTableModel)res[1];
        BcTableModel viewTable = (BcTableModel)res[2];
        Map tableFieldMap = (Map)res[3];
        Map viewFieldMap = (Map)res[4];
        FxTabPane tabPane = new FxTabPane();
        BcTableColumnModel tableColumnModel = this.createTableColumnModel();
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        int i = 0;
        while (i < result.getErrorList().size()) {
            Object value = result.getErrorList().get(i);
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(i + 1);
            row.add(value);
            tableModel.addRow(row);
            ++i;
        }
        FxTableView tableView = new FxTableView();
        FxTableUtil.createColumn(tableModel.getTableColumnModel(), tableView, null);
        FxTableRowList tableRowList = new FxTableRowList(tableModel);
        tableView.setItems(tableRowList);
        TmpTableViewPane tmpTableViewPane = new TmpTableViewPane();
        tmpTableViewPane.setTableView(tableView);
        tmpTableViewPane.tableControlPane.setData(tableModel.getTableColumnModel(), tableModel, null);
        tmpTableViewPane.tableControlPane.setTitle(XdtsWords.getInstance().Schema_comparison_results.toPlain());
        Tab tab = new Tab();
        tab.setClosable(false);
        tab.setText(tmpTableViewPane.tableControlPane.getTitle());
        tab.setContent((Node)tmpTableViewPane);
        tabPane.getTabs().add((Object)tab);
        FxStage stage = new FxStage();
        FxScene scene = new FxScene((Parent)tabPane);
        stage.setScene(scene);
        stage.setWidth(1200.0);
        stage.setHeight(780.0);
        stage.setResizable(true);
        stage.setTitle(XdtsWords.getInstance().Schema_comparison_results.toPlain());
        Image image = FxImageHelper.getImage("compare_61x64.png");
        stage.getIcons().add((Object)image);
        stage.show();
    }

    protected Tab createTab(BcTableModel bcTableModel, Map<String, BcTableModel> fieldMap, String title) throws Exception {
        SplitPane splitPane = new SplitPane();
        InnerTableView tableView = new InnerTableView();
        FxTableUtil.createColumn(bcTableModel.getTableColumnModel(), tableView, null);
        FxTableRowList tableRowList = new FxTableRowList(bcTableModel);
        tableView.setItems(tableRowList);
        tableView.fieldMap = fieldMap;
        tableView.borderPane = new FxBorderPane();
        splitPane.getItems().addAll((Object[])new Node[]{tableView, tableView.borderPane});
        splitPane.setDividerPositions(new double[]{0.2f, 0.8f});
        Tab tab = new Tab();
        tab.setClosable(false);
        tab.setText(title);
        tab.setContent((Node)splitPane);
        return tab;
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.columnName = "No.";
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 3;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.columnName = "\u5185\u5bb9";
        mmdField.dataClass = String.class;
        mmdField.columnCount = 160;
        tableColumn.setMmdField(mmdField);
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public void close() {
        this.stage.close();
    }

    public void show() throws Exception {
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(980.0);
        this.stage.setHeight(540.0);
        this.stage.setResizable(true);
        this.stage.setTitle(XdtsWords.getInstance().compareSchemas.toPlain());
        Image image = FxImageHelper.getImage("compare_61x64.png");
        this.stage.getIcons().add((Object)image);
        this.stage.showAndWait();
    }

    static /* synthetic */ void access$0(XdtsSchemaComparePane xdtsSchemaComparePane, Throwable throwable) {
        xdtsSchemaComparePane.handleException(throwable);
    }

    class InnerTableView<T>
    extends FxTableView<T> {
        Map<String, BcTableModel> fieldMap;
        FxBorderPane borderPane;

        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged(tableView, rowIdList, prevRowId, nextRowId);
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
            TablePosition tablePosition = (TablePosition)tablePositionList.get(0);
            FxTableRow tableRow = (FxTableRow)this.getItems().get(tablePosition.getRow());
            String tableName = (String)tableRow.getValue(0);
            BcTableModel filedTable = this.fieldMap.get(tableName);
            FxTableView fieldTableView = new FxTableView();
            FxTableUtil.createColumn(filedTable.getTableColumnModel(), fieldTableView, null);
            FxTableRowList tableRowList = new FxTableRowList(filedTable);
            fieldTableView.setItems(tableRowList);
            this.borderPane.setCenter((Node)fieldTableView);
        }
    }
}

