/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.effect.Effect;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.util.FxColorUtil;
import jp.co.extreme.fx.util.FxEffectUtil;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xsod.common.XsodConstants;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.model.XsodMerchandisePack;

public class XsodUiFactory
extends FxBorderPane {
    public double opacity = 0.4;
    public double windowWidth;
    public double windowHeight;
    public double categorySpacing;
    public double buttonSpacing1;
    public double seatsTopHeight;
    public double langButtonWidth;
    public double category1Height;
    public double category2Width;
    public double orderPlanWidth;
    public double menuDetailWidth;
    public double menuDetailHeight;
    public double orderPlanMax;
    public Insets insets1;
    public Font defaultFont;
    public Font titleFont;
    public double orderPlanRowHeight;
    public Font orderPlanFont;
    int menuDetaiColCount;
    public double recommendedTopHeight;
    public double recommendedBottomHeight;
    public double recommendedWidth;
    public double recommendedHeight;

    public static XsodUiFactory getInstance() {
        return SingletonHolder.instance;
    }

    public HBox createHBox() throws Exception {
        HBox hBox = new HBox();
        hBox.setPadding(this.insets1);
        hBox.setSpacing(this.buttonSpacing1);
        return hBox;
    }

    public VBox createVBox() throws Exception {
        VBox vBox = new VBox();
        vBox.setPadding(this.insets1);
        vBox.setSpacing(this.buttonSpacing1);
        return vBox;
    }

    public Text createText(String str) throws Exception {
        Text text = new Text();
        text.setFont(this.defaultFont);
        text.setText(str);
        return text;
    }

    public Pane createTextPane(Font font, double innerStrokeWidth, double outerStrokeWidth, Color fillColor, Color strokeColor, String str) throws Exception {
        Pane basePane = new Pane();
        if (BcStringUtil.isEmpty(str)) {
            return basePane;
        }
        Text text1 = new Text();
        text1.setFont(font);
        text1.setStrokeWidth(outerStrokeWidth);
        text1.setStroke((Paint)strokeColor);
        text1.setText(str);
        text1.setLayoutY(text1.getLayoutBounds().getHeight());
        basePane.getChildren().add((Object)text1);
        Text text2 = new Text();
        text2.setFont(font);
        text2.setFill((Paint)fillColor);
        text2.setStrokeWidth(innerStrokeWidth);
        text2.setStroke((Paint)fillColor);
        text2.setText(str);
        text2.setLayoutY(text2.getLayoutBounds().getHeight());
        basePane.getChildren().add((Object)text2);
        text1.setEffect((Effect)FxEffectUtil.createDropShadow());
        double xm = 0.0;
        double ym = 10.0;
        Dimension2D dim = new Dimension2D(text1.getLayoutBounds().getWidth() + xm, text1.getLayoutBounds().getHeight() + ym);
        FxUtil.setFixedSize((Region)basePane, dim);
        return basePane;
    }

    public Pane createTextPane(Font font, Color fillColor, Color strokeColor, String str) throws Exception {
        double innerStrokeWidth = font.getSize() / 16.0;
        double outerStrokeWidth = font.getSize() / 5.0;
        return this.createTextPane(font, innerStrokeWidth, outerStrokeWidth, fillColor, strokeColor, str);
    }

    public Text createText(Font font, double strokeWidth, Color fillColor, Color strokeColor, String str) throws Exception {
        BcLogUtil.debug("------ str=" + str + " strokeWidth=" + strokeWidth);
        Text text = new Text();
        text.setText(str);
        text.setFont(font);
        text.setFill((Paint)fillColor);
        if (strokeWidth > 0.0) {
            text.setStrokeWidth(strokeWidth);
            text.setStroke((Paint)strokeColor);
        }
        text.setEffect((Effect)FxEffectUtil.createDropShadow());
        return text;
    }

    public Text createText1(Font font, Color fillColor, Color strokeColor, String str) throws Exception {
        Text text = new Text();
        text.setText(str);
        text.setFont(font);
        text.setFill((Paint)fillColor);
        text.setEffect((Effect)FxEffectUtil.createDropShadow());
        return text;
    }

    public Button createButton(String str) throws Exception {
        Button button = new Button();
        button.setFont(this.defaultFont);
        button.setText(str);
        button.setEffect((Effect)FxEffectUtil.createDropShadow());
        return button;
    }

    public Button createButton2(String str) throws Exception {
        Text text = new Text();
        text.setFill((Paint)Color.BLACK);
        text.setStrokeWidth(1.5);
        text.setStroke((Paint)Color.BLACK);
        text.setFont(this.defaultFont);
        text.setText(str);
        text.setTextAlignment(TextAlignment.CENTER);
        FxBorderPane borderPane = new FxBorderPane();
        borderPane.setCenter((Node)text);
        Button button = new Button();
        button.setGraphic((Node)borderPane);
        button.setPrefSize(250.0, 50.0);
        button.setEffect((Effect)FxEffectUtil.createDropShadow());
        return button;
    }

    public void setBgPane(Node bgNode, Color baseColor, double opacity) throws Exception {
        Color color1;
        Color color2 = color1 = FxColorUtil.setOpacity(baseColor, opacity);
        StringBuilder style = new StringBuilder();
        BcStringUtil.appendExceptEmpty(style, ";", FxCssUtil.css_backgroundColor_linearGradient(color1, color2, 0));
        bgNode.setStyle(style.toString());
    }

    public StackPane createBackgrondNode(Node node1, Color color1, double opacity) throws Exception {
        StackPane stackPane = new StackPane();
        this.setBgPane(node1, color1, opacity);
        stackPane.getChildren().addAll((Object[])new Node[]{node1});
        return stackPane;
    }

    public StackPane createBackgrondNode(Node node1, Color color1) throws Exception {
        return this.createBackgrondNode(node1, color1, this.opacity);
    }

    public void setWindowSize(double windowWidth, double windowHeight) throws Exception {
        BcLogUtil.info("setWindowSize:windowWidth=" + windowWidth + " windowHeight=" + windowHeight);
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        if (windowWidth >= (double)XsodConstants.SIZE_1920x1200[0] && windowHeight >= (double)XsodConstants.SIZE_1920x1200[1]) {
            BcLogUtil.info("setWindowSize:#1  \u6a2a");
            this.categorySpacing = 8.0;
            this.buttonSpacing1 = 10.0;
            this.seatsTopHeight = 60.0;
            this.langButtonWidth = 60.0;
            this.category1Height = 140.0;
            this.category2Width = 320.0;
            this.orderPlanMax = 8.0;
            this.orderPlanWidth = 480.0;
            this.menuDetaiColCount = 3;
            this.insets1 = new Insets(10.0, 10.0, 10.0, 10.0);
            this.defaultFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)34.0);
            this.titleFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)100.0);
            FxFlowPane bummyFlowPane = new FxFlowPane(11);
            double menuDetailBaseWidth = windowWidth - this.category2Width - this.orderPlanWidth - this.categorySpacing * 4.0 - 40.0;
            BcLogUtil.debug("menuDetailBaseWidth=" + menuDetailBaseWidth);
            double frowWidth = menuDetailBaseWidth - bummyFlowPane.leftMargin * 2.0 - bummyFlowPane.unitSpace * (double)(this.menuDetaiColCount - 1);
            this.menuDetailWidth = frowWidth / (double)this.menuDetaiColCount;
            this.menuDetailHeight = 300.0;
            this.orderPlanRowHeight = 80.0;
            this.orderPlanFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)28.0);
            this.recommendedTopHeight = 120.0;
            this.recommendedBottomHeight = 100.0;
            this.recommendedWidth = windowWidth - 160.0;
            this.recommendedHeight = windowHeight - this.recommendedTopHeight - this.recommendedBottomHeight - 30.0;
        } else if (windowWidth >= (double)XsodConstants.SIZE_1920x1080[0] && windowHeight >= (double)XsodConstants.SIZE_1920x1080[1]) {
            BcLogUtil.info("setWindowSize:#2 \u7e26");
            this.categorySpacing = 8.0;
            this.buttonSpacing1 = 10.0;
            this.seatsTopHeight = 60.0;
            this.langButtonWidth = 60.0;
            this.category1Height = 140.0;
            this.category2Width = 320.0;
            this.orderPlanMax = 8.0;
            this.orderPlanWidth = 480.0;
            this.menuDetaiColCount = 3;
            this.insets1 = new Insets(10.0, 10.0, 10.0, 10.0);
            this.defaultFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)34.0);
            this.titleFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)80.0);
            FxFlowPane bummyFlowPane = new FxFlowPane();
            double menuDetailBaseWidth = windowWidth - this.category2Width - this.orderPlanWidth - this.categorySpacing * 4.0 - 40.0;
            BcLogUtil.debug("menuDetailBaseWidth=" + menuDetailBaseWidth);
            double frowWidth = menuDetailBaseWidth - bummyFlowPane.leftMargin * 2.0 - bummyFlowPane.unitSpace * (double)(this.menuDetaiColCount - 1);
            this.menuDetailWidth = frowWidth / (double)this.menuDetaiColCount;
            this.menuDetailHeight = 300.0;
            this.orderPlanRowHeight = 80.0;
            this.orderPlanFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)28.0);
            this.recommendedTopHeight = 140.0;
            this.recommendedBottomHeight = 120.0;
            this.recommendedWidth = windowWidth - 180.0;
            this.recommendedHeight = windowHeight - this.recommendedTopHeight - this.recommendedBottomHeight;
        } else {
            BcLogUtil.info("############# setWindowSize:#9");
            this.categorySpacing = 8.0;
            this.buttonSpacing1 = 10.0;
            this.seatsTopHeight = 60.0;
            this.langButtonWidth = 60.0;
            this.category1Height = 140.0;
            this.category2Width = 320.0;
            this.orderPlanMax = 8.0;
            this.orderPlanWidth = 480.0;
            this.menuDetaiColCount = 3;
            this.insets1 = new Insets(10.0, 10.0, 10.0, 10.0);
            this.defaultFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)34.0);
            this.titleFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)80.0);
            FxFlowPane bummyFlowPane = new FxFlowPane();
            double menuDetailBaseWidth = windowWidth - this.category2Width - this.orderPlanWidth - this.categorySpacing * 4.0 - 40.0;
            BcLogUtil.debug("menuDetailBaseWidth=" + menuDetailBaseWidth);
            double frowWidth = menuDetailBaseWidth - bummyFlowPane.leftMargin * 2.0 - bummyFlowPane.unitSpace * (double)(this.menuDetaiColCount - 1);
            this.menuDetailWidth = frowWidth / (double)this.menuDetaiColCount;
            this.menuDetailHeight = 300.0;
            this.orderPlanRowHeight = 80.0;
            this.orderPlanFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)28.0);
            this.recommendedTopHeight = 110.0;
            this.recommendedBottomHeight = 80.0;
            this.recommendedWidth = windowWidth - 160.0;
            this.recommendedHeight = windowHeight - this.recommendedTopHeight - this.recommendedBottomHeight;
        }
    }

    public FlowPane createMenuName(XsodMerchandisePack merchandisePack, double targetWidth, double fontSize) throws Exception {
        double unitAmountFontSize = fontSize * 0.7;
        double taxNotIncludedFontSize = fontSize * 0.4;
        FlowPane flowPane = new FlowPane(Orientation.HORIZONTAL);
        flowPane.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        flowPane.setHgap(20.0);
        String merchandiseName = XsodUtil.getName(merchandisePack.merchandise, XsodConstants.defaultLang1, true);
        Font merchandiseNameFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        Pane merchandiseNameText = XsodUiFactory.getInstance().createTextPane(merchandiseNameFont, Color.BLACK, Color.WHITE, merchandiseName);
        flowPane.getChildren().add((Object)merchandiseNameText);
        String unitAmount = BcNumberUtil.toString(merchandisePack.merchandise.unitAmount, 0);
        unitAmount = "\uffe5" + unitAmount;
        Font unitAmountFont = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)unitAmountFontSize);
        Pane unitAmountText = XsodUiFactory.getInstance().createTextPane(unitAmountFont, Color.RED, Color.WHITE, unitAmount);
        flowPane.getChildren().add((Object)unitAmountText);
        double height = merchandiseNameText.getHeight();
        flowPane.setMaxSize(targetWidth, height);
        FxUtil.setFixedSize((Region)flowPane, targetWidth, height);
        return flowPane;
    }

    public HBox createSoldOutOane(double fontSize) throws Exception {
        HBox hbox = new HBox();
        hbox.setAlignment(Pos.CENTER);
        String word = "\u58f2\u308a\u5207\u308c!";
        Font font = Font.font((String)"MS PMincho", (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        Pane text = XsodUiFactory.getInstance().createTextPane(font, Color.RED, Color.WHITE, word);
        hbox.getChildren().add((Object)text);
        return hbox;
    }

    public void setCenterX(Region region, final Node node, final double margin) throws Exception {
        double x = (region.getWidth() - node.getLayoutBounds().getWidth()) / 2.0 + margin;
        node.setLayoutX(x);
        region.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldWidth, Number newWidth) {
                double x = (newWidth.doubleValue() - node.getLayoutBounds().getWidth()) / 2.0 + margin;
                node.setLayoutX(x);
            }
        });
    }

    public void setCenterX(Region region, Node node) throws Exception {
        this.setCenterX(region, node, 0.0);
    }

    public void setCenterY(Region region, final Node node, final double margin) throws Exception {
        double y = (region.getHeight() - node.getLayoutBounds().getHeight()) / 2.0 + margin;
        node.setLayoutY(y);
        region.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldWidth, Number newWidth) {
                double y = (newWidth.doubleValue() - node.getLayoutBounds().getHeight()) / 2.0 + margin;
                node.setLayoutY(y);
            }
        });
    }

    public void setCenterY(Region region, Node node) throws Exception {
        this.setCenterY(region, node, 0.0);
    }

    private static final class SingletonHolder {
        private static final XsodUiFactory instance = new XsodUiFactory();

        private SingletonHolder() {
        }
    }
}

