/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

final class UnresolvedPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient Map<String, List<UnresolvedPermission>> perms = new HashMap<String, List<UnresolvedPermission>>(11);
    private static final long serialVersionUID = -7176153071733132400L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        List<UnresolvedPermission> list;
        if (!(permission instanceof UnresolvedPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        UnresolvedPermission unresolvedPermission = (UnresolvedPermission)permission;
        Object object = this;
        synchronized (object) {
            list = this.perms.get(unresolvedPermission.getName());
            if (list == null) {
                list = new ArrayList<UnresolvedPermission>();
                this.perms.put(unresolvedPermission.getName(), list);
            }
        }
        object = list;
        synchronized (object) {
            list.add(unresolvedPermission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UnresolvedPermission> getUnresolvedPermissions(Permission permission) {
        UnresolvedPermissionCollection unresolvedPermissionCollection = this;
        synchronized (unresolvedPermissionCollection) {
            return this.perms.get(permission.getClass().getName());
        }
    }

    @Override
    public boolean implies(Permission permission) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        ArrayList<UnresolvedPermission> arrayList = new ArrayList<UnresolvedPermission>();
        UnresolvedPermissionCollection unresolvedPermissionCollection = this;
        synchronized (unresolvedPermissionCollection) {
            Iterator<List<UnresolvedPermission>> iterator = this.perms.values().iterator();
            while (iterator.hasNext()) {
                List<UnresolvedPermission> list;
                List<UnresolvedPermission> list2 = list = iterator.next();
                synchronized (list2) {
                    arrayList.addAll(list);
                }
            }
        }
        return Collections.enumeration(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.perms.size() * 2);
        Object object = this;
        synchronized (object) {
            Set<Map.Entry<String, List<UnresolvedPermission>>> set = this.perms.entrySet();
            for (Map.Entry<String, List<UnresolvedPermission>> entry : set) {
                List<UnresolvedPermission> list = entry.getValue();
                Vector<UnresolvedPermission> vector = new Vector<UnresolvedPermission>(list.size());
                List<UnresolvedPermission> list2 = list;
                synchronized (list2) {
                    vector.addAll(list);
                }
                hashtable.put(entry.getKey(), vector);
            }
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("permissions", hashtable);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        try {
            Hashtable hashtable = (Hashtable)getField.get("permissions", null);
            if (hashtable == null) {
                throw new InvalidObjectException("Invalid null permissions");
            }
            this.perms = new ConcurrentHashMap<String, List<UnresolvedPermission>>(hashtable.size() * 2);
            Set set = hashtable.entrySet();
            for (Map.Entry entry : set) {
                Vector vector = (Vector)entry.getValue();
                CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList(vector);
                this.perms.put((String)entry.getKey(), copyOnWriteArrayList);
            }
        }
        catch (ClassCastException classCastException) {
            throw new InvalidObjectException("Invalid type for permissions");
        }
    }
}

