/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.net.www.ParseUtil;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public class PolicyParser {
    private static final String EXTDIRS_PROPERTY = "java.ext.dirs";
    private static final String OLD_EXTDIRS_EXPANSION = "${java.ext.dirs}";
    static final String EXTDIRS_EXPANSION = "${{java.ext.dirs}}";
    private Vector<GrantEntry> grantEntries = new Vector();
    private Map<String, DomainEntry> domainEntries;
    private static final Debug debug = Debug.getInstance("parser", "\t[Policy Parser]");
    private StreamTokenizer st;
    private int lookahead;
    private boolean expandProp = false;
    private String keyStoreUrlString = null;
    private String keyStoreType = null;
    private String keyStoreProvider = null;
    private String storePassURL = null;

    private String expand(String string) throws PropertyExpander.ExpandException {
        return this.expand(string, false);
    }

    private String expand(String string, boolean bl) throws PropertyExpander.ExpandException {
        if (!this.expandProp) {
            return string;
        }
        return PropertyExpander.expand(string, bl);
    }

    public PolicyParser() {
    }

    public PolicyParser(boolean bl) {
        this();
        this.expandProp = bl;
    }

    public void read(Reader reader) throws ParsingException, IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(46, 46);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(47);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.ordinaryChar(47);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.lookahead = this.st.nextToken();
        GrantEntry grantEntry = null;
        while (this.lookahead != -1) {
            if (this.peek("grant")) {
                grantEntry = this.parseGrantEntry();
                if (grantEntry != null) {
                    this.add(grantEntry);
                }
            } else if (this.peek("keystore") && this.keyStoreUrlString == null) {
                this.parseKeyStoreEntry();
            } else if (this.peek("keystorePasswordURL") && this.storePassURL == null) {
                this.parseStorePassURL();
            } else if (grantEntry == null && this.keyStoreUrlString == null && this.storePassURL == null && this.peek("domain")) {
                DomainEntry domainEntry;
                if (this.domainEntries == null) {
                    this.domainEntries = new TreeMap<String, DomainEntry>();
                }
                if ((domainEntry = this.parseDomainEntry()) != null) {
                    String string = domainEntry.getName();
                    if (!this.domainEntries.containsKey(string)) {
                        this.domainEntries.put(string, domainEntry);
                    } else {
                        MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("duplicate.keystore.domain.name"));
                        Object[] objectArray = new Object[]{string};
                        throw new ParsingException(messageFormat.format(objectArray));
                    }
                }
            }
            this.match(";");
        }
        if (this.keyStoreUrlString == null && this.storePassURL != null) {
            throw new ParsingException(ResourcesMgr.getString("keystorePasswordURL.can.not.be.specified.without.also.specifying.keystore"));
        }
    }

    public void add(GrantEntry grantEntry) {
        this.grantEntries.addElement(grantEntry);
    }

    public void replace(GrantEntry grantEntry, GrantEntry grantEntry2) {
        this.grantEntries.setElementAt(grantEntry2, this.grantEntries.indexOf(grantEntry));
    }

    public boolean remove(GrantEntry grantEntry) {
        return this.grantEntries.removeElement(grantEntry);
    }

    public String getKeyStoreUrl() {
        try {
            if (this.keyStoreUrlString != null && this.keyStoreUrlString.length() != 0) {
                return this.expand(this.keyStoreUrlString, true).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return null;
    }

    public void setKeyStoreUrl(String string) {
        this.keyStoreUrlString = string;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String string) {
        this.keyStoreType = string;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String string) {
        this.keyStoreProvider = string;
    }

    public String getStorePassURL() {
        try {
            if (this.storePassURL != null && this.storePassURL.length() != 0) {
                return this.expand(this.storePassURL, true).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return null;
    }

    public void setStorePassURL(String string) {
        this.storePassURL = string;
    }

    public Enumeration<GrantEntry> grantElements() {
        return this.grantEntries.elements();
    }

    public Collection<DomainEntry> getDomainEntries() {
        return this.domainEntries.values();
    }

    public void write(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        Enumeration<GrantEntry> enumeration = this.grantElements();
        printWriter.println("/* AUTOMATICALLY GENERATED ON " + new Date() + "*/");
        printWriter.println("/* DO NOT EDIT */");
        printWriter.println();
        if (this.keyStoreUrlString != null) {
            this.writeKeyStoreEntry(printWriter);
        }
        if (this.storePassURL != null) {
            this.writeStorePassURL(printWriter);
        }
        while (enumeration.hasMoreElements()) {
            GrantEntry grantEntry = enumeration.nextElement();
            grantEntry.write(printWriter);
            printWriter.println();
        }
        printWriter.flush();
    }

    private void parseKeyStoreEntry() throws ParsingException, IOException {
        this.match("keystore");
        this.keyStoreUrlString = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.keystore.type"));
        }
        this.keyStoreType = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.keystore.provider"));
        }
        this.keyStoreProvider = this.match("quoted string");
    }

    private void parseStorePassURL() throws ParsingException, IOException {
        this.match("keyStorePasswordURL");
        this.storePassURL = this.match("quoted string");
    }

    private void writeKeyStoreEntry(PrintWriter printWriter) {
        printWriter.print("keystore \"");
        printWriter.print(this.keyStoreUrlString);
        printWriter.print('\"');
        if (this.keyStoreType != null && !this.keyStoreType.isEmpty()) {
            printWriter.print(", \"" + this.keyStoreType + "\"");
        }
        if (this.keyStoreProvider != null && !this.keyStoreProvider.isEmpty()) {
            printWriter.print(", \"" + this.keyStoreProvider + "\"");
        }
        printWriter.println(";");
        printWriter.println();
    }

    private void writeStorePassURL(PrintWriter printWriter) {
        printWriter.print("keystorePasswordURL \"");
        printWriter.print(this.storePassURL);
        printWriter.print('\"');
        printWriter.println(";");
        printWriter.println();
    }

    private GrantEntry parseGrantEntry() throws ParsingException, IOException {
        Object object;
        int n;
        Object object2;
        GrantEntry grantEntry = new GrantEntry();
        LinkedList<PrincipalEntry> linkedList = null;
        boolean bl = false;
        this.match("grant");
        while (!this.peek("{")) {
            if (this.peekAndMatch("Codebase")) {
                if (grantEntry.codeBase != null) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple.Codebase.expressions"));
                }
                grantEntry.codeBase = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("SignedBy")) {
                if (grantEntry.signedBy != null) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple.SignedBy.expressions"));
                }
                grantEntry.signedBy = this.match("quoted string");
                object2 = new StringTokenizer(grantEntry.signedBy, ",", true);
                int n2 = 0;
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken().trim();
                    if (((String)object).equals(",")) {
                        ++n;
                        continue;
                    }
                    if (((String)object).isEmpty()) continue;
                    ++n2;
                }
                if (n2 <= n) {
                    throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("SignedBy.has.empty.alias"));
                }
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("Principal")) {
                String string;
                if (linkedList == null) {
                    linkedList = new LinkedList<PrincipalEntry>();
                }
                if (this.peek("\"")) {
                    object2 = "PolicyParser.REPLACE_NAME";
                    string = this.match("principal type");
                } else {
                    if (this.peek("*")) {
                        this.match("*");
                        object2 = "WILDCARD_PRINCIPAL_CLASS";
                    } else {
                        object2 = this.match("principal type");
                    }
                    if (this.peek("*")) {
                        this.match("*");
                        string = "WILDCARD_PRINCIPAL_NAME";
                    } else {
                        string = this.match("quoted string");
                    }
                    if (((String)object2).equals("WILDCARD_PRINCIPAL_CLASS") && !string.equals("WILDCARD_PRINCIPAL_NAME")) {
                        if (debug != null) {
                            debug.println("disallowing principal that has WILDCARD class but no WILDCARD name");
                        }
                        throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("can.not.specify.Principal.with.a.wildcard.class.without.a.wildcard.name"));
                    }
                }
                try {
                    string = this.expand(string);
                    if (((String)object2).equals("javax.security.auth.x500.X500Principal") && !string.equals("WILDCARD_PRINCIPAL_NAME")) {
                        X500Principal x500Principal = new X500Principal(new X500Principal(string).toString());
                        string = x500Principal.getName();
                    }
                    linkedList.add(new PrincipalEntry((String)object2, string));
                }
                catch (PropertyExpander.ExpandException expandException) {
                    if (debug != null) {
                        debug.println("principal name expansion failed: " + string);
                    }
                    bl = true;
                }
                this.peekAndMatch(",");
                continue;
            }
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.codeBase.or.SignedBy.or.Principal"));
        }
        if (linkedList != null) {
            grantEntry.principals = linkedList;
        }
        this.match("{");
        while (!this.peek("}")) {
            if (this.peek("Permission")) {
                try {
                    object2 = this.parsePermissionEntry();
                    grantEntry.add((PermissionEntry)object2);
                }
                catch (PropertyExpander.ExpandException expandException) {
                    if (debug != null) {
                        debug.println(expandException.toString());
                    }
                    this.skipEntry();
                }
                this.match(";");
                continue;
            }
            throw new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.permission.entry"));
        }
        this.match("}");
        try {
            if (grantEntry.signedBy != null) {
                grantEntry.signedBy = this.expand(grantEntry.signedBy);
            }
            if (grantEntry.codeBase != null) {
                int n3;
                if (grantEntry.codeBase.equals(OLD_EXTDIRS_EXPANSION)) {
                    grantEntry.codeBase = EXTDIRS_EXPANSION;
                }
                if ((n3 = grantEntry.codeBase.indexOf(EXTDIRS_EXPANSION)) < 0) {
                    grantEntry.codeBase = this.expand(grantEntry.codeBase, true).replace(File.separatorChar, '/');
                } else {
                    String[] stringArray = PolicyParser.parseExtDirs(grantEntry.codeBase, n3);
                    if (stringArray != null && stringArray.length > 0) {
                        for (n = 0; n < stringArray.length; ++n) {
                            object = (GrantEntry)grantEntry.clone();
                            ((GrantEntry)object).codeBase = stringArray[n];
                            this.add((GrantEntry)object);
                            if (debug == null) continue;
                            debug.println("creating policy entry for expanded java.ext.dirs path:\n\t\t" + stringArray[n]);
                        }
                    }
                    bl = true;
                }
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return bl ? null : grantEntry;
    }

    private PermissionEntry parsePermissionEntry() throws ParsingException, IOException, PropertyExpander.ExpandException {
        PermissionEntry permissionEntry = new PermissionEntry();
        this.match("Permission");
        permissionEntry.permission = this.match("permission type");
        if (this.peek("\"")) {
            permissionEntry.name = this.expand(this.match("quoted string"));
        }
        if (!this.peek(",")) {
            return permissionEntry;
        }
        this.match(",");
        if (this.peek("\"")) {
            permissionEntry.action = this.expand(this.match("quoted string"));
            if (!this.peek(",")) {
                return permissionEntry;
            }
            this.match(",");
        }
        if (this.peekAndMatch("SignedBy")) {
            permissionEntry.signedBy = this.expand(this.match("quoted string"));
        }
        return permissionEntry;
    }

    private DomainEntry parseDomainEntry() throws ParsingException, IOException {
        boolean bl = false;
        String string = null;
        HashMap<String, String> hashMap = new HashMap();
        this.match("domain");
        string = this.match("domain name");
        while (!this.peek("{")) {
            hashMap = this.parseProperties("{");
        }
        this.match("{");
        DomainEntry domainEntry = new DomainEntry(string, hashMap);
        while (!this.peek("}")) {
            this.match("keystore");
            string = this.match("keystore name");
            if (!this.peek("}")) {
                hashMap = this.parseProperties(";");
            }
            this.match(";");
            domainEntry.add(new KeyStoreEntry(string, hashMap));
        }
        this.match("}");
        return bl ? null : domainEntry;
    }

    private Map<String, String> parseProperties(String string) throws ParsingException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (!this.peek(string)) {
            String string2;
            String string3 = this.match("property name");
            this.match("=");
            try {
                string2 = this.expand(this.match("quoted string"));
            }
            catch (PropertyExpander.ExpandException expandException) {
                throw new IOException(expandException.getLocalizedMessage());
            }
            hashMap.put(string3.toLowerCase(Locale.ENGLISH), string2);
        }
        return hashMap;
    }

    static String[] parseExtDirs(String string, int n) {
        String string2 = System.getProperty(EXTDIRS_PROPERTY);
        String string3 = n > 0 ? string.substring(0, n) : "file:";
        int n2 = n + EXTDIRS_EXPANSION.length();
        String string4 = n2 < string.length() ? string.substring(n2) : (String)null;
        String[] stringArray = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            int n3 = stringTokenizer.countTokens();
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                File file = new File(stringTokenizer.nextToken());
                stringArray[i] = ParseUtil.encodePath(file.getAbsolutePath());
                if (!stringArray[i].startsWith("/")) {
                    stringArray[i] = "/" + stringArray[i];
                }
                String string5 = string4 == null ? (stringArray[i].endsWith("/") ? "*" : "/*") : string4;
                stringArray[i] = string3 + stringArray[i] + string5;
            }
        }
        return stringArray;
    }

    private boolean peekAndMatch(String string) throws ParsingException, IOException {
        if (this.peek(string)) {
            this.match(string);
            return true;
        }
        return false;
    }

    private boolean peek(String string) {
        boolean bl = false;
        switch (this.lookahead) {
            case -3: {
                if (!string.equalsIgnoreCase(this.st.sval)) break;
                bl = true;
                break;
            }
            case 44: {
                if (!string.equalsIgnoreCase(",")) break;
                bl = true;
                break;
            }
            case 123: {
                if (!string.equalsIgnoreCase("{")) break;
                bl = true;
                break;
            }
            case 125: {
                if (!string.equalsIgnoreCase("}")) break;
                bl = true;
                break;
            }
            case 34: {
                if (!string.equalsIgnoreCase("\"")) break;
                bl = true;
                break;
            }
            case 42: {
                if (!string.equalsIgnoreCase("*")) break;
                bl = true;
                break;
            }
            case 59: {
                if (!string.equalsIgnoreCase(";")) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String match(String string) throws ParsingException, IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParsingException(this.st.lineno(), string, ResourcesMgr.getString("number.") + String.valueOf(this.st.nval));
            }
            case -1: {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("expected.expect.read.end.of.file."));
                Object[] objectArray = new Object[]{string};
                throw new ParsingException(messageFormat.format(objectArray));
            }
            case -3: {
                if (string.equalsIgnoreCase(this.st.sval)) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("principal type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("domain name") || string.equalsIgnoreCase("keystore name") || string.equalsIgnoreCase("property name")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 34: {
                if (string.equalsIgnoreCase("quoted string")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("principal type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 44: {
                if (string.equalsIgnoreCase(",")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ",");
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "{");
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "}");
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ";");
            }
            case 42: {
                if (string.equalsIgnoreCase("*")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "*");
            }
            case 61: {
                if (string.equalsIgnoreCase("=")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "=");
            }
            default: {
                throw new ParsingException(this.st.lineno(), string, new String(new char[]{(char)this.lookahead}));
            }
        }
        return string2;
    }

    private void skipEntry() throws ParsingException, IOException {
        while (this.lookahead != 59) {
            switch (this.lookahead) {
                case -2: {
                    throw new ParsingException(this.st.lineno(), ";", ResourcesMgr.getString("number.") + String.valueOf(this.st.nval));
                }
                case -1: {
                    throw new ParsingException(ResourcesMgr.getString("expected.read.end.of.file."));
                }
            }
            this.lookahead = this.st.nextToken();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        try (FileReader fileReader = new FileReader(stringArray[0]);
             FileWriter fileWriter = new FileWriter(stringArray[1]);){
            PolicyParser policyParser = new PolicyParser(true);
            policyParser.read(fileReader);
            policyParser.write(fileWriter);
        }
    }

    public static class ParsingException
    extends GeneralSecurityException {
        private static final long serialVersionUID = -4330692689482574072L;
        private String i18nMessage;

        public ParsingException(String string) {
            super(string);
            this.i18nMessage = string;
        }

        public ParsingException(int n, String string) {
            super("line " + n + ": " + string);
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("line.number.msg"));
            Object[] objectArray = new Object[]{new Integer(n), string};
            this.i18nMessage = messageFormat.format(objectArray);
        }

        public ParsingException(int n, String string, String string2) {
            super("line " + n + ": expected [" + string + "], found [" + string2 + "]");
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("line.number.expected.expect.found.actual."));
            Object[] objectArray = new Object[]{new Integer(n), string, string2};
            this.i18nMessage = messageFormat.format(objectArray);
        }

        @Override
        public String getLocalizedMessage() {
            return this.i18nMessage;
        }
    }

    static class KeyStoreEntry {
        private final String name;
        private final Map<String, String> properties;

        KeyStoreEntry(String string, Map<String, String> map) {
            this.name = string;
            this.properties = map;
        }

        String getName() {
            return this.name;
        }

        Map<String, String> getProperties() {
            return this.properties;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("\n    keystore ").append(this.name);
            if (this.properties != null) {
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    stringBuilder.append("\n        ").append(entry.getKey()).append('=').append(entry.getValue());
                }
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }
    }

    static class DomainEntry {
        private final String name;
        private final Map<String, String> properties;
        private final Map<String, KeyStoreEntry> entries;

        DomainEntry(String string, Map<String, String> map) {
            this.name = string;
            this.properties = map;
            this.entries = new HashMap<String, KeyStoreEntry>();
        }

        String getName() {
            return this.name;
        }

        Map<String, String> getProperties() {
            return this.properties;
        }

        Collection<KeyStoreEntry> getEntries() {
            return this.entries.values();
        }

        void add(KeyStoreEntry keyStoreEntry) throws ParsingException {
            String string = keyStoreEntry.getName();
            if (this.entries.containsKey(string)) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("duplicate.keystore.name"));
                Object[] objectArray = new Object[]{string};
                throw new ParsingException(messageFormat.format(objectArray));
            }
            this.entries.put(string, keyStoreEntry);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("\ndomain ").append(this.name);
            if (this.properties != null) {
                for (Map.Entry<String, String> object : this.properties.entrySet()) {
                    stringBuilder.append("\n        ").append(object.getKey()).append('=').append(object.getValue());
                }
            }
            stringBuilder.append(" {\n");
            if (this.entries != null) {
                for (KeyStoreEntry keyStoreEntry : this.entries.values()) {
                    stringBuilder.append(keyStoreEntry).append("\n");
                }
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static class PermissionEntry {
        public String permission;
        public String name;
        public String action;
        public String signedBy;

        public PermissionEntry() {
        }

        public PermissionEntry(String string, String string2, String string3) {
            this.permission = string;
            this.name = string2;
            this.action = string3;
        }

        public int hashCode() {
            int n = this.permission.hashCode();
            if (this.name != null) {
                n ^= this.name.hashCode();
            }
            if (this.action != null) {
                n ^= this.action.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry permissionEntry = (PermissionEntry)object;
            if (this.permission == null ? permissionEntry.permission != null : !this.permission.equals(permissionEntry.permission)) {
                return false;
            }
            if (this.name == null ? permissionEntry.name != null : !this.name.equals(permissionEntry.name)) {
                return false;
            }
            if (this.action == null ? permissionEntry.action != null : !this.action.equals(permissionEntry.action)) {
                return false;
            }
            return !(this.signedBy == null ? permissionEntry.signedBy != null : !this.signedBy.equals(permissionEntry.signedBy));
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("permission ");
            printWriter.print(this.permission);
            if (this.name != null) {
                printWriter.print(" \"");
                printWriter.print(this.name.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\\\""));
                printWriter.print('\"');
            }
            if (this.action != null) {
                printWriter.print(", \"");
                printWriter.print(this.action);
                printWriter.print('\"');
            }
            if (this.signedBy != null) {
                printWriter.print(", signedBy \"");
                printWriter.print(this.signedBy);
                printWriter.print('\"');
            }
            printWriter.println(";");
        }
    }

    public static class PrincipalEntry
    implements Principal {
        public static final String WILDCARD_CLASS = "WILDCARD_PRINCIPAL_CLASS";
        public static final String WILDCARD_NAME = "WILDCARD_PRINCIPAL_NAME";
        public static final String REPLACE_NAME = "PolicyParser.REPLACE_NAME";
        String principalClass;
        String principalName;

        public PrincipalEntry(String string, String string2) {
            if (string == null || string2 == null) {
                throw new NullPointerException(ResourcesMgr.getString("null.principalClass.or.principalName"));
            }
            this.principalClass = string;
            this.principalName = string2;
        }

        boolean isWildcardName() {
            return this.principalName.equals(WILDCARD_NAME);
        }

        boolean isWildcardClass() {
            return this.principalClass.equals(WILDCARD_CLASS);
        }

        boolean isReplaceName() {
            return this.principalClass.equals(REPLACE_NAME);
        }

        public String getPrincipalClass() {
            return this.principalClass;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public String getDisplayClass() {
            if (this.isWildcardClass()) {
                return "*";
            }
            if (this.isReplaceName()) {
                return "";
            }
            return this.principalClass;
        }

        public String getDisplayName() {
            return this.getDisplayName(false);
        }

        public String getDisplayName(boolean bl) {
            if (this.isWildcardName()) {
                return "*";
            }
            if (bl) {
                return "\"" + this.principalName + "\"";
            }
            return this.principalName;
        }

        @Override
        public String getName() {
            return this.principalName;
        }

        @Override
        public String toString() {
            if (!this.isReplaceName()) {
                return this.getDisplayClass() + "/" + this.getDisplayName();
            }
            return this.getDisplayName();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PrincipalEntry)) {
                return false;
            }
            PrincipalEntry principalEntry = (PrincipalEntry)object;
            return this.principalClass.equals(principalEntry.principalClass) && this.principalName.equals(principalEntry.principalName);
        }

        @Override
        public int hashCode() {
            return this.principalClass.hashCode();
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("principal " + this.getDisplayClass() + " " + this.getDisplayName(true));
        }
    }

    public static class GrantEntry {
        public String signedBy;
        public String codeBase;
        public LinkedList<PrincipalEntry> principals;
        public Vector<PermissionEntry> permissionEntries;

        public GrantEntry() {
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }

        public GrantEntry(String string, String string2) {
            this.codeBase = string2;
            this.signedBy = string;
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }

        public void add(PermissionEntry permissionEntry) {
            this.permissionEntries.addElement(permissionEntry);
        }

        public boolean remove(PrincipalEntry principalEntry) {
            return this.principals.remove(principalEntry);
        }

        public boolean remove(PermissionEntry permissionEntry) {
            return this.permissionEntries.removeElement(permissionEntry);
        }

        public boolean contains(PrincipalEntry principalEntry) {
            return this.principals.contains(principalEntry);
        }

        public boolean contains(PermissionEntry permissionEntry) {
            return this.permissionEntries.contains(permissionEntry);
        }

        public Enumeration<PermissionEntry> permissionElements() {
            return this.permissionEntries.elements();
        }

        public void write(PrintWriter printWriter) {
            Object object;
            Object object2;
            printWriter.print("grant");
            if (this.signedBy != null) {
                printWriter.print(" signedBy \"");
                printWriter.print(this.signedBy);
                printWriter.print('\"');
                if (this.codeBase != null) {
                    printWriter.print(", ");
                }
            }
            if (this.codeBase != null) {
                printWriter.print(" codeBase \"");
                printWriter.print(this.codeBase);
                printWriter.print('\"');
                if (this.principals != null && this.principals.size() > 0) {
                    printWriter.print(",\n");
                }
            }
            if (this.principals != null && this.principals.size() > 0) {
                object2 = this.principals.iterator();
                while (object2.hasNext()) {
                    printWriter.print("      ");
                    object = (PrincipalEntry)object2.next();
                    ((PrincipalEntry)object).write(printWriter);
                    if (!object2.hasNext()) continue;
                    printWriter.print(",\n");
                }
            }
            printWriter.println(" {");
            object2 = this.permissionEntries.elements();
            while (object2.hasMoreElements()) {
                object = (PermissionEntry)object2.nextElement();
                printWriter.write("  ");
                ((PermissionEntry)object).write(printWriter);
            }
            printWriter.println("};");
        }

        public Object clone() {
            GrantEntry grantEntry = new GrantEntry();
            grantEntry.codeBase = this.codeBase;
            grantEntry.signedBy = this.signedBy;
            grantEntry.principals = new LinkedList<PrincipalEntry>(this.principals);
            grantEntry.permissionEntries = new Vector<PermissionEntry>(this.permissionEntries);
            return grantEntry;
        }
    }
}

