/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.dao.Wbs1AccountDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Answer;
import jp.co.extreme.module.wbs1.model.WbsJudgementCondition;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1AnswerDAO
extends OrmAbstractDAO<Wbs1Answer> {
    private Wbs1AnswerDAO() {
        super(new Wbs1Answer[0]);
        this.setTableName("wbs1_answer");
    }

    public static Wbs1AnswerDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, WbsTempCondition tmpCondition, WbsJudgementCondition judgementCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (tmpCondition.personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + tmpCondition.personId);
            selectQuery.addWhereElement(whereElement);
        }
        if (tmpCondition.questionSetId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "question_set_id =" + tmpCondition.questionSetId);
            selectQuery.addWhereElement(whereElement);
        }
        Wbs1AnswerDAO.setJudgementCondition(selectQuery, aliasWk, judgementCondition);
        if (tmpCondition.sex != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("ac.sex_code" + sqlContext.toCondition_string("=", tmpCondition.sex.code));
            selectQuery.addWhereElement(whereElement);
        }
        StringBuilder fromClause = new StringBuilder();
        fromClause.append(String.valueOf(this.getTableName()) + " AS " + alias);
        if (tmpCondition.sex != null) {
            fromClause.append(" LEFT JOIN " + Wbs1AccountDAO.getInstance().getTableName() + " AS ac ON ac.person_id = " + aliasWk + "person_id");
        }
        selectQuery.setFromClause(fromClause.toString());
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, WbsTempCondition tmpCondition, WbsJudgementCondition judgementCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, tmpCondition, judgementCondition);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getByPersonId(DtsSession dtsSession, WbsTempCondition tmpCondition, WbsJudgementCondition judgementCondition) throws Exception {
        if (tmpCondition.personId <= 0L) {
            return null;
        }
        List<T> entityList = this.getList(dtsSession, Mode.personId, tmpCondition, judgementCondition);
        return BcCollectionUtil.getFirst(entityList);
    }

    public static void setJudgementCondition(SqlSelectQuery selectQuery, String aliasWk, WbsJudgementCondition judgementCondition) throws Exception {
        if (judgementCondition == null) {
            return;
        }
        List<String> judgementStatusIdList = BcCsvUtil.parseCsvRow(judgementCondition.judgementStatusId, true);
        StringBuilder sb = new StringBuilder();
        for (String judgementStatusId : judgementStatusIdList) {
            if (!BcStringUtil.isEmpty(sb)) {
                sb.append(" OR ");
            }
            sb.append(String.valueOf(aliasWk) + "judgement_status_id = " + judgementStatusId);
        }
        if (!BcStringUtil.isEmpty(sb)) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("(" + sb + ")");
            selectQuery.addWhereElement(whereElement);
        }
    }

    /* synthetic */ Wbs1AnswerDAO(Wbs1AnswerDAO wbs1AnswerDAO) {
        this();
    }

    public static enum Mode {
        personId("person_id"),
        question_set_id("question_set_id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final Wbs1AnswerDAO instance = new Wbs1AnswerDAO(null);

        private SingletonHolder() {
        }
    }
}

