/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.swing.SwgFocusTraversalPolicy;
import jp.co.extreme.swing.SwgInputContextHelper;
import jp.co.extreme.swing.SwgMenuItem;
import jp.co.extreme.swing.SwgTextArea;
import jp.co.extreme.swing.lookAndFeel.SwgLafManager;

public class SwgTextField
extends JTextField
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4686324413296409735L;
    protected SwgInputContextHelper inputContextHelper;
    protected Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    protected boolean isLostFocus;
    protected boolean neverEditable;
    protected boolean isSelectAllAtFocusGaind = true;
    protected boolean popupFlag;
    protected boolean antialias;
    protected JPopupMenu popupMenu = new JPopupMenu();
    protected SwgMenuItem cutMenu;
    protected SwgMenuItem copyMenu;
    protected SwgMenuItem pastMenu;
    protected SwgMenuItem deleteMenu;
    protected SwgMenuItem selectAllMenu;
    protected SwgMenuItem unicodeMenu;
    protected ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            SwgTextField.this.actionPerformed1(ev);
        }
    };
    protected KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent ev) {
            SwgTextField.this.keyEvent(ev);
        }

        @Override
        public void keyReleased(KeyEvent ev) {
            SwgTextField.this.keyEvent(ev);
        }

        @Override
        public void keyTyped(KeyEvent ev) {
            SwgTextField.this.keyEvent(ev);
        }
    };
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent ev) {
            SwgTextField.this.mouseEvent(ev);
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            SwgTextField.this.mouseEvent(ev);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            SwgTextField.this.mouseEvent(ev);
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            SwgTextField.this.mouseEvent(ev);
        }
    };
    protected FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent ev) {
            SwgTextField.this.focusEvent(ev);
        }

        @Override
        public void focusLost(FocusEvent ev) {
            SwgTextField.this.focusEvent(ev);
        }
    };
    protected InputMethodListener inputMethodListener = new InputMethodListener(){

        @Override
        public void inputMethodTextChanged(InputMethodEvent ev) {
            if (SwgTextField.this.isLostFocus) {
                ev.consume();
                SwgTextField.this.isLostFocus = false;
            }
        }

        @Override
        public void caretPositionChanged(InputMethodEvent event) {
        }
    };

    static {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        FocusTraversalPolicy focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
        if (!SwgFocusTraversalPolicy.class.isAssignableFrom(focusTraversalPolicy.getClass())) {
            SwgFocusTraversalPolicy lbFocusTraversalPolicy = new SwgFocusTraversalPolicy();
            keyboardFocusManager.setDefaultFocusTraversalPolicy(lbFocusTraversalPolicy);
        }
    }

    public SwgTextField() throws Exception {
        this.init();
    }

    public SwgTextField(String text) throws Exception {
        this.init();
        this.setText(text);
    }

    protected void init() throws Exception {
        this.inputContextHelper = new SwgInputContextHelper(this);
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
        this.addFocusListener(this.focusListener);
        this.addInputMethodListener(this.inputMethodListener);
        this.cutMenu = new SwgMenuItem(BcWords.getInstance().cut, new ImageIcon(AwtImageHelper.getImageAsIcon("cut_64x64.png")));
        this.cutMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.cutMenu);
        this.copyMenu = new SwgMenuItem(BcWords.getInstance().copy, new ImageIcon(AwtImageHelper.getImageAsIcon("copy_64x64.png")));
        this.copyMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.copyMenu);
        this.pastMenu = new SwgMenuItem(BcWords.getInstance().past, new ImageIcon(AwtImageHelper.getImageAsIcon("paste_64x64.png")));
        this.pastMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.pastMenu);
        this.deleteMenu = new SwgMenuItem(BcWords.getInstance().delete, new ImageIcon(AwtImageHelper.getImageAsIcon("cancel_64x64.png")));
        this.deleteMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.deleteMenu);
        this.popupMenu.addSeparator();
        this.selectAllMenu = new SwgMenuItem(BcWords.getInstance().selectAll.toPlain());
        this.selectAllMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.selectAllMenu);
        this.popupMenu.addSeparator();
        this.unicodeMenu = new SwgMenuItem("Unicode\u8868\u793a");
        this.unicodeMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.unicodeMenu);
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.neverEditable && editable) {
            return;
        }
        super.setEditable(editable);
        if (editable) {
            this.setBackground(SwgLafManager.getInstance().textField_EditablBg);
        } else {
            this.setBackground(SwgLafManager.getInstance().textField_NotEditablBg);
        }
    }

    @Override
    public void setText(String text) {
        if (BcStringUtil.isEmpty(text)) {
            super.setText("");
        } else {
            super.setText(text);
        }
    }

    protected void actionPerformed1(ActionEvent ev) {
        try {
            this.actionPerformed2(ev);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
        }
    }

    protected void actionPerformed2(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.cutMenu) {
            if (this.isEditable()) {
                this.cut();
            }
        } else if (ev.getSource() == this.copyMenu) {
            this.copy();
        } else if (ev.getSource() == this.pastMenu) {
            if (this.isEditable()) {
                this.paste();
            }
        } else if (ev.getSource() == this.deleteMenu) {
            if (this.isEditable()) {
                this.replaceSelection(null);
            }
        } else if (ev.getSource() == this.selectAllMenu) {
            this.selectAll();
        } else if (ev.getSource() == this.unicodeMenu) {
            SwgTextArea textArea = new SwgTextArea();
            textArea.setEditable(false);
            StringBuilder sb = BcStringUtil.toCharCode(this.getText());
            textArea.setText(sb.toString());
            JOptionPane.showMessageDialog(this, textArea, "Unicode", 1);
        }
    }

    protected void keyEvent(KeyEvent ev) {
        switch (ev.getID()) {
            case 401: {
                switch (ev.getKeyCode()) {
                    case 10: {
                        this.transferFocus();
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 65489: {
                        if (!this.isEditable()) break;
                        this.cut();
                        break;
                    }
                    case 65485: {
                        this.copy();
                        break;
                    }
                    case 65487: {
                        if (!this.isEditable()) break;
                        this.paste();
                        break;
                    }
                    case 127: {
                        if (!this.isEditable()) break;
                        this.replaceSelection(null);
                    }
                }
                break;
            }
            case 402: {
                break;
            }
        }
    }

    protected void focusEvent(FocusEvent ev) {
        switch (ev.getID()) {
            case 1004: {
                if (this.isEnabled() && this.isEditable()) {
                    if (this.isSelectAllAtFocusGaind && !this.popupFlag) {
                        this.selectAll();
                    }
                    this.popupFlag = false;
                }
                this.inputContextHelper.focusEvent(ev);
                break;
            }
            case 1005: {
                this.isLostFocus = true;
                this.inputContextHelper.focusEvent(ev);
            }
        }
    }

    protected void mouseEvent(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.setPopupMenuAttribute();
            this.popupFlag = true;
            this.popupMenu.show(this, ev.getX(), ev.getY());
            return;
        }
        switch (ev.getID()) {
            case 504: {
                break;
            }
            case 505: {
                break;
            }
            case 503: {
                break;
            }
            case 501: {
                break;
            }
            case 506: {
                break;
            }
            case 502: {
                break;
            }
        }
    }

    protected void setPopupMenuAttribute() {
        Transferable transferable = this.getClipboard().getContents(this);
        String clipText = null;
        if (transferable != null) {
            try {
                clipText = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cutMenu.setEnabled(this.isEnabled() && this.isEditable() && this.getSelectionEnd() - this.getSelectionStart() > 0);
        this.copyMenu.setEnabled(this.getSelectionEnd() - this.getSelectionStart() > 0);
        this.selectAllMenu.setEnabled(this.getText().length() > 0);
        this.pastMenu.setEnabled(this.isEnabled() && this.isEditable() && clipText != null);
        this.deleteMenu.setEnabled(this.isEnabled() && this.isEditable() && this.getSelectionEnd() - this.getSelectionStart() > 0);
    }

    public boolean getNeverEditable() {
        return this.neverEditable;
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return this.clipboard;
    }

    public void setNeverEditable(boolean neverEditable) {
        this.neverEditable = neverEditable;
        if (!neverEditable) {
            this.setEditable(false);
        }
    }

    public void setImeMode(int imeMode) {
        this.inputContextHelper.setImeMode(imeMode);
    }

    public void setSelectAllAtFocusGaindValid(boolean isSelectAllAtFocusGaind) {
        this.isSelectAllAtFocusGaind = isSelectAllAtFocusGaind;
    }

    public String getTextNull() {
        String str = this.getText();
        if (!BcStringUtil.isEmpty(str)) {
            return str;
        }
        return null;
    }

    public boolean getAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean flag) {
        this.antialias = flag;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.antialias) {
            HashMap<RenderingHints.Key, Object> newHint = new HashMap<RenderingHints.Key, Object>();
            newHint.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            newHint.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            RenderingHints oldHint = g2.getRenderingHints();
            g2.setRenderingHints(newHint);
            super.paint(g2);
            g2.setRenderingHints(oldHint);
        } else {
            super.paint(g2);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SwgTextField obj = (SwgTextField)super.clone();
        return obj;
    }
}

