/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.swing.SwgCheckBox;
import jp.co.extreme.swing.SwgComponentUnit;
import jp.co.extreme.swing.SwgFormLayout;
import jp.co.extreme.swing.SwgPanel;

public class HswgItemSelectionPanel
extends SwgPanel {
    private static final long serialVersionUID = -4303287203864867198L;
    protected BcTableModel tableModel;
    protected int dispColumnId;
    protected List<AbstractButton> buttonList;
    protected int layoutType;

    public HswgItemSelectionPanel(int layoutType) throws Exception {
        this.layoutType = layoutType;
        this.setOpaque(true);
        this.tableModel = null;
        this.dispColumnId = -1;
        this.buttonList = new ArrayList<AbstractButton>();
    }

    public void setTableModel(BcTableModel tableModel, int dispColumnId) throws Exception {
        this.tableModel = tableModel;
        this.dispColumnId = dispColumnId;
        this.buttonList = new ArrayList<AbstractButton>();
        this.creatCheckBox();
    }

    public void setTableModel(BcTableModel tableModel, String tableColumnName) throws Exception {
        this.setTableModel(tableModel, tableModel.getTableColumnModel().getIndexByTableColumnName(tableColumnName));
    }

    protected void creatCheckBox() throws Exception {
        super.removeAll();
        SwgFormLayout formLayout = new SwgFormLayout(this.layoutType);
        this.setLayout(formLayout);
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            SwgCheckBox checkBox = new SwgCheckBox();
            Object value = this.tableModel.getValueAt(i, this.dispColumnId);
            checkBox.setText(String.valueOf(value));
            this.buttonList.add(checkBox);
            SwgComponentUnit componentUnit = new SwgComponentUnit((Component)checkBox, new Component[0]);
            formLayout.componentUnitList.add(componentUnit);
            ++i;
        }
    }

    public String getSelectedString(int columnId) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        int i = 0;
        while (i < this.buttonList.size()) {
            Object value;
            AbstractButton button = this.buttonList.get(i);
            if (button.isSelected() && (value = this.tableModel.getValueAt(i, columnId)) != null) {
                valueList.add(value);
            }
            ++i;
        }
        return EtcEnumStrUtil.valueCollectionToEnum(valueList);
    }

    public String getSelectedString(String columnName) throws Exception {
        if (this.tableModel == null) {
            return null;
        }
        int columnId = this.tableModel.getTableColumnModel().getIndexByTableColumnName(columnName);
        return this.getSelectedString(columnId);
    }

    public String getSelectedString2(String columnName) throws Exception {
        String value = this.getSelectedString(columnName);
        return value;
    }

    public int setSelected(int columnId, String enumStr) throws Exception {
        List<String> valueStrList = EtcEnumStrUtil.toValueList(enumStr);
        int i = 0;
        while (i < this.buttonList.size()) {
            Object value = this.tableModel.getValueAt(i, columnId);
            String valueStr = BcStringUtil.toString(value);
            AbstractButton button = this.buttonList.get(i);
            boolean isSelected = valueStrList.indexOf(valueStr) >= 0;
            button.setSelected(isSelected);
            ++i;
        }
        return valueStrList.size();
    }

    public int setSelected(String columnName, String enumStr) throws Exception {
        int columnId = this.tableModel.getTableColumnModel().getIndexByTableColumnName(columnName);
        return this.setSelected(columnId, enumStr);
    }
}

