/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf.server;

import java.io.File;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbConstants;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.scf.common.ScfAbstractModuleContainer;
import jp.co.extreme.scf.common.ScfConstants;
import jp.co.extreme.scf.common.ScfHandleManager;
import jp.co.extreme.scf.common.ScfHandleManagerImpl;
import jp.co.extreme.scf.common.ScfModule;
import jp.co.extreme.scf.rmi.server.RmiServerModule;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ScfServerContainer
extends ScfAbstractModuleContainer {
    private ScfConstants.RunMode runMode;
    private Document configDom;
    private ScfHandleManagerImpl handleManager;
    public RmiServerModule rmiServerModule;

    public ScfConstants.RunMode getRunMode() {
        return this.runMode;
    }

    public void setRunMode(ScfConstants.RunMode runMode) {
        this.runMode = runMode;
    }

    private ScfServerContainer() {
        Signal signal_TERM = new Signal("TERM");
        Signal.handle(signal_TERM, new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                BcLogUtil.info("signal=" + signal.getName());
                System.exit(0);
            }
        });
        Signal signal_INT = new Signal("INT");
        Signal.handle(signal_INT, new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                BcLogUtil.info("signal=" + signal.getName());
                System.exit(0);
            }
        });
        boolean isCluster = false;
        this.handleManager = new ScfHandleManagerImpl(isCluster);
    }

    public static ScfServerContainer getInstance() {
        return SingletonHolder.instance;
    }

    public Document getConfig() {
        return this.configDom;
    }

    public void setConfig(Document configDom) throws Exception {
        this.configDom = configDom;
        Node handleManagerNode = BcXmlUtil.getNode(configDom, "handleManager");
        if (handleManagerNode != null) {
            this.setConfig_L2(handleManagerNode);
        } else {
            this.setHandleManagerLogger(BcLogConstants.LogLevel.INFO);
        }
    }

    protected void setConfig_L2(Node baseNode) throws Exception {
        String tmpStr = BcXmlUtil.getTextValue(baseNode, "validationInterval");
        if (!BcStringUtil.isEmpty(tmpStr)) {
            long tmpValue = BcNumberUtil.parseLong(tmpStr, -1L);
            this.handleManager.setValidationInterval(tmpValue);
        }
        tmpStr = BcXmlUtil.getTextValue(baseNode, AfbConstants.LogAttribute.logLevel.name());
        BcLogConstants.LogLevel logLevel = BcLogUtil.parseLogLevel(tmpStr, BcLogUtil.logLevelDefault);
        this.setHandleManagerLogger(logLevel);
    }

    protected void setHandleManagerLogger(BcLogConstants.LogLevel logLevel) throws Exception {
        if (logLevel != null) {
            String loggerName = "handle_manager";
            File logFile = new File(AfbApplication.getInstance().getLogDir(), String.valueOf(loggerName) + ".log");
            BcLogger logger = BcLogUtil.createLogger(loggerName, false, false);
            BcLogUtil.addFileFileHandler(logger, logFile);
            logger.setLogLevel(logLevel);
            this.handleManager.setLogger(logger);
        }
    }

    public ScfHandleManager getHandleManager() {
        return this.handleManager;
    }

    @Override
    public void addModule(ScfModule module) throws Exception {
        super.addModule(module);
        if (module.getClass() == RmiServerModule.class) {
            this.rmiServerModule = (RmiServerModule)module;
        }
    }

    public void start() throws Exception {
        this.handleManager.start();
        this.startModule();
    }

    /* synthetic */ ScfServerContainer(ScfServerContainer scfServerContainer) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfServerContainer instance = new ScfServerContainer(null);

        private SingletonHolder() {
        }
    }
}

