/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.fx.XfilFxHelper;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.stub.XfilUriEntityStub;

public class XfilUriEntityPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField directoryField = new FxTextField();
    FxTextField fileNameField = new FxTextField();
    FxTextField tagField = new FxTextField();
    FxButton completionButton = FxUtil.createCompletionButton();
    FxButton cancelButton = FxUtil.createCancelButton();
    XfilUriEntity uriEntity1;
    Stage stage;

    public XfilUriEntityPane() throws Exception {
        this.directoryField.setPrefColumnCount(80);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().directory), new Node[]{this.directoryField});
        this.centerPane.addNodeUnit(controlUnit);
        this.fileNameField.setPrefColumnCount(80);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().tag), new Node[]{this.fileNameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.tagField.setPrefColumnCount(80);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().tag), new Node[]{this.tagField});
        this.centerPane.addNodeUnit(controlUnit);
        this.setCenter((Node)this.centerPane);
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setData(XfilUriEntity uriEntity) throws Exception {
        this.uriEntity1 = uriEntity;
        this.directoryField.setText(uriEntity.directory);
        this.fileNameField.setText(uriEntity.name);
        this.tagField.setText(uriEntity.text01);
    }

    protected void storeData(XfilUriEntity uriEntity) throws Exception {
        uriEntity.directory = this.directoryField.getText();
        uriEntity.name = this.fileNameField.getText();
        uriEntity.text01 = this.tagField.getText();
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData(this.uriEntity1);
            XfilUriEntityStub.getInstance().putUriEntity(this.uriEntity1);
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
        XfilFxHelper.getInstance().remove(((Object)((Object)this)).getClass(), this.uriEntity1.id);
    }

    public void show(long uriEntityId) throws Exception {
        XfilUriEntity uriEntity = XfilUriEntityStub.getInstance().getUriEntity(uriEntityId);
        this.setData(uriEntity);
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(320.0);
        this.stage.setResizable(false);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }
}

