/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.http.client;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import jp.co.extreme.activation.BcMimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.http.HttpConstants;
import jp.co.extreme.http.HttpUtil;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;

public class HtclHttpClientUtil
extends BcLoggableObject {
    public static boolean contentExsist(String url, long connectionTimeout, long socketTimeout) throws Exception {
        boolean b = false;
        try {
            b = HtclHttpClientUtil.contentExsist_L2(url, connectionTimeout, socketTimeout);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return b;
    }

    private static boolean contentExsist_L2(String url, long connectionTimeout, long socketTimeout) throws Exception {
        String contentType;
        String userAgent = "Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko";
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout, TimeUnit.MILLISECONDS).setDefaultKeepAlive(socketTimeout, TimeUnit.MILLISECONDS).build();
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader(HttpConstants.RequestHeader.Accept_Charset.value, (Object)"utf-8"));
        headers.add(new BasicHeader(HttpConstants.RequestHeader.Accept_Language.value, (Object)"ja, en;q=0.8"));
        headers.add(new BasicHeader(HttpConstants.RequestHeader.User_Agent.value, (Object)userAgent));
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultHeaders(headers).build();
        HttpGet httpGet = new HttpGet(url);
        HttpResponse httpResponse = httpClient.execute((ClassicHttpRequest)httpGet);
        return httpResponse.getCode() == 200 && BcMimeUtil.isImageMime(contentType = HttpUtil.getHeaderValue(httpResponse, "Content-Type"));
    }

    public static int getContentLength(URL url) throws Exception {
        int contentLength = -1;
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("HEAD");
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() == 200) {
            contentLength = httpURLConnection.getContentLength();
        }
        httpURLConnection.disconnect();
        return contentLength;
    }
}

