/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.http.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.http.client.HtclContentLoaderHelper;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;

public class HtclContentLoader
extends BcLoggableObject {
    protected BcStreamTransmitter streamTransmitter;
    protected HtclContentLoaderHelper loaderHelper = new HtclContentLoaderHelper();

    public HtclContentLoader() {
        this.setStreamTransmitter(new BcStreamTransmitter());
    }

    public BcStreamTransmitter getStreamTransmitter() {
        return this.streamTransmitter;
    }

    public void setStreamTransmitter(BcStreamTransmitter streamTransmitter) {
        this.streamTransmitter = streamTransmitter;
    }

    public HtclContentLoaderHelper getLoaderHelper() {
        return this.loaderHelper;
    }

    public void getContent(URL url, OutputStream os, long rangeStart, long rangeEnd, CredentialsProvider credsProvider) throws Exception {
        block9: {
            if (BcNetUtil.isHttp(url) || BcNetUtil.isHttps(url)) {
                this.loaderHelper.setStreamTransmitter(this.streamTransmitter);
                this.loaderHelper.loadContent(url, os, rangeStart, rangeEnd, credsProvider);
            } else {
                if (BcNetUtil.isFile(url)) {
                    URI uri = url.toURI();
                    File file = new File(uri.getPath());
                    BcLogUtil.debug("getContent:file=" + file.getPath());
                    if (!file.exists()) {
                        return;
                    }
                    try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                        this.streamTransmitter.transmit(is, os);
                        break block9;
                    }
                }
                throw new Exception("Not suppoted protocol '" + url.getProtocol() + "'.");
            }
        }
    }

    public void getContent(URL url, OutputStream os, long rangeStart, long rangeEnd) throws Exception {
        this.getContent(url, os, rangeStart, rangeEnd, null);
    }

    public ByteArrayOutputStream getContent(URL url, CredentialsProvider credsProvider) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getContent(url, baos, -1L, -1L, credsProvider);
        return baos;
    }

    public ByteArrayOutputStream getContent(URL url, String userName, String password) throws Exception {
        AuthScope authScope = new AuthScope(url.getHost(), url.getPort());
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(userName, password.toCharArray());
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
        return this.getContent(url, (CredentialsProvider)basicCredentialsProvider);
    }

    public ByteArrayOutputStream getContent(URL url) throws Exception {
        return this.getContent(url, null);
    }
}

