/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.media.MediaView;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.awt.AwtUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxComboBox;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.fx.skin.FxSkinDefault;
import jp.co.extreme.fx.skin.FxSkinUtil;
import jp.co.extreme.fx.util.FxArrangementHint;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.swing.SwgUtil;

public class FxUtil {
    protected static Font defaultFont;
    public static final int FIELD_MARGIN_H = 16;
    public static final int FIELD_MARGIN_V = 8;
    public static final double comboBoxHeightPadding = 2.0;
    public static double insetDefault;

    static {
        insetDefault = 8.0;
    }

    private FxUtil() {
    }

    public static Rectangle2D toRectangle2D(Rectangle2D.Double awtRectangle) {
        Rectangle2D rectangle2D = new Rectangle2D(awtRectangle.x, awtRectangle.y, awtRectangle.width, awtRectangle.height);
        return rectangle2D;
    }

    public static Rectangle2D toRectangle2D(Rectangle awtRectangle) {
        Rectangle2D rectangle2D = new Rectangle2D((double)awtRectangle.x, (double)awtRectangle.y, (double)awtRectangle.width, (double)awtRectangle.height);
        return rectangle2D;
    }

    public static Dimension2D toDimension2D(Bounds bounds) {
        Dimension2D dimension2D = new Dimension2D(bounds.getWidth(), bounds.getHeight());
        return dimension2D;
    }

    public static Dimension2D toDimension2D(Rectangle2D rectangle2D) {
        Dimension2D dimension2D = new Dimension2D(rectangle2D.getWidth(), rectangle2D.getHeight());
        return dimension2D;
    }

    public static Rectangle toAwtRectangle2D(Rectangle2D rectangle2D) {
        Rectangle awtRectangle = new Rectangle();
        awtRectangle.x = (int)rectangle2D.getMinX();
        awtRectangle.y = (int)rectangle2D.getMinY();
        awtRectangle.width = (int)rectangle2D.getWidth();
        awtRectangle.height = (int)rectangle2D.getHeight();
        return awtRectangle;
    }

    public static Dimension toAwtDimension(Rectangle2D rectangle2D) {
        Dimension dimension = new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return dimension;
    }

    public static Rectangle2D toRectangle2D(Dimension dimension) {
        Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, (double)dimension.width, (double)dimension.height);
        return rectangle2D;
    }

    public static void setFixedWidth(Region region, double width) {
        region.setMinWidth(width);
        region.setMaxWidth(width);
        region.setPrefWidth(width);
        region.resize(width, region.getHeight());
    }

    public static void setFixedHight(Region region, double height) {
        region.setMinHeight(height);
        region.setMaxHeight(height);
        region.setPrefHeight(height);
        region.resize(region.getWidth(), height);
    }

    public static void setFixedSize(Region region, double width, double height) {
        FxUtil.setFixedWidth(region, width);
        FxUtil.setFixedHight(region, height);
    }

    public static void setFixedSize(Region region, Dimension2D dim2d) {
        FxUtil.setFixedSize(region, dim2d.getWidth(), dim2d.getHeight());
    }

    public static void setFixedWidth(Stage stage, double width) {
        stage.setMinWidth(width);
        stage.setMaxWidth(width);
    }

    public static void setFixedHight(Stage stage, double height) {
        stage.setMinHeight(height);
        stage.setMaxHeight(height);
    }

    public static void setFixedSize(Stage stage, double width, double height) {
        FxUtil.setFixedWidth(stage, width);
        FxUtil.setFixedHight(stage, height);
    }

    public static void setMinSizeBinding(Region parentRegion, Region childRegion) throws Exception {
        childRegion.minWidthProperty().bind((ObservableValue)parentRegion.widthProperty());
        childRegion.minHeightProperty().bind((ObservableValue)parentRegion.heightProperty());
    }

    public static void setMaxSizeBinding(Region parentRegion, Region childRegion) throws Exception {
        childRegion.maxWidthProperty().bind((ObservableValue)parentRegion.widthProperty());
        childRegion.maxHeightProperty().bind((ObservableValue)parentRegion.heightProperty());
    }

    public static void setPrefSize(Region region, Dimension2D dim2d) {
        region.setPrefSize(dim2d.getWidth(), dim2d.getHeight());
    }

    public static void setPrefSize(Control control, Dimension2D dim2d) {
        control.setPrefSize(dim2d.getWidth(), dim2d.getHeight());
    }

    public static void setPrefSize(Region region1, Region region2) {
        region2.setPrefSize(region1.getPrefWidth(), region1.getPrefHeight());
    }

    public static Dimension2D getTextFieldSize(Font font, int textLength, boolean isFullWidth) {
        Dimension2D dim1 = FxFontUtil.getTextSize(font, textLength, isFullWidth);
        Dimension2D dim2 = new Dimension2D(dim1.getWidth() + 16.0, dim1.getHeight() + 8.0);
        return dim2;
    }

    public static Dimension2D getTextFieldSize(Font font, int textLength) {
        return FxUtil.getTextFieldSize(font, textLength, false);
    }

    public static Dimension2D getTextFieldSize(Font font, String text) {
        Dimension2D dim1 = FxFontUtil.getTextSize(font, text);
        Dimension2D dim2 = new Dimension2D(dim1.getWidth() + 16.0, dim1.getHeight() + 8.0);
        return dim2;
    }

    public static Dimension2D getLabeledSize(Font font, String str) {
        Dimension2D textDim = FxFontUtil.getTextSize(font, str);
        Dimension2D dim = new Dimension2D(textDim.getWidth(), textDim.getHeight() + 8.0);
        return dim;
    }

    public static Dimension2D getLabeledSize(Labeled labeled) {
        return FxUtil.getLabeledSize(labeled.getFont(), labeled.getText());
    }

    public static void setPrefSize_TextField(TextField textField) throws Exception {
        double fontSize;
        Dimension2D dim = null;
        boolean isFullWidth = false;
        if (textField instanceof FxTextField) {
            FxTextField fxTextField = (FxTextField)textField;
            isFullWidth = fxTextField.isFullWidth();
        }
        if ((fontSize = FxCssUtil.getFontSizeFromStyle((Node)textField)) < 0.0) {
            fontSize = FxFontUtil.getDefaultFont().getSize();
        }
        Font font = Font.font((String)"Monospaced", (double)fontSize);
        dim = FxUtil.getTextFieldSize(font, textField.getPrefColumnCount(), isFullWidth);
        textField.setPrefSize(dim.getWidth(), dim.getHeight());
    }

    public static void setPrefSize_TextArea(TextArea textArea) throws Exception {
        Dimension2D dim = null;
        boolean isFullWidth = false;
        if (textArea instanceof FxTextArea) {
            FxTextArea fxTextArea = (FxTextArea)textArea;
            isFullWidth = fxTextArea.isFullWidth();
        }
        dim = FxUtil.getTextFieldSize(textArea.getFont(), textArea.getPrefColumnCount(), isFullWidth);
        textArea.setPrefSize(dim.getWidth(), dim.getHeight() * (double)textArea.getPrefRowCount());
    }

    public static void setPrefSize_Labeled(Labeled labeled) throws Exception {
        Dimension2D dim = FxUtil.getLabeledSize(labeled);
        labeled.setPrefSize(dim.getWidth(), dim.getHeight());
    }

    public static Font getFont(Labeled labeled) throws Exception {
        Font font = labeled.getFont();
        if (font != null) {
            return font;
        }
        double fontSize = FxCssUtil.getFontSizeFromStyle((Node)labeled);
        if (fontSize < 0.0) {
            fontSize = FxFontUtil.getDefaultFont().getSize();
        }
        font = Font.font((String)"Monospaced", (double)fontSize);
        return font;
    }

    public static Dimension2D computePrefSize(ButtonBase buttonBase) throws Exception {
        Font font = FxUtil.getFont((Labeled)buttonBase);
        double width = 0.0;
        double height = 0.0;
        if (!BcStringUtil.isEmpty(buttonBase.getText())) {
            Dimension2D dim = FxUtil.getLabeledSize(font, buttonBase.getText());
            width = dim.getWidth() + 18.0;
            height = dim.getHeight() + 2.0;
        }
        if (buttonBase.getGraphic() != null) {
            Node graphicNode = buttonBase.getGraphic();
            width += graphicNode.getBoundsInParent().getWidth();
            width += 4.0;
            height = Math.max(height, graphicNode.getBoundsInParent().getHeight() + 6.0);
        }
        Dimension2D dim2d = new Dimension2D(width, height);
        return dim2d;
    }

    public static void setPrefSize_ButtonBase(ButtonBase buttonBase) throws Exception {
        Dimension2D dim2d = FxUtil.computePrefSize(buttonBase);
        buttonBase.setPrefSize(dim2d.getWidth(), dim2d.getHeight());
    }

    public static Dimension2D computePrefSize(CheckBox checkBox) throws Exception {
        Font font = FxUtil.getFont((Labeled)checkBox);
        Dimension2D dim = FxUtil.getLabeledSize(font, "\u25a1");
        double width = dim.getWidth();
        double height = dim.getHeight();
        if (!BcStringUtil.isEmpty(checkBox.getText())) {
            dim = FxUtil.getLabeledSize(font, checkBox.getText());
            width += 12.0;
            width += dim.getWidth();
        }
        Dimension2D dim2d = new Dimension2D(width, height);
        return dim2d;
    }

    public static void setPrefSize_CheckBox(CheckBox checkBox) throws Exception {
        Dimension2D dim2d = FxUtil.computePrefSize(checkBox);
        checkBox.setPrefSize(dim2d.getWidth(), dim2d.getHeight());
    }

    public static Dimension2D computePrefSize(RadioButton radioButton) throws Exception {
        Font font = FxUtil.getFont((Labeled)radioButton);
        Dimension2D dim = FxUtil.getLabeledSize(font, "\u3007");
        double width = dim.getWidth();
        double height = dim.getHeight();
        width += 16.0;
        if (!BcStringUtil.isEmpty(radioButton.getText())) {
            dim = FxUtil.getLabeledSize(font, radioButton.getText());
            width += dim.getWidth();
        }
        Dimension2D dim2d2 = new Dimension2D(width, height);
        return dim2d2;
    }

    public static void setPrefSize_RadioButton(RadioButton radioButton) throws Exception {
        Dimension2D dim2d = FxUtil.computePrefSize(radioButton);
        radioButton.setPrefSize(dim2d.getWidth(), dim2d.getHeight());
    }

    public static <T> Dimension2D computePrefSize(ComboBox<T> comboBox) throws Exception {
        double fontSize = FxCssUtil.getFontSizeFromStyle(comboBox);
        if (fontSize < 0.0) {
            fontSize = FxFontUtil.getDefaultFont().getSize();
        }
        Font font = Font.font((String)"Monospaced", (double)fontSize);
        double widthMax = 0.0;
        double heightMax = 0.0;
        int columnCount = 0;
        if (comboBox instanceof FxComboBox) {
            FxComboBox fxComboBox = (FxComboBox)comboBox;
            columnCount = fxComboBox.columnCount.get();
        }
        if (columnCount > 0) {
            Dimension2D dim = FxUtil.getTextFieldSize(font, columnCount);
            widthMax = Math.max(widthMax, dim.getWidth());
            heightMax = Math.max(heightMax, dim.getHeight() + 2.0);
        } else {
            int i = 0;
            while (i < comboBox.getItems().size()) {
                Object value = comboBox.getItems().get(i);
                if (value instanceof String) {
                    Dimension2D dim = FxUtil.getTextFieldSize(font, value.toString());
                    widthMax = Math.max(widthMax, dim.getWidth());
                    heightMax = Math.max(heightMax, dim.getHeight() + 2.0);
                }
                ++i;
            }
        }
        Dimension2D dim2d = new Dimension2D(widthMax += FxUtil.getTextFieldSize(font, 2).getWidth(), heightMax);
        return dim2d;
    }

    public static <T> void setPrefSize_ComboBox(ComboBox<T> comboBox) throws Exception {
        Dimension2D dim2d = FxUtil.computePrefSize(comboBox);
        comboBox.setPrefSize(dim2d.getWidth(), dim2d.getHeight());
    }

    public static Dimension2D computePrefSize(ChoiceBox choiceBox) throws Exception {
        double fontSize = FxCssUtil.getFontSizeFromStyle((Node)choiceBox);
        if (fontSize < 0.0) {
            fontSize = FxFontUtil.getDefaultFont().getSize();
        }
        Font font = Font.font((String)"Monospaced", (double)fontSize);
        double widthMax = 0.0;
        double heightMax = 0.0;
        int i = 0;
        while (i < choiceBox.getItems().size()) {
            Object value = choiceBox.getItems().get(i);
            if (value instanceof String) {
                String strValue = (String)value;
                Dimension2D dim = FxUtil.getTextFieldSize(font, strValue);
                widthMax = Math.max(widthMax, dim.getWidth());
                heightMax = Math.max(heightMax, dim.getHeight() + 2.0);
            }
            ++i;
        }
        Dimension2D dim2d = new Dimension2D(widthMax, heightMax);
        return dim2d;
    }

    public static void setPrefSize_ComboBox(ChoiceBox choiceBox) throws Exception {
        Dimension2D dim2d = FxUtil.computePrefSize(choiceBox);
        choiceBox.setPrefSize(dim2d.getWidth(), dim2d.getHeight());
    }

    public static void setPrefSize(Collection<? extends Node> nodeCollection) throws Exception {
        for (Node node : nodeCollection) {
            FxUtil.setPrefSize(node);
        }
    }

    public static void setPrefSize(Node node) throws Exception {
        if (node instanceof TextField) {
            TextField textField = (TextField)node;
            FxUtil.setPrefSize_TextField(textField);
        } else if (node instanceof TextArea) {
            TextArea textArea = (TextArea)node;
            FxUtil.setPrefSize_TextArea(textArea);
        } else if (node instanceof ComboBox) {
            ComboBox comboBox = (ComboBox)node;
            FxUtil.setPrefSize_ComboBox(comboBox);
        } else if (node instanceof ChoiceBox) {
            ChoiceBox choiceBox = (ChoiceBox)node;
            FxUtil.setPrefSize_ComboBox(choiceBox);
        } else if (node instanceof Labeled) {
            if (node instanceof ButtonBase) {
                if (node instanceof CheckBox) {
                    CheckBox checkBox = (CheckBox)node;
                    FxUtil.setPrefSize_CheckBox(checkBox);
                } else if (node instanceof RadioButton) {
                    RadioButton radioButton = (RadioButton)node;
                    FxUtil.setPrefSize_RadioButton(radioButton);
                } else {
                    ButtonBase buttonBase = (ButtonBase)node;
                    FxUtil.setPrefSize_ButtonBase(buttonBase);
                }
            } else {
                Labeled labeled = (Labeled)node;
                FxUtil.setPrefSize_Labeled(labeled);
            }
        } else if (node instanceof FxFlowPane) {
            FxFlowPane flowPane = (FxFlowPane)node;
            FxUtil.setPrefSize_NodeUnit(flowPane.nodeUnitList);
        } else if (node instanceof Pane) {
            Pane pane = (Pane)node;
            FxUtil.setPrefSize((Collection<? extends Node>)pane.getChildren());
        } else if (node instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)node;
            if (scrollPane.getContent() != null) {
                FxUtil.setPrefSize(scrollPane.getContent());
            }
        } else if (node instanceof SplitPane) {
            SplitPane splitPane = (SplitPane)node;
            FxUtil.setPrefSize((Collection<? extends Node>)splitPane.getItems());
        } else if (node instanceof TabPane) {
            TabPane tabPane = (TabPane)node;
            ObservableList tabList = tabPane.getTabs();
            int i = 0;
            while (i < tabList.size()) {
                Tab tab = (Tab)tabList.get(i);
                if (tab.getContent() != null) {
                    FxUtil.setPrefSize(tab.getContent());
                }
                ++i;
            }
        }
    }

    public static void setPrefSize(FxNodeUnit nodeUnit) throws Exception {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            FxUtil.setPrefSize(leftNode);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            if (rightNode != null) {
                FxUtil.setPrefSize(rightNode);
            }
            ++i;
        }
    }

    public static void setPrefSize_NodeUnit(Collection<? extends FxNodeUnit> nodeUnitCollection) throws Exception {
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            FxUtil.setPrefSize(fxNodeUnit);
        }
    }

    public static double getPrefWidth(Node node) throws Exception {
        double width = 0.0;
        if (node instanceof Region) {
            Region region = (Region)node;
            width = region.getPrefWidth();
        }
        return width;
    }

    public static double getPrefHeight(Node node) throws Exception {
        double height = 0.0;
        if (node instanceof CheckBox) {
            height = 22.0;
        } else if (node instanceof Control) {
            Control control = (Control)node;
            height = control.getPrefHeight();
        } else if (node instanceof Region) {
            Region region = (Region)node;
            height = region.getPrefHeight();
        }
        return height;
    }

    public static double getWidth(Node node) throws Exception {
        double width = 0.0;
        if (node instanceof Control) {
            Control control = (Control)node;
            width = control.getWidth();
        } else if (node instanceof Region) {
            Region region = (Region)node;
            width = region.getWidth();
        } else {
            BcLogUtil.error("Not Supported. node=" + node.getClass().getName());
        }
        return width;
    }

    public static double getHeight(Node node) throws Exception {
        double height = 0.0;
        if (node instanceof CheckBox) {
            height = ((CheckBox)node).getHeight();
        } else if (node instanceof Control) {
            Control control = (Control)node;
            height = control.getHeight();
        } else if (node instanceof Region) {
            Region region = (Region)node;
            height = region.getHeight();
        } else {
            BcLogUtil.error("Not Supported. node=" + node.getClass().getName());
        }
        return height;
    }

    public static void setLocation(Pane pane, Node node, double x, double y, double width, double height) {
        if (!pane.getChildren().contains((Object)node)) {
            pane.getChildren().add((Object)node);
        }
        node.relocate(x, y);
        if (width >= 0.0 || height >= 0.0) {
            node.resize(width, height);
        }
    }

    public static void setLocation(Pane pane, Node node, double x, double y) {
        FxUtil.setLocation(pane, node, x, y, -1.0, -1.0);
    }

    public static void setLocation(Pane pane, Region region, double x, double y, double width, double height) {
        if (width < 0.0) {
            width = region.getPrefWidth();
        }
        if (height < 0.0) {
            height = region.getPrefHeight();
        }
        region.setMinWidth(width);
        region.setMaxWidth(width);
        region.setMinHeight(height);
        region.setMaxHeight(height);
        FxUtil.setLocation(pane, (Node)region, x, y, width, height);
    }

    public static void setLocation(Pane pane, Control control, double x, double y, double width, double height) {
        if (width < 0.0) {
            width = control.getPrefWidth();
        }
        if (height < 0.0) {
            height = control.getPrefHeight();
        }
        control.setMinWidth(width);
        control.setMaxWidth(width);
        control.setMinHeight(height);
        control.setMaxHeight(height);
        FxUtil.setLocation(pane, (Node)control, x, y, width, height);
    }

    public static HPos toHPos(int swgHorizonalAlignment) {
        HPos hPos = null;
        switch (swgHorizonalAlignment) {
            case 0: {
                hPos = HPos.CENTER;
                break;
            }
            case 4: {
                hPos = HPos.RIGHT;
                break;
            }
            default: {
                hPos = HPos.LEFT;
            }
        }
        return hPos;
    }

    public static VPos toVPos(int swgVirticalAlignment) {
        VPos vPos = null;
        switch (swgVirticalAlignment) {
            case 0: {
                vPos = VPos.CENTER;
                break;
            }
            case 3: {
                vPos = VPos.BOTTOM;
                break;
            }
            default: {
                vPos = VPos.TOP;
            }
        }
        return vPos;
    }

    public static Pos toPos(HPos hPos, VPos vPos) {
        Pos pos = null;
        if (vPos == VPos.TOP) {
            if (hPos == HPos.LEFT) {
                pos = Pos.TOP_LEFT;
            } else if (hPos == HPos.CENTER) {
                pos = Pos.TOP_CENTER;
            } else if (hPos == HPos.RIGHT) {
                pos = Pos.TOP_RIGHT;
            }
        } else if (vPos == VPos.CENTER) {
            if (hPos == HPos.LEFT) {
                pos = Pos.CENTER_LEFT;
            } else if (hPos == HPos.CENTER) {
                pos = Pos.CENTER;
            } else if (hPos == HPos.RIGHT) {
                pos = Pos.CENTER_RIGHT;
            }
        } else if (vPos == VPos.BOTTOM) {
            if (hPos == HPos.LEFT) {
                pos = Pos.BOTTOM_LEFT;
            } else if (hPos == HPos.CENTER) {
                pos = Pos.BOTTOM_CENTER;
            } else if (hPos == HPos.RIGHT) {
                pos = Pos.BOTTOM_RIGHT;
            }
        }
        return pos;
    }

    public static Pos toPos(int swgHorizonalAlignment, int swgVirticalAlignment) {
        HPos hPos = FxUtil.toHPos(swgHorizonalAlignment);
        VPos vPos = FxUtil.toVPos(swgVirticalAlignment);
        return FxUtil.toPos(hPos, vPos);
    }

    public static TextAlignment toTextAlignment(int swgHorizonalAlignment) {
        TextAlignment textAlignment = null;
        switch (swgHorizonalAlignment) {
            case 0: {
                textAlignment = TextAlignment.CENTER;
                break;
            }
            case 4: {
                textAlignment = TextAlignment.RIGHT;
                break;
            }
            default: {
                textAlignment = TextAlignment.LEFT;
            }
        }
        return textAlignment;
    }

    public static Insets createInsets(Insets insets1, double top, double right, double bottom, double left) {
        Insets insets2 = new Insets(insets1.getTop() + top, insets1.getRight() + right, insets1.getBottom() + bottom, insets1.getLeft() + left);
        return insets2;
    }

    public static Insets createInsets(Insets insets, double addValue) {
        return FxUtil.createInsets(insets, addValue, addValue, addValue, addValue);
    }

    public static void setAlignment(Node node, Pos pos) {
        ScrollPane scrollPane;
        if (node instanceof Labeled) {
            Labeled labeled = (Labeled)node;
            labeled.setAlignment(pos);
        } else if (node instanceof TextField) {
            TextField textField = (TextField)node;
            textField.setAlignment(pos);
        } else if (node instanceof Pane) {
            Pane pane = (Pane)node;
            FxUtil.setAlignment((Collection<? extends Node>)pane.getChildren(), pos);
        } else if (node instanceof SplitPane) {
            SplitPane splitPane = (SplitPane)node;
            FxUtil.setAlignment((Collection<? extends Node>)splitPane.getItems(), pos);
        } else if (node instanceof ScrollPane && (scrollPane = (ScrollPane)node).getContent() != null) {
            FxUtil.setAlignment(scrollPane.getContent(), pos);
        }
    }

    public static void setAlignment(Collection<? extends Node> nodeCollection, Pos pos) {
        for (Node node : nodeCollection) {
            FxUtil.setAlignment(node, pos);
        }
    }

    public static void setVisible(Node node, boolean visible, Class targetClass) {
        if (node instanceof Pane) {
            Pane pane = (Pane)node;
            FxUtil.setVisible((Collection<? extends Node>)pane.getChildren(), visible, targetClass);
        } else if (node instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)node;
            FxUtil.setVisible(scrollPane.getContent(), visible, targetClass);
        } else if (targetClass.isAssignableFrom(node.getClass())) {
            node.setVisible(visible);
        }
    }

    public static void setVisible(Node node, boolean visible) {
        FxUtil.setVisible(node, visible, Node.class);
    }

    public static void setVisible(Collection<? extends Node> nodeCollection, boolean visible, Class targetClass) {
        for (Node node : nodeCollection) {
            FxUtil.setVisible(node, visible);
        }
    }

    public static void setVisible(Collection<? extends Node> nodeCollection, boolean visible) {
        FxUtil.setVisible(nodeCollection, visible, Node.class);
    }

    public static void setDisable(Node node, boolean disable, Class targetClass) {
        if (node instanceof FxFlowPane) {
            FxFlowPane flowPane = (FxFlowPane)node;
            FxUtil.setDisableNodeUnitCollection(flowPane.nodeUnitList, disable, targetClass);
        } else if (node instanceof Pane) {
            Pane pane = (Pane)node;
            FxUtil.setDisable((Collection<? extends Node>)pane.getChildren(), disable, targetClass);
        } else if (node instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)node;
            if (scrollPane.getContent() != null) {
                FxUtil.setDisable(scrollPane.getContent(), disable, targetClass);
            }
        } else if (node instanceof SplitPane) {
            SplitPane splitPane = (SplitPane)node;
            FxUtil.setDisable((Collection<? extends Node>)splitPane.getItems(), disable, targetClass);
        } else if (node instanceof TabPane) {
            TabPane tabPane = (TabPane)node;
            ObservableList tabList = tabPane.getTabs();
            int i = 0;
            while (i < tabList.size()) {
                Tab tab = (Tab)tabList.get(i);
                if (tab.getContent() != null) {
                    FxUtil.setDisable(tab.getContent(), disable, targetClass);
                }
                ++i;
            }
        } else if (targetClass.isAssignableFrom(node.getClass())) {
            node.setDisable(disable);
        }
    }

    public static void setDisable(Node node, boolean disable) {
        FxUtil.setDisable(node, disable, Node.class);
    }

    public static void setDisable(Collection<? extends Node> nodeCollection, boolean disable, Class targetClass) {
        for (Node node : nodeCollection) {
            FxUtil.setDisable(node, disable, targetClass);
        }
    }

    public static void setDisable(Collection<? extends Node> nodeCollection, boolean disable) {
        FxUtil.setDisable(nodeCollection, disable, Node.class);
    }

    public static void setDisable(FxNodeUnit nodeUnit, boolean disable, Class targetClass) {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            FxUtil.setDisable(leftNode, disable, targetClass);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            FxUtil.setDisable(rightNode, disable, targetClass);
            ++i;
        }
    }

    public static void setDisableNodeUnitCollection(Collection<? extends FxNodeUnit> nodeUnitCollection, boolean disable, Class targetClass) {
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            FxUtil.setDisable(fxNodeUnit, disable, targetClass);
        }
    }

    public static void setEditable(Node node, boolean editable) {
        if (node instanceof TextInputControl) {
            TextInputControl textInputControl = (TextInputControl)node;
            textInputControl.setEditable(editable);
        } else if (node instanceof ComboBoxBase) {
            FxUtil.setEditableButtonAndComboBox(node, editable, editable);
        } else if (!(node instanceof ButtonBase)) {
            ScrollPane scrollPane;
            if (node instanceof FxFlowPane) {
                FxFlowPane flowPane = (FxFlowPane)node;
                FxUtil.setEditableNodeUnitCollection(flowPane.nodeUnitList, editable);
            } else if (node instanceof Pane) {
                Pane pane = (Pane)node;
                FxUtil.setEditable((Collection<? extends Node>)pane.getChildren(), editable);
            } else if (node instanceof ScrollPane && (scrollPane = (ScrollPane)node).getContent() != null) {
                FxUtil.setEditable(scrollPane.getContent(), editable);
            }
        }
    }

    public static void setEditable(Collection<? extends Node> nodeCollection, boolean editable) {
        for (Node node : nodeCollection) {
            FxUtil.setEditable(node, editable);
        }
    }

    public static void setEditableButtonAndComboBox(Node node, boolean editable, boolean comboBoxEditable) {
        if (node instanceof ButtonBase) {
            ButtonBase buttonBase = (ButtonBase)node;
            buttonBase.setDisable(!editable);
        } else if (node instanceof ComboBoxBase) {
            ComboBoxBase comboBoxBase = (ComboBoxBase)node;
            comboBoxBase.setEditable(comboBoxEditable);
            comboBoxBase.setDisable(!editable);
        }
    }

    public static void setEditable(FxNodeUnit nodeUnit, boolean editable) {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            FxUtil.setEditable(leftNode, editable);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            FxUtil.setEditable(rightNode, editable);
            ++i;
        }
    }

    public static void setEditableNodeUnitCollection(Collection<? extends FxNodeUnit> nodeUnitCollection, boolean editable) {
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            FxUtil.setEditable(fxNodeUnit, editable);
        }
    }

    public static void setOpacity(Node node, double opacity) {
        if (node instanceof Pane) {
            Pane pane = (Pane)node;
            FxUtil.setOpacity((Collection<? extends Node>)pane.getChildren(), opacity);
        } else if (node instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)node;
            FxUtil.setOpacity(scrollPane.getContent(), opacity);
        } else {
            node.setOpacity(opacity);
        }
    }

    public static void setOpacity(Collection<? extends Node> nodeCollection, double opacity) {
        for (Node node : nodeCollection) {
            FxUtil.setOpacity(node, opacity);
        }
    }

    public static void setFont(Node node, Font font) throws Exception {
        block25: {
            block23: {
                block26: {
                    block24: {
                        if (!(node instanceof Labeled)) break block23;
                        if (!(node instanceof ButtonBase)) break block24;
                        ButtonBase buttonBase = (ButtonBase)node;
                        buttonBase.setFont(font);
                        break block25;
                    }
                    if (!(node instanceof TitledPane)) break block26;
                    TitledPane titledPane = (TitledPane)node;
                    titledPane.setFont(font);
                    if (titledPane.getContent() != null) {
                        FxUtil.setFont(titledPane.getContent(), font);
                    }
                    break block25;
                }
                if (!(node instanceof Label)) break block25;
                Labeled labeled = (Labeled)node;
                labeled.setFont(font);
                break block25;
            }
            if (node instanceof TextField) {
                TextField textField = (TextField)node;
                textField.setFont(font);
            } else if (node instanceof TextArea) {
                TextArea textField = (TextArea)node;
                textField.setFont(font);
            } else if (node instanceof Text) {
                Text text = (Text)node;
                text.setFont(font);
            } else if (node instanceof PasswordField) {
                PasswordField passwordField = (PasswordField)node;
                passwordField.setFont(font);
            } else if (node instanceof ComboBox) {
                ComboBox comboBox = (ComboBox)node;
                comboBox.getEditor().setFont(font);
            } else if (node instanceof FxFlowPane) {
                FxFlowPane flowPane = (FxFlowPane)node;
                FxUtil.setFont_NodeUnit(flowPane.nodeUnitList, font);
            } else if (node instanceof Pane) {
                Pane pane = (Pane)node;
                FxUtil.setFont((Collection<? extends Node>)pane.getChildren(), font);
            } else if (node instanceof ScrollPane) {
                ScrollPane scrollPane = (ScrollPane)node;
                if (scrollPane.getContent() != null) {
                    FxUtil.setFont(scrollPane.getContent(), font);
                }
            } else if (node instanceof SplitPane) {
                SplitPane splitPane = (SplitPane)node;
                FxUtil.setFont((Collection<? extends Node>)splitPane.getItems(), font);
            } else if (node instanceof TabPane) {
                TabPane tabPane = (TabPane)node;
                ObservableList tabList = tabPane.getTabs();
                int i = 0;
                while (i < tabList.size()) {
                    Tab tab = (Tab)tabList.get(i);
                    if (tab.getContent() != null) {
                        FxUtil.setFont(tab.getContent(), font);
                    }
                    ++i;
                }
            }
        }
    }

    public static void setFont(Collection<? extends Node> nodeCollection, Font font) throws Exception {
        for (Node node : nodeCollection) {
            FxUtil.setFont(node, font);
        }
    }

    public static void setFont(FxNodeUnit nodeUnit, Font font) throws Exception {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            FxUtil.setFont(leftNode, font);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            FxUtil.setFont(rightNode, font);
            ++i;
        }
    }

    public static void setFont_NodeUnit(Collection<? extends FxNodeUnit> nodeUnitCollection, Font font) throws Exception {
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            FxUtil.setFont(fxNodeUnit, font);
        }
    }

    public static void setLabelAlignment(Node node, Pos pos) {
        if (node instanceof Label) {
            Label label = (Label)node;
            label.setAlignment(pos);
        } else if (node instanceof Pane) {
            Pane pane = (Pane)node;
            FxUtil.setLabelAlignment((Collection<? extends Node>)pane.getChildren(), pos);
        } else if (node instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)node;
            FxUtil.setLabelAlignment(scrollPane.getContent(), pos);
        }
    }

    public static void setLabelAlignment(Collection<? extends Node> nodeCollection, Pos pos) {
        for (Node node : nodeCollection) {
            FxUtil.setLabelAlignment(node, pos);
        }
    }

    public static void setLine(Line line, double x1, double y1, double x2, double y2) {
        line.setStartX(x1);
        line.setStartY(y1);
        line.setEndX(x2);
        line.setEndY(y2);
    }

    public static Rectangle2D calcWindowSize(Rectangle2D visualBounds, double minWidth, double minHilght, double maxWidth, double maxHilght) {
        Rectangle awtScreenRect = FxUtil.toAwtRectangle2D(visualBounds);
        Rectangle awtWindowRect = AwtUtil.calcCascadeRectangle(awtScreenRect.x, awtScreenRect.y, (int)minWidth, (int)minHilght, (int)maxWidth, (int)maxHilght);
        Rectangle2D windowRect = FxUtil.toRectangle2D(awtWindowRect);
        return windowRect;
    }

    public static Window getWindow(Node node) {
        Scene scene = node.getScene();
        if (scene == null) {
            return null;
        }
        return scene.getWindow();
    }

    public static Object getWindow2(Object uiObject) throws Exception {
        if (uiObject instanceof Node) {
            Node node = (Node)uiObject;
            return node.getScene().getWindow();
        }
        if (uiObject instanceof Component) {
            Component component = (Component)uiObject;
            return SwgUtil.getWindow(component);
        }
        throw new IllegalArgumentException("uiObject=" + uiObject);
    }

    public static void setWindowLocation(Window window, double x, double y, double width, double hilgh) {
        window.setX(x);
        window.setY(y);
        window.setWidth(width);
        window.setHeight(hilgh);
    }

    public static void setWindowLocation(Window window, Rectangle2D rectangle) {
        FxUtil.setWindowLocation(window, rectangle.getMinX(), rectangle.getMinY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static Rectangle2D setWindowSize(Window window, double minWidth, double minHilght, double maxWidth, double maxHilght, boolean isCenter) {
        Rectangle2D visualBounds = Screen.getPrimary().getVisualBounds();
        Rectangle2D windowSize = FxUtil.calcWindowSize(visualBounds, minWidth, minHilght, maxWidth, maxHilght);
        window.setWidth(windowSize.getWidth());
        window.setHeight(windowSize.getHeight());
        if (isCenter) {
            window.centerOnScreen();
        }
        return windowSize;
    }

    public static Rectangle2D setWindowSize(Window window, double width, double hilght, boolean isCenter) {
        return FxUtil.setWindowSize(window, width, hilght, width, hilght, isCenter);
    }

    public static void setWindowCascade(Window window, Window baseWindow, double width, double height) {
        Rectangle awtRectangle = AwtUtil.calcCascadeRectangle((int)baseWindow.getX(), (int)baseWindow.getY(), (int)width, (int)height);
        FxUtil.setWindowLocation(window, FxUtil.toRectangle2D(awtRectangle));
    }

    public static void setWindowCascade(Window window, Window baseWindow, double ratio) {
        Dimension awtDimension = AwtUtil.calcDimensionByRatio(ratio);
        FxUtil.setWindowCascade(window, baseWindow, awtDimension.width, awtDimension.height);
    }

    public static void setWindowCenter(Window window, double xMargin, double yMargin) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        window.setWidth(screenSize.getWidth() - xMargin * 2.0);
        window.setHeight(screenSize.getHeight() - yMargin * 2.0);
        window.centerOnScreen();
    }

    public static void setWindowCenter(Window window, double ratio) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        window.setWidth(screenSize.getWidth() * ratio);
        window.setHeight(screenSize.getHeight() * ratio);
        window.centerOnScreen();
    }

    public static void setWindowFull(Window window) {
        FxUtil.setWindowCenter(window, 1.0);
    }

    public static void setWindowLowerLeft(Window window, double margin) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double y = screenSize.getHeight() - window.getHeight() - margin;
        window.setX(margin);
        window.setY(y);
    }

    public static void defaultInitialize(Node node) throws Exception {
        FxUtil.setPrefSize(node);
        FxSkinDefault skin = FxSkinUtil.getSkin();
        skin.setStyle(node);
    }

    public static void defaultInitialize(Collection<? extends Node> nodeCollection) throws Exception {
        for (Node node : nodeCollection) {
            FxUtil.defaultInitialize(node);
        }
    }

    public static void defaultInitialize(FxNodeUnit nodeUnit) throws Exception {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            FxUtil.defaultInitialize(leftNode);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            FxUtil.defaultInitialize(rightNode);
            ++i;
        }
    }

    public static void defaultInitialize_NodeUnit(Collection<? extends FxNodeUnit> nodeUnitCollection) throws Exception {
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            FxUtil.defaultInitialize(fxNodeUnit);
        }
    }

    public static File initFileChooser(FileChooser fileChooser, File file) throws Exception {
        File fileWk = null;
        if (file != null) {
            fileWk = BcFileUtil.findFile(file);
        }
        if (fileWk == null) {
            fileWk = BcRuntimeUtil.getUserHomeDir();
        }
        if (fileWk.isDirectory()) {
            fileChooser.setInitialDirectory(fileWk);
            fileChooser.setInitialFileName(null);
        } else {
            File parentFile = fileWk.getParentFile();
            String fileName = fileWk.getName();
            if (parentFile == null) {
                parentFile = fileWk;
                fileName = null;
            }
            fileChooser.setInitialDirectory(parentFile);
            fileChooser.setInitialFileName(fileName);
        }
        return fileWk;
    }

    public static File initFileChooser(FileChooser fileChooser, String filePath) throws Exception {
        File file = null;
        if (!BcStringUtil.isEmpty(filePath)) {
            file = new File(filePath);
        }
        return FxUtil.initFileChooser(fileChooser, file);
    }

    public static File initDirectoryChooser(DirectoryChooser directoryChooser, File file) throws Exception {
        File fileWk = null;
        if (file != null) {
            fileWk = BcFileUtil.findFile(file);
        }
        if (fileWk == null) {
            fileWk = BcRuntimeUtil.getUserHomeDir();
        }
        if (fileWk.isDirectory()) {
            directoryChooser.setInitialDirectory(fileWk);
        } else {
            File parentFile = fileWk.getParentFile();
            if (parentFile == null) {
                parentFile = fileWk;
            }
            directoryChooser.setInitialDirectory(parentFile);
        }
        return fileWk;
    }

    public static File initDirectoryChooser(DirectoryChooser directoryChooser, String filePath) throws Exception {
        File file = null;
        if (!BcStringUtil.isEmpty(filePath)) {
            file = new File(filePath);
        }
        return FxUtil.initDirectoryChooser(directoryChooser, file);
    }

    public static javafx.scene.image.Image convImage(Image awtImage) throws Exception {
        BufferedImage bufImage = AwtImageUtil.toBufferedImage(awtImage);
        WritableImage image = SwingFXUtils.toFXImage((BufferedImage)bufImage, null);
        return image;
    }

    public static Tab findTabByName(TabPane tabPane, String name) throws Exception {
        ObservableList tabList = tabPane.getTabs();
        int i = 0;
        while (i < tabList.size()) {
            Tab tab = (Tab)tabList.get(i);
            if (BcStringUtil.equals(tab.getText(), name)) {
                return tab;
            }
            ++i;
        }
        return null;
    }

    public static FxArrangementHint createArrangementHint(Font font) throws Exception {
        FxArrangementHint arrangementHint = new FxArrangementHint();
        arrangementHint.topMargin = 2.0;
        arrangementHint.leftMargin = 4.0;
        arrangementHint.rowHeight = FxUtil.getTextFieldSize(font, 1).getHeight();
        arrangementHint.rowSpace = 2.0;
        arrangementHint.labelWidth = FxUtil.getTextFieldSize(font, 16).getWidth();
        arrangementHint.columnSpace = 2.0;
        arrangementHint.fieldX = arrangementHint.leftMargin + arrangementHint.labelWidth + arrangementHint.columnSpace;
        arrangementHint.fieldWidth = FxUtil.getTextFieldSize(font, 28).getWidth();
        return arrangementHint;
    }

    public static Rectangle2D calcToKeepScale(double srcWidth, double srcHeight, double targetWidth, double targetHeight) {
        Rectangle2D.Double awtRectangle = AwtImageUtil.calcKeepRatioSize(srcWidth, srcHeight, targetWidth, targetHeight);
        return FxUtil.toRectangle2D(awtRectangle);
    }

    public static void setKeepScaleSize(Node node, double width, double height) {
        if (node instanceof Region) {
            Region region = (Region)node;
            Rectangle2D rectangle2D = FxUtil.calcToKeepScale(region.getPrefWidth(), region.getPrefHeight(), width, height);
            Dimension2D dimension2D = FxUtil.toDimension2D(rectangle2D);
            FxUtil.setPrefSize(region, dimension2D);
        } else if (node instanceof ImageView) {
            ImageView imageView = (ImageView)node;
            javafx.scene.image.Image image = imageView.getImage();
            Rectangle2D rectangle2D = FxUtil.calcToKeepScale(image.getWidth(), image.getHeight(), width, height);
            imageView.setSmooth(true);
            imageView.setFitWidth(rectangle2D.getWidth());
            imageView.setPreserveRatio(true);
        } else if (node instanceof MediaView) {
            MediaView mediaView = (MediaView)node;
            Rectangle2D rectangle2D = FxUtil.calcToKeepScale(mediaView.getFitWidth(), mediaView.getFitHeight(), width, height);
            mediaView.setSmooth(true);
            mediaView.setFitWidth(rectangle2D.getWidth());
            mediaView.setPreserveRatio(true);
        }
    }

    public static void setKeepScaleSize(Collection<? extends Node> nodeCollection, double width, double height) throws Exception {
        for (Node node : nodeCollection) {
            FxUtil.setKeepScaleSize(node, width, height);
        }
    }

    public static void setZoomRatio(Collection<? extends Node> nodeCollection, double ratio) throws Exception {
        for (Node node : nodeCollection) {
            if (node instanceof Region) {
                Region region = (Region)node;
                region.setPrefSize(region.getWidth() * ratio, region.getHeight() * ratio);
                continue;
            }
            if (!(node instanceof ImageView)) continue;
            ImageView imageView = (ImageView)node;
            javafx.scene.image.Image image = imageView.getImage();
            double width = image.getWidth() * ratio;
            double height = image.getHeight() * ratio;
            imageView.setFitWidth(width);
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
        }
    }

    public static double computePrefWrapLength(FlowPane flowPane) throws Exception {
        double wrapLength = 0.0;
        int regionCount = 0;
        for (Node node : flowPane.getChildren()) {
            if (!(node instanceof Region)) continue;
            Region region = (Region)node;
            ++regionCount;
            wrapLength += Math.max(region.getPrefWidth(), region.getWidth());
            Insets margin = FlowPane.getMargin((Node)node);
            if (margin == null) continue;
            wrapLength += margin.getLeft();
            wrapLength += margin.getRight();
        }
        if (regionCount > 0) {
            wrapLength += flowPane.getHgap() * (double)(regionCount - 1);
        }
        return wrapLength;
    }

    public static void setPrefWrapLength(FlowPane flowPane) throws Exception {
        double prefWrapLength = FxUtil.computePrefWrapLength(flowPane);
        flowPane.setPrefWrapLength(prefWrapLength);
        double prefWidth = prefWrapLength;
        Insets insets = flowPane.getPadding();
        if (insets != null) {
            prefWidth += insets.getLeft();
            prefWidth += insets.getRight();
        }
        flowPane.setPrefWidth(prefWidth += 100.0);
    }

    public static void setEqualityGrid(GridPane gridPane, int columnCount, int rowCount) throws Exception {
        int i = 0;
        while (i < columnCount) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setPercentWidth(100.0);
            gridPane.getColumnConstraints().add((Object)columnConstraints);
            ++i;
        }
        i = 0;
        while (i < rowCount) {
            RowConstraints rowConstraints = new RowConstraints();
            rowConstraints.setPercentHeight(100.0);
            gridPane.getRowConstraints().add((Object)rowConstraints);
            ++i;
        }
    }

    public static double computeNodeUnitWidth(FxNodeUnit nodeUnit, double leftRightSpace, double rightNodeSpace) throws Exception {
        double width = FxUtil.computeLeftWidth(nodeUnit);
        width += leftRightSpace;
        int rightNodeCnt = 0;
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            if (rightNode != null) {
                if (++rightNodeCnt > 1) {
                    width += rightNodeSpace;
                }
                width += FxUtil.getPrefWidth(rightNode);
            }
            ++i;
        }
        return width;
    }

    public static double computeHeight(FxNodeUnit nodeUnit) throws Exception {
        double heightMax = 0.0;
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            heightMax = Math.max(heightMax, FxUtil.getPrefHeight(leftNode));
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            if (rightNode != null) {
                heightMax = Math.max(heightMax, FxUtil.getPrefHeight(rightNode));
            }
            ++i;
        }
        return heightMax;
    }

    public static double computeHeightMax(Collection<FxNodeUnit> nodeUnitCollection) throws Exception {
        double unitHeightMax = 0.0;
        for (FxNodeUnit nodeUnit : nodeUnitCollection) {
            double unitHeight = FxUtil.computeHeight(nodeUnit);
            unitHeightMax = Math.max(unitHeightMax, unitHeight);
        }
        return unitHeightMax;
    }

    public static double computeLeftWidth(FxNodeUnit nodeUnit) throws Exception {
        double leftNodeWidth = 0.0;
        Node node = nodeUnit.getLeftNode();
        if (node != null) {
            leftNodeWidth = FxUtil.getPrefWidth(node);
        }
        return leftNodeWidth;
    }

    public static double computeLeftWidthMax(Collection<? extends FxNodeUnit> nodeUnitCollection) throws Exception {
        double widthMax = 0.0;
        for (FxNodeUnit fxNodeUnit : nodeUnitCollection) {
            if (fxNodeUnit.leftNodeHandling == 1) continue;
            double width = FxUtil.computeLeftWidth(fxNodeUnit);
            widthMax = Math.max(widthMax, width);
        }
        return widthMax;
    }

    public static double computeLeftWidthMax(List<? extends List<? extends FxNodeUnit>> nodeUnitListList) throws Exception {
        double widthMax = 0.0;
        for (List<? extends FxNodeUnit> list : nodeUnitListList) {
            FxNodeUnit nodeUnit = BcCollectionUtil.getFirst(list);
            if (nodeUnit == null || nodeUnit.leftNodeHandling == 1) continue;
            double width = FxUtil.computeLeftWidth(nodeUnit);
            widthMax = Math.max(widthMax, width);
        }
        return widthMax;
    }

    public static void setInsets(BorderPane borderPane, double insetsSize) throws Exception {
        Node centerNode;
        Node leftNode;
        Node bottomNode;
        Node rightNode;
        double insetsSizeHalf = insetsSize / 2.0;
        Node topNode = borderPane.getTop();
        if (topNode != null) {
            Insets insets = new Insets(insetsSize, insetsSize, insetsSizeHalf, insetsSize);
            BorderPane.setMargin((Node)topNode, (Insets)insets);
        }
        if ((rightNode = borderPane.getRight()) != null) {
            Insets insets = new Insets(insetsSizeHalf, insetsSize, insetsSizeHalf, insetsSizeHalf);
            BorderPane.setMargin((Node)rightNode, (Insets)insets);
        }
        if ((bottomNode = borderPane.getBottom()) != null) {
            Insets insets = new Insets(insetsSizeHalf, insetsSize, insetsSize, insetsSize);
            BorderPane.setMargin((Node)bottomNode, (Insets)insets);
        }
        if ((leftNode = borderPane.getLeft()) != null) {
            Insets insets = new Insets(insetsSizeHalf, insetsSizeHalf, insetsSizeHalf, insetsSize);
            BorderPane.setMargin((Node)leftNode, (Insets)insets);
        }
        if ((centerNode = borderPane.getCenter()) != null) {
            Insets insets = new Insets(insetsSizeHalf, insetsSizeHalf, insetsSizeHalf, insetsSizeHalf);
            BorderPane.setMargin((Node)centerNode, (Insets)insets);
        }
    }

    public static void showAndToFront(Stage stage) throws Exception {
        if (!stage.isShowing()) {
            stage.show();
        }
        stage.toFront();
    }

    public static Pane createPane(double prefWidth, double prefHeight) throws Exception {
        Pane pane = new Pane();
        if (prefWidth >= 0.0) {
            pane.setPrefWidth(prefWidth);
        }
        if (prefHeight >= 0.0) {
            pane.setPrefHeight(prefHeight);
        }
        return pane;
    }

    public static void resetChildren(Pane pane, Node ... nodes) throws Exception {
        pane.getChildren().clear();
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            if (node != null) {
                pane.getChildren().add((Object)node);
            }
            ++i;
        }
    }

    public static List<String> getValusList(Collection<? extends TextInputControl> textInputControlCollection) throws Exception {
        ArrayList<String> valuseList = new ArrayList<String>();
        for (TextInputControl textInputControl : textInputControlCollection) {
            valuseList.add(textInputControl.getText());
        }
        return valuseList;
    }

    public static List<String> getValusList(Collection<? extends TextInputControl> textInputControlCollection, boolean trim, boolean removeEmpty) throws Exception {
        List<String> valuseList = FxUtil.getValusList(textInputControlCollection);
        return FxUtil.createNewList(valuseList, trim, removeEmpty);
    }

    public static List<String> getValusList(boolean trim, boolean removeEmpty, TextInputControl ... textInputControls) throws Exception {
        List<TextInputControl> textInputControlList = Arrays.asList(textInputControls);
        return FxUtil.getValusList(textInputControlList, trim, removeEmpty);
    }

    public static List<String> createNewList(Collection<String> stringCollection, boolean trim, boolean removeEmpty) {
        ArrayList<String> newList = new ArrayList<String>();
        Iterator<String> iterator = stringCollection.iterator();
        while (iterator.hasNext()) {
            String str1;
            String str2 = str1 = iterator.next();
            if (trim) {
                str2 = BcStringUtil.trim(str2);
            }
            if (removeEmpty && BcStringUtil.isEmpty(str2)) continue;
            newList.add(str2);
        }
        return newList;
    }

    public static boolean isDoubleClicked(MouseEvent ev) throws Exception {
        boolean doubleClicked = false;
        if (ev.getButton() == MouseButton.PRIMARY) {
            doubleClicked = ev.getClickCount() == 2;
        }
        return doubleClicked;
    }

    public static void setPaddingDefault(Region region) throws Exception {
        region.setPadding(new Insets(4.0, insetDefault, 4.0, insetDefault));
    }

    public static void setOkButton(ButtonBase buttonBase, String text, String tooltipText) throws Exception {
        buttonBase.setText(text);
        buttonBase.setGraphic((Node)FxImageHelper.createImageView_icon("check_64x64.png"));
        buttonBase.setTooltip(new Tooltip(tooltipText));
    }

    public static FxButton createOkButton(String text, String tooltipText) throws Exception {
        FxButton button = new FxButton();
        FxUtil.setOkButton((ButtonBase)button, text, tooltipText);
        return button;
    }

    public static FxButton createOkButton() throws Exception {
        return FxUtil.createOkButton(BcWords.getInstance().ok, null);
    }

    public static FxButton createCompletionButton() throws Exception {
        return FxUtil.createOkButton(BcWords.getInstance().completion, null);
    }

    public static FxButton createCancelButton(String text, String tooltipText) throws Exception {
        FxButton button = new FxButton();
        button.setText(text);
        button.setGraphic((Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
        button.setTooltip(new Tooltip(tooltipText));
        return button;
    }

    public static FxButton createCancelButton() throws Exception {
        return FxUtil.createCancelButton(BcWords.getInstance().cancel, null);
    }

    public static FxButton createCloseButton(String text, String tooltipText) throws Exception {
        return FxUtil.createCancelButton(text, tooltipText);
    }

    public static FxButton createCloseButton() throws Exception {
        return FxUtil.createCloseButton(BcWords.getInstance().close, null);
    }

    public static FxButton createExecuteButton(String text, String tooltipText) throws Exception {
        FxButton button = new FxButton();
        button.setText(text);
        button.setGraphic((Node)FxImageHelper.createImageView_icon("bullet_triangle_blue_64x64.png"));
        button.setTooltip(new Tooltip(tooltipText));
        return button;
    }

    public static FxButton createExecuteButton() throws Exception {
        return FxUtil.createExecuteButton(BcWords.getInstance().execute, null);
    }

    public static FxButton createBrowsButton(String text, String tooltipText) throws Exception {
        FxButton button = new FxButton();
        button.setText(text);
        button.setGraphic((Node)FxImageHelper.createImageView_icon("find_64x64.png"));
        button.setTooltip(new Tooltip(tooltipText));
        return button;
    }

    public static FxButton createBrowsButton(String text) throws Exception {
        return FxUtil.createBrowsButton(text, null);
    }

    public static FxButton createSaveButton(String text, String tooltipText) throws Exception {
        FxButton button = new FxButton();
        button.setText(text);
        button.setGraphic((Node)FxImageHelper.createImageView_icon("floppy_disk_64x64.png"));
        button.setTooltip(new Tooltip(tooltipText));
        return button;
    }

    public static FxButton createSaveButton() throws Exception {
        return FxUtil.createSaveButton(BcWords.getInstance().save, null);
    }
}

