/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.charset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Arrays;

public final class BcUtf8Util {
    public static final byte[] bomBytes = new byte[]{-17, -69, -65};

    private BcUtf8Util() {
    }

    public static InputStream skipBom(InputStream is) throws Exception {
        if (is.available() < bomBytes.length) {
            return is;
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        is.mark(bomBytes.length);
        byte[] bytes = new byte[3];
        is.read(bytes, 0, bomBytes.length);
        boolean doReset = false;
        int i = 0;
        while (i < bomBytes.length) {
            if (bytes[i] != bomBytes[i]) {
                doReset = true;
                break;
            }
            ++i;
        }
        if (doReset) {
            is.reset();
        }
        return is;
    }

    public static boolean hasBom(InputStream is) throws Exception {
        if (is.available() < bomBytes.length) {
            return false;
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        is.mark(bomBytes.length);
        byte[] bytes = new byte[bomBytes.length];
        is.read(bytes, 0, bomBytes.length);
        if (!Arrays.equals(bomBytes, bytes)) {
            is.reset();
            return false;
        }
        return true;
    }
}

