/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.taskdefs.optional.extension.Compatibility;
import org.apache.tools.ant.util.DeweyDecimal;
import org.apache.tools.ant.util.StringUtils;

public final class Extension {
    public static final Attributes.Name EXTENSION_LIST = new Attributes.Name("Extension-List");
    public static final Attributes.Name OPTIONAL_EXTENSION_LIST = new Attributes.Name("Optional-Extension-List");
    public static final Attributes.Name EXTENSION_NAME = new Attributes.Name("Extension-Name");
    public static final Attributes.Name SPECIFICATION_VERSION = Attributes.Name.SPECIFICATION_VERSION;
    public static final Attributes.Name SPECIFICATION_VENDOR = Attributes.Name.SPECIFICATION_VENDOR;
    public static final Attributes.Name IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    public static final Attributes.Name IMPLEMENTATION_VENDOR = Attributes.Name.IMPLEMENTATION_VENDOR;
    public static final Attributes.Name IMPLEMENTATION_URL = new Attributes.Name("Implementation-URL");
    public static final Attributes.Name IMPLEMENTATION_VENDOR_ID = new Attributes.Name("Implementation-Vendor-Id");
    public static final Compatibility COMPATIBLE = new Compatibility("COMPATIBLE");
    public static final Compatibility REQUIRE_SPECIFICATION_UPGRADE = new Compatibility("REQUIRE_SPECIFICATION_UPGRADE");
    public static final Compatibility REQUIRE_VENDOR_SWITCH = new Compatibility("REQUIRE_VENDOR_SWITCH");
    public static final Compatibility REQUIRE_IMPLEMENTATION_UPGRADE = new Compatibility("REQUIRE_IMPLEMENTATION_UPGRADE");
    public static final Compatibility INCOMPATIBLE = new Compatibility("INCOMPATIBLE");
    private String extensionName;
    private DeweyDecimal specificationVersion;
    private String specificationVendor;
    private String implementationVendorID;
    private String implementationVendor;
    private DeweyDecimal implementationVersion;
    private String implementationURL;

    public static Extension[] getAvailable(Manifest manifest) {
        Extension extension;
        if (manifest == null) {
            return new Extension[0];
        }
        ArrayList<Extension> results = new ArrayList<Extension>();
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null && (extension = Extension.getExtension("", mainAttributes)) != null) {
            results.add(extension);
        }
        Map<String, Attributes> entries = manifest.getEntries();
        for (String key : entries.keySet()) {
            Attributes attributes = entries.get(key);
            Extension extension2 = Extension.getExtension("", attributes);
            if (extension2 == null) continue;
            results.add(extension2);
        }
        return results.toArray(new Extension[results.size()]);
    }

    public static Extension[] getRequired(Manifest manifest) {
        return Extension.getListed(manifest, Attributes.Name.EXTENSION_LIST);
    }

    public static Extension[] getOptions(Manifest manifest) {
        return Extension.getListed(manifest, OPTIONAL_EXTENSION_LIST);
    }

    public static void addExtension(Extension extension, Attributes attributes) {
        Extension.addExtension(extension, "", attributes);
    }

    public static void addExtension(Extension extension, String prefix, Attributes attributes) {
        String implementationURL;
        DeweyDecimal implementationVersion;
        String implementationVendor;
        String implementationVendorID;
        DeweyDecimal specificationVersion;
        attributes.putValue(String.valueOf(prefix) + EXTENSION_NAME, extension.getExtensionName());
        String specificationVendor = extension.getSpecificationVendor();
        if (specificationVendor != null) {
            attributes.putValue(String.valueOf(prefix) + SPECIFICATION_VENDOR, specificationVendor);
        }
        if ((specificationVersion = extension.getSpecificationVersion()) != null) {
            attributes.putValue(String.valueOf(prefix) + SPECIFICATION_VERSION, specificationVersion.toString());
        }
        if ((implementationVendorID = extension.getImplementationVendorID()) != null) {
            attributes.putValue(String.valueOf(prefix) + IMPLEMENTATION_VENDOR_ID, implementationVendorID);
        }
        if ((implementationVendor = extension.getImplementationVendor()) != null) {
            attributes.putValue(String.valueOf(prefix) + IMPLEMENTATION_VENDOR, implementationVendor);
        }
        if ((implementationVersion = extension.getImplementationVersion()) != null) {
            attributes.putValue(String.valueOf(prefix) + IMPLEMENTATION_VERSION, implementationVersion.toString());
        }
        if ((implementationURL = extension.getImplementationURL()) != null) {
            attributes.putValue(String.valueOf(prefix) + IMPLEMENTATION_URL, implementationURL);
        }
    }

    public Extension(String extensionName, String specificationVersion, String specificationVendor, String implementationVersion, String implementationVendor, String implementationVendorId, String implementationURL) {
        this.extensionName = extensionName;
        this.specificationVendor = specificationVendor;
        if (specificationVersion != null) {
            try {
                this.specificationVersion = new DeweyDecimal(specificationVersion);
            }
            catch (NumberFormatException nfe) {
                String error = "Bad specification version format '" + specificationVersion + "' in '" + extensionName + "'. (Reason: " + nfe + ")";
                throw new IllegalArgumentException(error);
            }
        }
        this.implementationURL = implementationURL;
        this.implementationVendor = implementationVendor;
        this.implementationVendorID = implementationVendorId;
        if (implementationVersion != null) {
            try {
                this.implementationVersion = new DeweyDecimal(implementationVersion);
            }
            catch (NumberFormatException nfe) {
                String error = "Bad implementation version format '" + implementationVersion + "' in '" + extensionName + "'. (Reason: " + nfe + ")";
                throw new IllegalArgumentException(error);
            }
        }
        if (this.extensionName == null) {
            throw new NullPointerException("extensionName property is null");
        }
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public DeweyDecimal getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getImplementationURL() {
        return this.implementationURL;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public String getImplementationVendorID() {
        return this.implementationVendorID;
    }

    public DeweyDecimal getImplementationVersion() {
        return this.implementationVersion;
    }

    public Compatibility getCompatibilityWith(Extension required) {
        if (!this.extensionName.equals(required.getExtensionName())) {
            return INCOMPATIBLE;
        }
        DeweyDecimal requiredSpecificationVersion = required.getSpecificationVersion();
        if (!(requiredSpecificationVersion == null || this.specificationVersion != null && this.isCompatible(this.specificationVersion, requiredSpecificationVersion))) {
            return REQUIRE_SPECIFICATION_UPGRADE;
        }
        String requiredImplementationVendorID = required.getImplementationVendorID();
        if (!(requiredImplementationVendorID == null || this.implementationVendorID != null && this.implementationVendorID.equals(requiredImplementationVendorID))) {
            return REQUIRE_VENDOR_SWITCH;
        }
        DeweyDecimal requiredImplementationVersion = required.getImplementationVersion();
        if (!(requiredImplementationVersion == null || this.implementationVersion != null && this.isCompatible(this.implementationVersion, requiredImplementationVersion))) {
            return REQUIRE_IMPLEMENTATION_UPGRADE;
        }
        return COMPATIBLE;
    }

    public boolean isCompatibleWith(Extension required) {
        return COMPATIBLE == this.getCompatibilityWith(required);
    }

    public String toString() {
        String brace = ": ";
        StringBuffer sb = new StringBuffer(EXTENSION_NAME.toString());
        sb.append(": ");
        sb.append(this.extensionName);
        sb.append(StringUtils.LINE_SEP);
        if (this.specificationVersion != null) {
            sb.append(SPECIFICATION_VERSION);
            sb.append(": ");
            sb.append(this.specificationVersion);
            sb.append(StringUtils.LINE_SEP);
        }
        if (this.specificationVendor != null) {
            sb.append(SPECIFICATION_VENDOR);
            sb.append(": ");
            sb.append(this.specificationVendor);
            sb.append(StringUtils.LINE_SEP);
        }
        if (this.implementationVersion != null) {
            sb.append(IMPLEMENTATION_VERSION);
            sb.append(": ");
            sb.append(this.implementationVersion);
            sb.append(StringUtils.LINE_SEP);
        }
        if (this.implementationVendorID != null) {
            sb.append(IMPLEMENTATION_VENDOR_ID);
            sb.append(": ");
            sb.append(this.implementationVendorID);
            sb.append(StringUtils.LINE_SEP);
        }
        if (this.implementationVendor != null) {
            sb.append(IMPLEMENTATION_VENDOR);
            sb.append(": ");
            sb.append(this.implementationVendor);
            sb.append(StringUtils.LINE_SEP);
        }
        if (this.implementationURL != null) {
            sb.append(IMPLEMENTATION_URL);
            sb.append(": ");
            sb.append(this.implementationURL);
            sb.append(StringUtils.LINE_SEP);
        }
        return sb.toString();
    }

    private boolean isCompatible(DeweyDecimal first, DeweyDecimal second) {
        return first.isGreaterThanOrEqual(second);
    }

    private static Extension[] getListed(Manifest manifest, Attributes.Name listKey) {
        ArrayList results = new ArrayList();
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null) {
            Extension.getExtension(mainAttributes, results, listKey);
        }
        Map<String, Attributes> entries = manifest.getEntries();
        for (String key : entries.keySet()) {
            Attributes attributes = entries.get(key);
            Extension.getExtension(attributes, results, listKey);
        }
        return results.toArray(new Extension[results.size()]);
    }

    private static void getExtension(Attributes attributes, ArrayList required, Attributes.Name listKey) {
        String names = attributes.getValue(listKey);
        if (names == null) {
            return;
        }
        String[] extensions = Extension.split(names, " ");
        int i = 0;
        while (i < extensions.length) {
            String prefix = String.valueOf(extensions[i]) + "-";
            Extension extension = Extension.getExtension(prefix, attributes);
            if (extension != null) {
                required.add(extension);
            }
            ++i;
        }
    }

    private static String[] split(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    private static Extension getExtension(String prefix, Attributes attributes) {
        String nameKey = String.valueOf(prefix) + EXTENSION_NAME;
        String name = Extension.getTrimmedString(attributes.getValue(nameKey));
        if (name == null) {
            return null;
        }
        String specVendorKey = String.valueOf(prefix) + SPECIFICATION_VENDOR;
        String specVendor = Extension.getTrimmedString(attributes.getValue(specVendorKey));
        String specVersionKey = String.valueOf(prefix) + SPECIFICATION_VERSION;
        String specVersion = Extension.getTrimmedString(attributes.getValue(specVersionKey));
        String impVersionKey = String.valueOf(prefix) + IMPLEMENTATION_VERSION;
        String impVersion = Extension.getTrimmedString(attributes.getValue(impVersionKey));
        String impVendorKey = String.valueOf(prefix) + IMPLEMENTATION_VENDOR;
        String impVendor = Extension.getTrimmedString(attributes.getValue(impVendorKey));
        String impVendorIDKey = String.valueOf(prefix) + IMPLEMENTATION_VENDOR_ID;
        String impVendorId = Extension.getTrimmedString(attributes.getValue(impVendorIDKey));
        String impURLKey = String.valueOf(prefix) + IMPLEMENTATION_URL;
        String impURL = Extension.getTrimmedString(attributes.getValue(impURLKey));
        return new Extension(name, specVersion, specVendor, impVersion, impVendor, impVendorId, impURL);
    }

    private static String getTrimmedString(String value) {
        return value == null ? null : value.trim();
    }
}

