/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.net.util.NetConstants;

@Deprecated
public class Base64 {
    static final int CHUNK_SIZE = 76;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte PAD = 61;
    private static final byte[] DECODE_TABLE;
    private final int lineLength;
    private final byte[] lineSeparator;
    private final boolean urlSafe;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = 62;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = 63;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        DECODE_TABLE = byArray;
    }

    private static boolean containsBase64Byte(byte[] arrayOctet) {
        byte[] byArray = arrayOctet;
        int n = arrayOctet.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            if (Base64.isBase64(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static byte[] decodeBase64(byte[] base64) {
        return Base64.isEmpty(base64) ? base64 : Base64.getDecoder().decode(base64);
    }

    public static byte[] decodeBase64(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static BigInteger decodeInteger(byte[] source) {
        return new BigInteger(1, Base64.decodeBase64(source));
    }

    private static byte[] encode(byte[] binaryData, int lineLength, byte[] lineSeparator, boolean urlSafe) {
        if (Base64.isEmpty(binaryData)) {
            return binaryData;
        }
        return lineLength > 0 ? Base64.encodeBase64Chunked(binaryData, lineLength, lineSeparator) : (urlSafe ? Base64.encodeBase64URLSafe(binaryData) : Base64.encodeBase64(binaryData));
    }

    public static byte[] encodeBase64(byte[] source) {
        return Base64.isEmpty(source) ? source : Base64.getEncoder().encode(source);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean chunked) {
        return chunked ? Base64.encodeBase64Chunked(binaryData) : Base64.encodeBase64(binaryData, false, false);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean chunked, boolean urlSafe) {
        return Base64.encodeBase64(binaryData, chunked, urlSafe, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean chunked, boolean urlSafe, int maxResultSize) {
        if (Base64.isEmpty(binaryData)) {
            return binaryData;
        }
        long len = Base64.getEncodeLength(binaryData, chunked ? 76 : 0, chunked ? CHUNK_SEPARATOR : NetConstants.EMPTY_BTYE_ARRAY);
        if (len > (long)maxResultSize) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + len + ") than the specified maxium size of " + maxResultSize);
        }
        return chunked ? Base64.encodeBase64Chunked(binaryData) : (urlSafe ? Base64.encodeBase64URLSafe(binaryData) : Base64.encodeBase64(binaryData));
    }

    public static byte[] encodeBase64Chunked(byte[] binaryData) {
        return Base64.encodeBase64Chunked(binaryData, 76, CHUNK_SEPARATOR);
    }

    private static byte[] encodeBase64Chunked(byte[] binaryData, int lineLength, byte[] lineSeparator) {
        long encodeLength = Base64.getEncodeLength(binaryData, lineLength, lineSeparator);
        byte[] dst = new byte[Math.toIntExact(encodeLength)];
        Base64.getMimeEncoder(lineLength, lineSeparator).encode(binaryData, dst);
        System.arraycopy(lineSeparator, 0, dst, dst.length - lineSeparator.length, lineSeparator.length);
        return dst;
    }

    public static String encodeBase64String(byte[] binaryData) {
        return String.valueOf(Base64.getMimeEncoder().encodeToString(binaryData)) + "\r\n";
    }

    public static String encodeBase64String(byte[] binaryData, boolean chunked) {
        return Base64.newStringUtf8(Base64.encodeBase64(binaryData, chunked));
    }

    public static String encodeBase64StringUnChunked(byte[] binaryData) {
        return Base64.getEncoder().encodeToString(binaryData);
    }

    public static byte[] encodeBase64URLSafe(byte[] binaryData) {
        return Base64.getUrlEncoder().withoutPadding().encode(binaryData);
    }

    public static String encodeBase64URLSafeString(byte[] binaryData) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(binaryData);
    }

    public static byte[] encodeInteger(BigInteger bigInt) {
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInt), false);
    }

    private static Base64.Decoder getDecoder() {
        return java.util.Base64.getDecoder();
    }

    static long getEncodeLength(byte[] array, int lineSize, byte[] linkSeparator) {
        lineSize = lineSize / 4 * 4;
        long len = array.length * 4 / 3;
        long mod = len % 4L;
        if (mod != 0L) {
            len += 4L - mod;
        }
        if (lineSize > 0) {
            boolean lenChunksPerfectly = len % (long)lineSize == 0L;
            len += len / (long)lineSize * (long)linkSeparator.length;
            if (!lenChunksPerfectly) {
                len += (long)linkSeparator.length;
            }
        }
        return len;
    }

    private static Base64.Encoder getEncoder() {
        return java.util.Base64.getEncoder();
    }

    private static Base64.Encoder getMimeEncoder() {
        return java.util.Base64.getMimeEncoder();
    }

    private static Base64.Encoder getMimeEncoder(int lineLength, byte[] lineSeparator) {
        return java.util.Base64.getMimeEncoder(lineLength, lineSeparator);
    }

    private static Base64.Encoder getUrlEncoder() {
        return java.util.Base64.getUrlEncoder();
    }

    public static boolean isArrayByteBase64(byte[] arrayOctet) {
        byte[] byArray = arrayOctet;
        int n = arrayOctet.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            if (!Base64.isBase64(element) && !Base64.isWhiteSpace(element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isBase64(byte octet) {
        return octet == 61 || octet >= 0 && octet < DECODE_TABLE.length && DECODE_TABLE[octet] != -1;
    }

    private static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static String newStringUtf8(byte[] encode) {
        return new String(encode, StandardCharsets.UTF_8);
    }

    private static byte[] toIntegerBytes(BigInteger bigInt) {
        Objects.requireNonNull(bigInt, "bigInt");
        int bitlen = bigInt.bitLength();
        bitlen = bitlen + 7 >> 3 << 3;
        byte[] bigBytes = bigInt.toByteArray();
        if (bigInt.bitLength() % 8 != 0 && bigInt.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int len = bigBytes.length;
        if (bigInt.bitLength() % 8 == 0) {
            startSrc = 1;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
        return resizedBytes;
    }

    public Base64() {
        this(false);
    }

    public Base64(boolean urlSafe) {
        this(76, CHUNK_SEPARATOR, urlSafe);
    }

    public Base64(int lineLength) {
        this(lineLength, CHUNK_SEPARATOR);
    }

    public Base64(int lineLength, byte[] lineSeparator) {
        this(lineLength, lineSeparator, false);
    }

    public Base64(int lineLength, byte[] lineSeparator, boolean urlSafe) {
        if (lineSeparator == null || urlSafe) {
            lineLength = 0;
            lineSeparator = NetConstants.EMPTY_BTYE_ARRAY;
        }
        this.lineLength = lineLength > 0 ? lineLength / 4 * 4 : 0;
        this.lineSeparator = new byte[lineSeparator.length];
        System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, lineSeparator.length);
        if (Base64.containsBase64Byte(lineSeparator)) {
            String sep = Base64.newStringUtf8(lineSeparator);
            throw new IllegalArgumentException("lineSeperator must not contain base64 characters: [" + sep + "]");
        }
        this.urlSafe = urlSafe;
    }

    public byte[] decode(byte[] source) {
        return Base64.isEmpty(source) ? source : Base64.getDecoder().decode(source);
    }

    public byte[] decode(String source) {
        return Base64.getDecoder().decode(source);
    }

    public byte[] encode(byte[] source) {
        return Base64.encode(source, this.lineLength, this.lineSeparator, this.isUrlSafe());
    }

    public String encodeToString(byte[] source) {
        return Base64.newStringUtf8(this.encode(source));
    }

    int getLineLength() {
        return this.lineLength;
    }

    byte[] getLineSeparator() {
        return (byte[])this.lineSeparator.clone();
    }

    public boolean isUrlSafe() {
        return this.urlSafe;
    }
}

