/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Visitor;

public final class ConstantModule
extends Constant
implements ConstantObject {
    private int name_index;

    public ConstantModule(ConstantModule c) {
        this(c.getNameIndex());
    }

    ConstantModule(DataInput file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantModule(int name_index) {
        super((byte)19);
        this.name_index = name_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantModule(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.name_index);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        Constant c = cp.getConstant(this.name_index, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public String getBytes(ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(name_index = " + this.name_index + ")";
    }
}

