/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.server;

import java.net.Socket;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.runtime.BcRuntimeContext;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.rmi.agent.RmiAgent;
import jp.co.extreme.rmi.connector.RmiObjectStreamConnector;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.server.RmiAgentEventHandler;
import jp.co.extreme.rmi.server.RmiRemoteAgent;
import jp.co.extreme.rmi.server.RmiServer;
import jp.co.extreme.scf.server.ScfAbstractServerModule;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf4.dao.ScfConnectionDAO;
import jp.co.extreme.scf4.model.ScfConnection;
import jp.co.extreme.scf4.server.ScfRmiRedirctor;

public class Scf4ServerModule
extends ScfAbstractServerModule {
    RmiAgentEventHandlerImpl rmiAgentEventHandler = new RmiAgentEventHandlerImpl();

    @Override
    public void init() throws Exception {
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            RmiServer rmiServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
            rmiServer.addAgentEventHandler(this.rmiAgentEventHandler);
            ScfRmiRedirctor rmiRedirctor = new ScfRmiRedirctor();
            rmiServer.setRedirector(rmiRedirctor);
        }
    }

    @Override
    public void start() throws Exception {
        RmiServer rmiServer;
        BcAddressPort adressPort;
        if (ScfServerContainer.getInstance().rmiServerModule != null && (adressPort = (rmiServer = ScfServerContainer.getInstance().rmiServerModule.getServer()).getAddressPort()) != null) {
            DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
            DtsSession dtsSession = sessionFactory.createSession(this);
            try {
                ScfConnectionDAO.getInstance().deleteByLocalAddressPort(dtsSession, adressPort.address, adressPort.port);
            }
            finally {
                if (dtsSession != null) {
                    dtsSession.desturuct();
                }
            }
        }
    }

    @Override
    public void end() throws Exception {
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            ScfServerContainer.getInstance().rmiServerModule.getServer().removeAgentEventHandler(this.rmiAgentEventHandler);
        }
    }

    public void copyToClientConnection(BcRuntimeContext runtimeContext, ScfConnection scfConnection) {
        scfConnection.javaVersion = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.java_version.value);
        scfConnection.osName = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_name.value);
        scfConnection.osVersion = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_version.value);
        scfConnection.osArch = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.os_arch.value);
        scfConnection.userName = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.user_name.value);
        scfConnection.userDir = runtimeContext.getSystemProperties().getProperty(BcJavaConstants.SysKey.user_dir.value);
    }

    class RmiAgentEventHandlerImpl
    implements RmiAgentEventHandler {
        RmiAgentEventHandlerImpl() {
        }

        @Override
        public void agentAdded(RmiAgent rmixAgent) throws Exception {
        }

        @Override
        public void agentRemoved(RmiAgent rmixAgent) throws Exception {
            DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
            DtsSession dtsSession = sessionFactory.createSession(this);
            try {
                ScfConnection rmixConnection = ScfConnectionDAO.getInstance().getRmiConnectionByAgentHashCode(dtsSession, rmixAgent.hashCode());
                rmixConnection.disconnectDatetime = BcTimeUtil.createCalendar();
                ScfConnectionDAO.getInstance().putEntity(dtsSession, rmixConnection);
                dtsSession.commit();
            }
            finally {
                dtsSession.desturuct();
            }
        }

        @Override
        public void firstStatusChecked(RmiAgent rmixAgent) throws Exception {
            RmiRemoteAgent rmiRemoteAgent = (RmiRemoteAgent)rmixAgent;
            ScfConnection rmixConnection = new ScfConnection();
            rmixConnection.acceptDatetime = BcTimeUtil.toCalendar(rmiRemoteAgent.getContext().acceptDatetime);
            rmixConnection.agentHashCode = rmixAgent.hashCode();
            RmiObjectStreamConnector rmixConnector = (RmiObjectStreamConnector)rmiRemoteAgent.getConnector();
            Socket socket = rmixConnector.getSocket();
            rmixConnection.localHostAddress = socket.getLocalAddress().getHostAddress();
            rmixConnection.localHostName = socket.getLocalAddress().getHostName();
            rmixConnection.localPort = socket.getLocalPort();
            BcAddressPort remoteAddressPort = BcNetUtil.parseAddressPort(socket.getRemoteSocketAddress().toString());
            rmixConnection.remoteHostAddress = remoteAddressPort.address;
            rmixConnection.remotePort = remoteAddressPort.port;
            BcRuntimeContext runtimeContext = rmiRemoteAgent.getContext().getRuntimeContext();
            Scf4ServerModule.this.copyToClientConnection(runtimeContext, rmixConnection);
            DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
            DtsSession dtsSession = sessionFactory.createSession(this);
            try {
                ScfConnectionDAO.getInstance().putEntity(dtsSession, rmixConnection);
                dtsSession.commit();
            }
            finally {
                dtsSession.desturuct();
            }
        }

        @Override
        public void invokeException(RmiRmoArgument rmixArg, Throwable throwable) throws Exception {
        }
    }
}

