/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsConnectionManagerImpl;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.datasource.util.ScfMmdServerUtil;
import jp.co.extreme.module.mmdx.server.MmdxServerModule;
import jp.co.extreme.module.xdts.server.XdtsServerModule;
import jp.co.extreme.module.xsod.common.XsodWords;
import jp.co.extreme.scf.datasource.ScfDatasourceConfigParser;
import jp.co.extreme.scf.server.ScfAbstractServerModule;
import jp.co.extreme.scf.server.ScfServerModule;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext_H2;

public class XsodServerModule
extends ScfAbstractServerModule {
    String[] classNames = new String[]{XdtsServerModule.class.getName(), MmdxServerModule.class.getName()};
    List<ScfServerModule> serverModuleList = new ArrayList<ScfServerModule>();

    @Override
    public void init() throws Exception {
        this.setupDatasource();
        int i = 0;
        while (i < this.classNames.length) {
            String className = this.classNames[i];
            Class<?> clazz = Class.forName(className);
            ScfServerModule serverModule = (ScfServerModule)BcReflectUtil.getInstance(clazz);
            this.serverModuleList.add(serverModule);
            serverModule.init();
            ++i;
        }
        this.wordsSetting();
    }

    @Override
    public void start() throws Exception {
        int i = 0;
        while (i < this.serverModuleList.size()) {
            ScfServerModule serverModule = this.serverModuleList.get(i);
            serverModule.start();
            ++i;
        }
    }

    @Override
    public void end() throws Exception {
        int i = 0;
        while (i < this.serverModuleList.size()) {
            ScfServerModule serverModule = this.serverModuleList.get(i);
            serverModule.end();
            ++i;
        }
    }

    protected void setupDatasource() throws Exception {
        String dbPath = AfbApplication.getInstance().toReal("${APP}data/main");
        String driverClassName = "org.h2.Driver";
        String dbUrl = SqlContext_H2.cretaeUrlFile(dbPath);
        BcLogUtil.debug("dbUrl=" + dbUrl);
        Properties sqlConnProps = new Properties();
        sqlConnProps.setProperty(SqlConstants.DataSourceProperty.user.name(), "xsys_admin");
        sqlConnProps.setProperty(SqlConstants.DataSourceProperty.password.name(), "ex4rhk8x");
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        ((DtsConnectionManager)connectionManager).setup(SqlUtil.createDriver(driverClassName), dbUrl, sqlConnProps);
        DtsSessionFactory dtsSessionFactory = new DtsSessionFactory("main", connectionManager);
        ScfDatasourceConfigParser.setupLogger(dtsSessionFactory, AfbApplication.getInstance().getLogDir());
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(dtsSessionFactory);
    }

    protected void wordsSetting() throws Exception {
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.id", 8, XsodWords.getInstance().\u5546\u54c1ID.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.code", 12, XsodWords.getInstance().\u5546\u54c1\u30b3\u30fc\u30c9.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.name_01", 40, XsodWords.getInstance().\u54c1\u540d.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.unit_amount", 10, XsodWords.getInstance().\u5358\u4fa1.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.description_01", 20, XsodWords.getInstance().\u8aac\u660e.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.description_02", 20, XsodWords.getInstance().\u8aac\u660e.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_merchandise.image_file_name", 40, XsodWords.getInstance().\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u540d.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_sales.id", 8, XsodWords.getInstance().\u58f2\u4e0aID.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_sales.amount", 8, XsodWords.getInstance().\u58f2\u4e0a\u91d1\u984d\u7a0e\u629c.toHtml());
        ScfMmdServerUtil.addColumnNameAndModel("xsod_sales.tax", 8, XsodWords.getInstance().\u6d88\u8cbb\u7a0e.toHtml());
    }
}

