/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XfilUriEntityDAO
extends OrmAbstractDAO<XfilUriEntity> {
    private static Map<String, XfilUriEntityDAO> instanceMap = new HashMap<String, XfilUriEntityDAO>();

    private XfilUriEntityDAO() {
        super(new XfilUriEntity[0]);
    }

    public static XfilUriEntityDAO getInstance(String tableName) {
        XfilUriEntityDAO instance = instanceMap.get(tableName);
        if (instance == null) {
            instance = new XfilUriEntityDAO();
            instance.setTableName(tableName);
            instanceMap.put(tableName, instance);
        }
        return instance;
    }

    @Override
    public int putEntity(DtsSession dtsSession, int userId, XfilUriEntity entity1) throws Exception {
        XfilUriEntity entity2 = (XfilUriEntity)this.getById(dtsSession, entity1.id);
        if (entity2 != null) {
            long millis;
            if (entity1.updateTimestamp == null) {
                entity1.updateTimestamp = BcTimeUtil.createCalendar();
            }
            if (entity2.updateTimestamp == null) {
                entity2.updateTimestamp = entity1.updateTimestamp;
            }
            if ((millis = entity2.updateTimestamp.getTimeInMillis() - entity1.updateTimestamp.getTimeInMillis()) > 0L) {
                String msg = "millis=" + millis;
                throw new Exception(msg);
            }
        }
        if (entity1.addTimestamp == null) {
            entity1.addTimestamp = BcTimeUtil.createCalendar();
        }
        entity1.updateTimestamp = BcTimeUtil.createCalendar();
        return super.putEntity(dtsSession, userId, entity1);
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, Mode mode, String alias, long entityId, long indexGroupId, long crawlId, String drive, String directory, String name, Short status, int rowLimit, boolean isFuzzy, long ... exceptEntityIds) throws Exception {
        String formula;
        ArrayList<String> conditionValueList;
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (entityId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".id = " + entityId);
            selectQuery.addWhereElement(whereElement);
        }
        if (indexGroupId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".index_group_id = " + indexGroupId);
            selectQuery.addWhereElement(whereElement);
        }
        if (crawlId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".crawl_id = " + crawlId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(drive)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                conditionValueList = new ArrayList<String>();
                conditionValueList.add(drive);
                formula = sqlContext.createPatternMatchClause("drive", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula(String.valueOf(alias) + ".drive" + sqlContext.toCondition_string("=", drive));
            }
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(directory)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                conditionValueList = new ArrayList();
                conditionValueList.add(directory);
                formula = sqlContext.createPatternMatchClause("directory_", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula(String.valueOf(alias) + ".directory_" + sqlContext.toCondition_string("=", directory));
            }
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(name)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                conditionValueList = new ArrayList();
                conditionValueList.add(name);
                formula = sqlContext.createPatternMatchClause(String.valueOf(alias) + ".name_", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula(String.valueOf(alias) + ".name_" + sqlContext.toCondition_string("=", name));
            }
            selectQuery.addWhereElement(whereElement);
        }
        if (mode == Mode.missing) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".missing_timestamp" + " Is Not Null");
            selectQuery.addWhereElement(whereElement);
        } else if (mode == Mode.createThumbnail) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".missing_timestamp" + " Is Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".thumbnail_timestamp" + " Is Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".text_02" + " Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (mode == Mode.tag) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".tag" + " Is Null");
            selectQuery.addWhereElement(whereElement);
        }
        if (status != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".missing_timestamp" + " Is Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".short_01 = " + status);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcCollectionUtil.isEmpty(exceptEntityIds)) {
            List<Object> list = BcCollectionUtil.toList(exceptEntityIds);
            SqlWhereElement whereElement2 = new SqlWhereElement();
            whereElement2.setLogical_AND();
            whereElement2.setFormula(String.valueOf(alias) + ".id" + " NOT IN (" + BcCsvUtil.toCsv(list) + ")");
            selectQuery.addWhereElement(whereElement2);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == Mode.name) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "name_");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "directory_");
        } else {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        }
        selectQuery.rowLimit = rowLimit;
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long entityId, long indexGroupId, long crawlId, String drive, String directory, String name, Short status, int rowLimit, boolean isFuzzy, long ... exceptEntityIds) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "uri";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, entityId, indexGroupId, crawlId, drive, directory, name, status, rowLimit, isFuzzy, exceptEntityIds);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> List<T> getListByLimit(DtsSession dtsSession, int rowLimit) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "uri";
        long entityId = -1L;
        long indexGroupId = -1L;
        long crawlId = -1L;
        String drive = null;
        String directory = null;
        String name = null;
        Short status = null;
        boolean isFuzzy = false;
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, Mode.id, alias, entityId, indexGroupId, crawlId, drive, directory, name, status, rowLimit, isFuzzy, new long[0]);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long entityId) throws Exception {
        if (entityId <= 0L) {
            return null;
        }
        long indexGroupId = -1L;
        long crawlId = -1L;
        String drive = null;
        String directory = null;
        String fileName = null;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.id, entityId, indexGroupId, crawlId, drive, directory, fileName, status, rowLimit, isFuzzy, new long[0]);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getListByPath(DtsSession dtsSession, long indexGroupId, String directory, String fileName, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(directory) || BcStringUtil.isEmpty(fileName)) {
            throw new Exception("directory=" + directory + " fileName=" + fileName);
        }
        long entityId = -1L;
        long crawlId = -1L;
        String drive = null;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, indexGroupId, crawlId, drive, directory, fileName, status, rowLimit, isFuzzy, new long[0]);
        return entityList;
    }

    public <T> T getByName(DtsSession dtsSession, long indexGroupId, String directory, String name) throws Exception {
        if (BcStringUtil.isEmpty(name)) {
            return null;
        }
        long entityId = -1L;
        long crawlId = -1L;
        String drive = null;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, indexGroupId, crawlId, drive, directory, name, status, rowLimit, isFuzzy, new long[0]);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getListByName(DtsSession dtsSession, long indexGroupId, String name, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(name)) {
            return null;
        }
        long entityId = -1L;
        long crawlId = -1L;
        String drive = null;
        String directory = null;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, indexGroupId, crawlId, drive, directory, name, status, rowLimit, isFuzzy, new long[0]);
        return entityList;
    }

    public <T> List<T> getListByDirectory(DtsSession dtsSession, long indexGroupId, String directory, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(directory)) {
            return null;
        }
        long entityId = -1L;
        long crawlId = -1L;
        String drive = null;
        String name = null;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, indexGroupId, crawlId, drive, directory, name, status, rowLimit, isFuzzy, new long[0]);
        return entityList;
    }

    public <T> T getForThumbnail(DtsSession dtsSession, long indexGroupId, long ... exceptEntityIds) throws Exception {
        long entityId = -1L;
        long crawlId = -1L;
        String drive = null;
        String directory = null;
        String name = null;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.createThumbnail, entityId, indexGroupId, crawlId, drive, directory, name, status, rowLimit, isFuzzy, exceptEntityIds);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> T getForTag(DtsSession dtsSession, long indexGroupId, long ... exceptEntityIds) throws Exception {
        long entityId = -1L;
        long crawlId = -1L;
        String drive = null;
        String directory = null;
        String name = null;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.tag, entityId, indexGroupId, crawlId, drive, directory, name, status, rowLimit, isFuzzy, exceptEntityIds);
        return BcCollectionUtil.getFirst(entityList);
    }

    public int deleteBylId(DtsSession dtsSession, long entityId) throws Exception {
        String query = "DELETE FROM " + this.getTableName() + " WHERE id = " + entityId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public int deleteByIndexGroupId(DtsSession dtsSession, long indexGroupId) throws Exception {
        String query = "DELETE FROM " + this.getTableName() + " WHERE index_group_id = " + indexGroupId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public int deleteByCrawlId(DtsSession dtsSession, long crawlId, long entityId, boolean missing) throws Exception {
        String query = "DELETE FROM " + this.getTableName() + " WHERE crawl_id = " + crawlId;
        if (entityId > 0L) {
            query = String.valueOf(query) + " AND id = " + entityId;
        }
        if (missing) {
            query = String.valueOf(query) + " AND missing_datetime Is Not NUll";
        }
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    public void check(long indexGroupId) throws Exception {
        if (indexGroupId <= 0L) {
            throw new Exception("indexGroupId=" + indexGroupId);
        }
    }

    public static enum Mode {
        id("id"),
        name("name_"),
        missing("id"),
        createThumbnail("id"),
        tag("id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }
}

