/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.server;

import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.mmdx.common.MmdxUtil;
import jp.co.extreme.module.mmdx.dao.MmdxFieldDAO;
import jp.co.extreme.module.mmdx.dao.MmdxIndexDAO;
import jp.co.extreme.module.mmdx.dao.MmdxIndexFieldDAO;
import jp.co.extreme.module.mmdx.dao.MmdxModelDAO;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.mmdx.model.MmdxIndex;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.context.SqlContext;

public class MmdxServerUtil {
    private MmdxServerUtil() {
    }

    public static MmdxServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public MmdxModel createXmmdModel(SqlConnection sqlConn, String tableName, boolean getPrimaryKey, SqlContext sqlContext) throws Exception {
        MmdModel mmdModel = sqlContext.createModelMetaData(sqlConn, tableName);
        MmdxModel mdx = MmdxUtil.toXmmdModel(mmdModel);
        return mdx;
    }

    public void putModel(BcLogger logger, DtsSession dtsSession, MmdxModel mdx) throws Exception {
        MmdxModelDAO.getInstance().putEntity(dtsSession, mdx);
        int i = 0;
        while (i < mdx.fieldList.size()) {
            MmdxField mmdxField = mdx.fieldList.get(i);
            mmdxField.schemaId = mdx.schemaId;
            mmdxField.tableName = mdx.logicalName;
            ++i;
        }
        MmdxFieldDAO.getInstance().putEntityCollection(dtsSession, mdx.fieldList);
        for (MmdxIndex mmdxIndex : mdx.indexNameMap.values()) {
            mmdxIndex.schemaId = mdx.schemaId;
        }
        MmdxIndexDAO.getInstance().putEntityCollection(dtsSession, mdx.indexNameMap.values());
        for (MmdxIndex mmdxIndex : mdx.indexNameMap.values()) {
        }
    }

    public MmdxModel getModel(DtsSession dtsSession, int schemaId, String modelName) throws Exception {
        MmdxModel mdx = MmdxModelDAO.getInstance().getByName(dtsSession, schemaId, modelName);
        List<MmdxField> filedList = MmdxFieldDAO.getInstance().getList(dtsSession, mdx.schemaId, mdx.logicalName);
        int i = 0;
        while (i < filedList.size()) {
            MmdxField mmdxField = filedList.get(i);
            mdx.addField(mmdxField);
            ++i;
        }
        List<MmdxIndex> indexList = MmdxIndexDAO.getInstance().getList(dtsSession, mdx.schemaId, mdx.logicalName);
        int i2 = 0;
        while (i2 < indexList.size()) {
            MmdxIndex mmdxIndex = indexList.get(i2);
            mdx.addIndex(mmdxIndex);
            ++i2;
        }
        return mdx;
    }

    public void deleteModel(BcLogger logger, DtsSession dtsSession, int schemaId, String modelName) throws Exception {
        List<MmdxIndex> indexList = MmdxIndexDAO.getInstance().getList(dtsSession, schemaId, modelName);
        int i = 0;
        while (i < indexList.size()) {
            MmdxIndex mmdxIndex = indexList.get(i);
            MmdxIndexFieldDAO.getInstance().deleteByIndexName(dtsSession, mmdxIndex.schemaId, mmdxIndex.indexName);
            ++i;
        }
        long cnt = MmdxIndexDAO.getInstance().deleteByModelName(dtsSession, schemaId, modelName);
        BcLogUtil.debug("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u524a\u9664\u6570=" + cnt);
        cnt = MmdxFieldDAO.getInstance().deleteByModelName(dtsSession, schemaId, modelName);
        BcLogUtil.debug("\u30d5\u30a3\u30fc\u30eb\u30c9\u524a\u9664\u6570=" + cnt);
        cnt = MmdxModelDAO.getInstance().deleteByModelName(dtsSession, modelName);
        BcLogUtil.debug("\u30e2\u30c7\u30eb\u524a\u9664\u6570=" + cnt);
    }

    /* synthetic */ MmdxServerUtil(MmdxServerUtil mmdxServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final MmdxServerUtil instance = new MmdxServerUtil(null);

        private SingletonHolder() {
        }
    }
}

