/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.datasource.util;

import java.sql.ResultSet;
import java.util.List;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.datasource.util.ScfMmdServerUtil;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;

public final class EtcSqlUtil {
    private EtcSqlUtil() {
    }

    public static BcTableModel createTableModel(ResultSet rs, EtcRsmdSupplement rsmdSupplement) throws Exception {
        BcTableModel tableModel = null;
        try {
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(rs.getMetaData());
            tableModel = SqlUtil.getAsTable(rs, tableColumnList);
            rs.close();
        }
        finally {
            rs.close();
        }
        return tableModel;
    }

    public static BcTableModel createTableModel(DtsSession dtsSession, String query, EtcRsmdSupplement rsmdSupplement) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        BcTableModel tableModel = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rs.getMetaData(), rsmdSupplement);
            tableModel = SqlUtil.getAsTable(rs, tableColumnList);
            rs.close();
        }
        return tableModel;
    }

    public static void closeSession(DtsSession dtsSession, BcLogger logger) throws Exception {
        if (dtsSession == null) {
            return;
        }
        try {
            dtsSession.close();
        }
        catch (Exception ex) {
            logger.error(logger);
        }
    }
}

