/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;

public class BcInputValidator
extends BcLoggableObject {
    public String _0_\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044 = "'{0}' \u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002";
    public String _0_\u306e\u5024_1_\u304c\u59a5\u5f53\u3067\u306f\u3042\u308a\u307e\u305b\u3093 = "'{0}' \u306e\u5024 '{1}' \u304c\u59a5\u5f53\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002";

    public static BcInputValidator getInstance() {
        return SingletonHolder.instance;
    }

    public String notReasonable(String item, String value) {
        return BcMessageCreator.getInstance().bindMessage(this._0_\u306e\u5024_1_\u304c\u59a5\u5f53\u3067\u306f\u3042\u308a\u307e\u305b\u3093, item, value);
    }

    public String $_exists(String value) {
        return String.format(BcWords.getInstance().$_exists, value);
    }

    public String $_does_not_exists(String value) {
        return String.format(BcWords.getInstance().$_does_not_exists, value);
    }

    public String $_is_running(String value) {
        return String.format(BcWords.getInstance().$_is_running, value);
    }

    public void fileRequired(String filePath, String item, Collection resultCollection, boolean isFile) {
        if (BcStringUtil.isEmpty(filePath)) {
            resultCollection.add(BcWords.getInstance().$_is_required(item));
        } else {
            File file = new File(filePath);
            if (file.exists()) {
                if (isFile) {
                    if (file.isDirectory()) {
                        resultCollection.add(BcWords.getInstance().$_is_not_$(item, BcWords.getInstance().file));
                    }
                } else if (file.isFile()) {
                    resultCollection.add(BcWords.getInstance().$_is_not_$(item, BcWords.getInstance().directory));
                }
            } else {
                resultCollection.add(this.$_does_not_exists(BcStringUtil.singleQuotation(item)));
            }
        }
    }

    public void select_$_or_more_$(String[] items, boolean[] selects, int min, Collection resultCollection) throws Exception {
        int selectCnt = 0;
        int i = 0;
        while (i < selects.length) {
            if (selects[i]) {
                ++selectCnt;
            }
            ++i;
        }
        if (selectCnt < min) {
            resultCollection.add(BcWords.getInstance().please_select_$_or_more_$(min, items));
        }
    }

    public String pleaseEnter(String itemName) {
        return BcMessageCreator.getInstance().bindMessage(this._0_\u3092\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044, itemName);
    }

    public void pleaseEnter(String itemName, BcResult result) {
        result.addError(this.pleaseEnter(itemName));
    }

    public void pleaseEnter(String itemName, String value, BcResult result) {
        if (BcStringUtil.isEmpty(value)) {
            this.pleaseEnter(itemName, result);
        }
    }

    public void notNullable(Object value, String itemName, Collection resultCollection) {
        if (!BcStringUtil.isEmpty(value)) {
            return;
        }
        String msg = this.pleaseEnter(itemName);
        resultCollection.add(msg);
    }

    public void notNullable(BcResult result, Object value, String itemName) {
        this.notNullable(value, itemName, result.getErrorList());
    }

    public void chaekDate(BcResult result, int yyyyMMdd, boolean nullable, String itemName) {
        if (yyyyMMdd <= 0 && !nullable) {
            result.addError(this.pleaseEnter(itemName));
        }
    }

    public void chaekDate(BcResult result, int yyyyMMdd, String itemName) {
        this.chaekDate(result, yyyyMMdd, false, itemName);
    }

    public void chaekDate(BcResult result, String yyyyMMddStr, boolean nullable, String itemName) {
        if (BcStringUtil.isEmpty(nullable)) {
            return;
        }
        Calendar calendar = null;
        try {
            calendar = BcTimeUtil.toCalendar(yyyyMMddStr);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        if (calendar == null) {
            result.addError("\u65e5\u4ed8\u3068\u3057\u3066\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002'" + yyyyMMddStr + "'");
            return;
        }
        int yyyyMMdd = BcTimeUtil.toYyyyMMdd(calendar);
        this.chaekDate(result, yyyyMMdd, itemName);
    }

    public void numberSeq(Number stratNum, Number endNum, String stratNumName, String endNumName, Collection resultCollection) {
        if (stratNum.doubleValue() > endNum.doubleValue()) {
            resultCollection.add(String.valueOf(stratNumName) + "\u3068" + endNumName + "\u304c\u9006\u8ee2\u3057\u3066\u3044\u307e\u3059\u3002");
        }
    }

    public void textLength(String value, int min, int max, boolean nullable, String itemName, Collection resultCollection) {
        if (BcStringUtil.isEmpty(value) && nullable) {
            return;
        }
        if (value == null) {
            value = "";
        }
        int length = value.length();
        if (min > 0 && length < min) {
            if (!BcStringUtil.isEmpty(itemName)) {
                resultCollection.add(String.valueOf(itemName) + "\u306f " + min + " \u6587\u5b57\u4ee5\u4e0a\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            } else {
                resultCollection.add("'" + value + "' \u306f " + min + " \u6587\u5b57\u4ee5\u4e0a\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            }
        }
        if (max > 0 && length > max) {
            if (!BcStringUtil.isEmpty(itemName)) {
                resultCollection.add(String.valueOf(itemName) + "\u306f " + max + " \u6587\u5b57\u4ee5\u4e0b\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            } else {
                resultCollection.add("'" + value + "' \u306f " + min + " \u6587\u5b57\u4ee5\u4e0b\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            }
        }
    }

    public void textLength(String value, int targetLength, boolean nullable, String itemName, Collection resultCollection) {
        int length;
        if (BcStringUtil.isEmpty(value) && nullable) {
            return;
        }
        if (value == null) {
            value = "";
        }
        BcLogUtil.debug("textLength:targetLength=" + targetLength + " value.length()=" + value.length());
        if (targetLength > 0 && (length = value.length()) != targetLength) {
            if (!BcStringUtil.isEmpty(itemName)) {
                resultCollection.add(String.valueOf(itemName) + "\u306f " + targetLength + " \u6587\u5b57\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            } else {
                resultCollection.add(String.valueOf(targetLength) + " \u6587\u5b57\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            }
        }
    }

    public void varidateYear(Integer year, String itemName, BcResult result) {
        if (year == null) {
            result.addError(String.valueOf(itemName) + "\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    public void varidateMonth(Integer month, String itemName, BcResult result) {
        if (month == null) {
            result.addError(String.valueOf(itemName) + "\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        } else if (month < 1 || month > 12) {
            result.addError(String.valueOf(itemName) + "\u306e\u5024 " + month + " \u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
    }

    public void varidateTerm(Integer year, Integer month, int differenceMonthMax, String itemName, BcResult result) {
        Calendar baseCal = BcTimeUtil.createCalendar();
        int monthId = month - 1;
        Calendar cal1 = BcTimeUtil.toCalendarMonthId(year, monthId, 1);
        int differenceMonth = BcTimeUtil.differenceMonth(baseCal, cal1);
        if (Math.abs(differenceMonth) >= differenceMonthMax) {
            String msg = String.valueOf(itemName) + "\u304c\u672c\u65e5\u3092\u57fa\u6e96\u306b\u524d\u5f8c " + differenceMonthMax + " \u30f6\u6708\u3092\u8d85\u904e\u3057\u3066\u307e\u3059\u3002";
            result.addWarn(msg);
        }
    }

    public boolean isFileExists(String filePath, String name, Collection resultCollection) {
        if (BcStringUtil.isEmpty(filePath)) {
            resultCollection.add("\u30d1\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            resultCollection.add(this.$_does_not_exists(BcStringUtil.singleQuotation(filePath)));
            return false;
        }
        return true;
    }

    private static final class SingletonHolder {
        private static final BcInputValidator instance = new BcInputValidator();

        private SingletonHolder() {
        }
    }
}

