/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.base.net.BcURI;
import jp.co.extreme.base.net.BcURLStreamHandler;
import jp.co.extreme.base.net.BcURLStreamHandlerFactory;

public class BcNetUtil {
    public static final String localhost = "localhost";
    public static final String DOUBLE_SLASH = String.valueOf(BcStringUtil.SLASH_STR) + BcStringUtil.SLASH_STR;
    public static final String PROTOCOL_suffix = String.valueOf(BcStringUtil.COLON_STR) + BcStringUtil.SLASH_STR;
    public static final String DEL_PROTOCOL_file = String.valueOf(Protocol.file.name()) + BcStringUtil.COLON_STR + BcStringUtil.SLASH_STR;
    protected static final int MODE_auth = 1;
    protected static final int MODE_port = 2;
    protected static final int MODE_path = 3;
    protected static final int MODE_query = 4;
    protected static final int MODE_fragment = 5;
    private static boolean protocolInternalFlag;

    private BcNetUtil() {
    }

    public static boolean isFile(URI uri) throws Exception {
        return Protocol.file.name().equalsIgnoreCase(uri.getScheme());
    }

    public static boolean isFile(URL url) throws Exception {
        return BcNetUtil.isFile(url.toURI());
    }

    public static boolean isHttp(URI uri) throws Exception {
        return Protocol.http.name().equalsIgnoreCase(uri.getScheme());
    }

    public static boolean isHttp(URL url) throws Exception {
        return BcNetUtil.isHttp(url.toURI());
    }

    public static boolean isHttps(URI uri) throws Exception {
        return Protocol.https.name().equalsIgnoreCase(uri.getScheme());
    }

    public static boolean isHttps(URL url) throws Exception {
        return BcNetUtil.isHttps(url.toURI());
    }

    public static boolean isFtp(URI uri) throws Exception {
        return Protocol.ftp.name().equalsIgnoreCase(uri.getScheme());
    }

    public static boolean isFtp(URL url) throws Exception {
        return BcNetUtil.isFtp(url.toURI());
    }

    public static Path uriToPath(String uriStr) throws Exception {
        if (uriStr.toLowerCase().startsWith(DEL_PROTOCOL_file.toLowerCase())) {
            uriStr = uriStr.substring(DEL_PROTOCOL_file.length());
        }
        Path path = Paths.get(uriStr, new String[0]);
        return path;
    }

    public static Path urlToPath(URI uri) throws Exception {
        return BcNetUtil.uriToPath(uri.toString());
    }

    public static String getHostUrl(URL url) {
        StringBuilder sb = new StringBuilder();
        sb.append(url.getProtocol());
        sb.append(PROTOCOL_suffix);
        sb.append('/');
        sb.append(url.getHost());
        sb.append('/');
        return sb.toString();
    }

    public static String getHostUrl(String url) throws Exception {
        return BcNetUtil.getHostUrl(new URL(url));
    }

    public static String getFileName(URI uri) throws Exception {
        String fileName = null;
        if (BcNetUtil.isFile(uri)) {
            Path path = BcNetUtil.urlToPath(uri);
            fileName = path.getFileName().toString();
        } else {
            Path path = Paths.get(uri.getPath(), new String[0]);
            fileName = path.getFileName().toString();
        }
        return fileName;
    }

    public static void parseUri(String src, BcURI uri) throws Exception {
        int pos1 = 0;
        int pos2 = 0;
        pos2 = src.indexOf(58, pos1);
        if (pos2 >= 0) {
            uri.scheme = src.substring(pos1, pos2);
            pos1 = pos2 + 1;
        }
        if ((pos2 = src.indexOf(DOUBLE_SLASH, pos1)) >= 0) {
            BcNetUtil.parseUri(src.substring(pos2 + 2), 1, uri);
        } else {
            BcNetUtil.parseUri(src.substring(pos1), 3, uri);
        }
    }

    public static BcURI parseUri(String src) throws Exception {
        BcURI uri = new BcURI();
        BcNetUtil.parseUri(src, uri);
        return uri;
    }

    protected static void parseUri(String src, int stratMode, BcURI uri) throws Exception {
        int pos = -1;
        char curChar = '\u0000';
        char preChar = '\u0000';
        int mode = stratMode;
        StringBuilder sb = new StringBuilder();
        while (++pos < src.length()) {
            preChar = curChar;
            curChar = src.charAt(pos);
            switch (mode) {
                case 1: {
                    switch (curChar) {
                        case ':': {
                            if (sb.length() > 0) {
                                uri.authority = sb.toString();
                            }
                            sb.delete(0, sb.length());
                            mode = 2;
                            break;
                        }
                        case '/': {
                            if (sb.length() > 0) {
                                uri.authority = sb.toString();
                            }
                            sb.delete(0, sb.length());
                            mode = 3;
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (curChar) {
                        case '/': {
                            if (sb.length() > 0) {
                                uri.port = Integer.parseInt(sb.toString());
                            }
                            sb.delete(0, sb.length());
                            mode = 3;
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (curChar) {
                        case '?': {
                            if (sb.length() > 0) {
                                uri.path = sb.toString();
                            }
                            sb.delete(0, sb.length());
                            mode = 4;
                            break;
                        }
                        case '#': {
                            if (sb.length() > 0) {
                                uri.path = sb.toString();
                            }
                            sb.delete(0, sb.length());
                            mode = 5;
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (curChar) {
                        case '#': {
                            if (sb.length() > 0) {
                                uri.query = sb.toString();
                            }
                            sb.delete(0, sb.length());
                            mode = 5;
                            break;
                        }
                        default: {
                            sb.append(curChar);
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    sb.append(curChar);
                }
            }
        }
        if (sb.length() > 0) {
            switch (mode) {
                case 1: {
                    uri.authority = sb.toString();
                    break;
                }
                case 2: {
                    uri.port = Integer.parseInt(sb.toString());
                    break;
                }
                case 3: {
                    uri.path = sb.toString();
                    break;
                }
                case 4: {
                    uri.query = sb.toString();
                    break;
                }
                case 5: {
                    uri.fragment = sb.toString();
                }
            }
        }
    }

    public static BcAddressPort parseAddressPort(String src) throws Exception {
        String src2 = null;
        int idx1 = src.indexOf(BcStringUtil.SLASH_STR);
        src2 = idx1 >= 0 ? src.substring(idx1 + 1) : src;
        int idx2 = src2.indexOf(BcStringUtil.COLON_STR);
        BcAddressPort addressPort = new BcAddressPort();
        addressPort.address = src2.substring(0, idx2);
        addressPort.port = Integer.parseInt(src2.substring(idx2 + 1));
        return addressPort;
    }

    /*
     * Unable to fully structure code
     */
    public static List<InetAddress> getLocalHostAddressList() throws Exception {
        inetAddressList = new ArrayList<InetAddress>();
        nicEnum = NetworkInterface.getNetworkInterfaces();
        if (nicEnum != null) ** GOTO lbl13
        return inetAddressList;
lbl-1000:
        // 1 sources

        {
            nic = nicEnum.nextElement();
            inetAddressesEnum = nic.getInetAddresses();
            while (inetAddressesEnum.hasMoreElements()) {
                inetAddressTmp = inetAddressesEnum.nextElement();
                if (!inetAddressTmp.isSiteLocalAddress()) continue;
                inetAddressList.add(inetAddressTmp);
            }
lbl13:
            // 2 sources

            ** while (nicEnum.hasMoreElements())
        }
lbl14:
        // 1 sources

        if (inetAddressList.size() <= 0) {
            inetAddressList.add(InetAddress.getLocalHost());
        }
        return inetAddressList;
    }

    public static synchronized boolean setupInternalProtocol() throws Exception {
        if (protocolInternalFlag) {
            return protocolInternalFlag;
        }
        try {
            BcLogUtil.info(String.format("Registering URL protocol '%s'...", Protocol.internal.name()));
            BcURLStreamHandlerFactory ulStreamHandlerFactory = BcURLStreamHandlerFactory.getInstance();
            ulStreamHandlerFactory.protocolMap.put(Protocol.internal.name(), BcURLStreamHandler.getInstance());
            URL.setURLStreamHandlerFactory(BcURLStreamHandlerFactory.getInstance());
            protocolInternalFlag = true;
        }
        catch (Error err) {
            BcLogUtil.error(err);
        }
        return protocolInternalFlag;
    }

    public static enum Protocol {
        http,
        https,
        ftp,
        file,
        gopher,
        mailto,
        news,
        nntp,
        telnet,
        prospero,
        wais,
        internal;

    }
}

