/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import sun.security.jca.JCAUtil;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.HttpTimestamper;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.TimestampToken;
import sun.security.timestamp.Timestamper;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class PKCS7 {
    private ObjectIdentifier contentType;
    private BigInteger version = null;
    private AlgorithmId[] digestAlgorithmIds = null;
    private ContentInfo contentInfo = null;
    private X509Certificate[] certificates = null;
    private X509CRL[] crls = null;
    private SignerInfo[] signerInfos = null;
    private boolean oldStyle = false;
    private Principal[] certIssuerNames;

    public PKCS7(InputStream inputStream) throws ParsingException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        this.parse(new DerInputStream(byArray));
    }

    public PKCS7(DerInputStream derInputStream) throws ParsingException {
        this.parse(derInputStream);
    }

    public PKCS7(byte[] byArray) throws ParsingException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            this.parse(derInputStream);
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Unable to parse the encoded bytes");
            parsingException.initCause(iOException);
            throw parsingException;
        }
    }

    private void parse(DerInputStream derInputStream) throws ParsingException {
        try {
            derInputStream.mark(derInputStream.available());
            this.parse(derInputStream, false);
        }
        catch (IOException iOException) {
            try {
                derInputStream.reset();
                this.parse(derInputStream, true);
                this.oldStyle = true;
            }
            catch (IOException iOException2) {
                ParsingException parsingException = new ParsingException(iOException2.getMessage());
                parsingException.initCause(iOException);
                parsingException.addSuppressed(iOException2);
                throw parsingException;
            }
        }
    }

    private void parse(DerInputStream derInputStream, boolean bl) throws IOException {
        this.contentInfo = new ContentInfo(derInputStream, bl);
        this.contentType = this.contentInfo.contentType;
        DerValue derValue = this.contentInfo.getContent();
        if (this.contentType.equals((Object)ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(derValue);
        } else if (this.contentType.equals((Object)ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(derValue);
        } else if (this.contentType.equals((Object)ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(derValue);
        } else {
            throw new ParsingException("content type " + this.contentType + " not supported.");
        }
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, X509CRL[] x509CRLArray, SignerInfo[] signerInfoArray) {
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = algorithmIdArray;
        this.contentInfo = contentInfo;
        this.certificates = x509CertificateArray;
        this.crls = x509CRLArray;
        this.signerInfos = signerInfoArray;
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, SignerInfo[] signerInfoArray) {
        this(algorithmIdArray, contentInfo, x509CertificateArray, null, signerInfoArray);
    }

    private void parseNetscapeCertChain(DerValue derValue) throws ParsingException, IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        this.certificates = new X509Certificate[derValueArray.length];
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        for (int i = 0; i < derValueArray.length; ++i) {
            try (ByteArrayInputStream byteArrayInputStream = null;){
                if (certificateFactory == null) {
                    this.certificates[i] = new X509CertImpl(derValueArray[i]);
                    continue;
                }
                byte[] byArray = derValueArray[i].toByteArray();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.certificates[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                byteArrayInputStream.close();
                byteArrayInputStream = null;
                continue;
            }
        }
    }

    private void parseSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        int n;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n2 = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                derValueArray = derValueArray2[i];
                this.digestAlgorithmIds[i] = AlgorithmId.parse((DerValue)derValueArray);
            }
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Error parsing digest AlgorithmId IDs: " + iOException.getMessage());
            parsingException.initCause(iOException);
            throw parsingException;
        }
        this.contentInfo = new ContentInfo(derInputStream);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if ((byte)derInputStream.peekByte() == -96) {
            derValueArray = derInputStream.getSet(2, true);
            n2 = derValueArray.length;
            this.certificates = new X509Certificate[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                Object object2;
                object = null;
                try {
                    byte by = derValueArray[i].getTag();
                    if (by != 48) continue;
                    if (certificateFactory == null) {
                        this.certificates[n] = new X509CertImpl(derValueArray[i]);
                    } else {
                        object2 = derValueArray[i].toByteArray();
                        object = new ByteArrayInputStream((byte[])object2);
                        this.certificates[n] = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                        ((ByteArrayInputStream)object).close();
                        object = null;
                    }
                    ++n;
                    continue;
                }
                catch (CertificateException certificateException) {
                    object2 = new ParsingException(certificateException.getMessage());
                    ((Throwable)object2).initCause(certificateException);
                    throw object2;
                }
                catch (IOException iOException) {
                    object2 = new ParsingException(iOException.getMessage());
                    ((Throwable)object2).initCause(iOException);
                    throw object2;
                }
                finally {
                    if (object != null) {
                        ((ByteArrayInputStream)object).close();
                    }
                }
            }
            if (n != n2) {
                this.certificates = Arrays.copyOf(this.certificates, n);
            }
        }
        if ((byte)derInputStream.peekByte() == -95) {
            derValueArray = derInputStream.getSet(1, true);
            n2 = derValueArray.length;
            this.crls = new X509CRL[n2];
            for (n = 0; n < n2; ++n) {
                try (ByteArrayInputStream byteArrayInputStream = null;){
                    if (certificateFactory == null) {
                        this.crls[n] = new X509CRLImpl(derValueArray[n]);
                        continue;
                    }
                    object = derValueArray[n].toByteArray();
                    byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    this.crls[n] = (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                    continue;
                }
            }
        }
        derValueArray = derInputStream.getSet(1);
        n2 = derValueArray.length;
        this.signerInfos = new SignerInfo[n2];
        for (n = 0; n < n2; ++n) {
            DerInputStream derInputStream2 = derValueArray[n].toDerInputStream();
            this.signerInfos[n] = new SignerInfo(derInputStream2);
        }
    }

    private void parseOldSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n];
        try {
            for (int i = 0; i < n; ++i) {
                derValueArray = derValueArray2[i];
                this.digestAlgorithmIds[i] = AlgorithmId.parse((DerValue)derValueArray);
            }
        }
        catch (IOException iOException) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(derInputStream, true);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        derValueArray = derInputStream.getSet(2);
        n = derValueArray.length;
        this.certificates = new X509Certificate[n];
        for (int i = 0; i < n; ++i) {
            try (ByteArrayInputStream byteArrayInputStream = null;){
                if (certificateFactory == null) {
                    this.certificates[i] = new X509CertImpl(derValueArray[i]);
                    continue;
                }
                object = derValueArray[i].toByteArray();
                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                this.certificates[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                byteArrayInputStream.close();
                byteArrayInputStream = null;
                continue;
            }
        }
        derInputStream.getSet(0);
        DerValue[] derValueArray3 = derInputStream.getSet(1);
        n = derValueArray3.length;
        this.signerInfos = new SignerInfo[n];
        for (int i = 0; i < n; ++i) {
            object = derValueArray3[i].toDerInputStream();
            this.signerInfos[i] = new SignerInfo((DerInputStream)object, true);
        }
    }

    public void encodeSignedData(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeSignedData(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void encodeSignedData(DerOutputStream derOutputStream) throws IOException {
        DerEncoder[] derEncoderArray;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        derOutputStream2.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(derOutputStream2);
        if (this.certificates != null && this.certificates.length != 0) {
            derEncoderArray = new X509CertImpl[this.certificates.length];
            for (int i = 0; i < this.certificates.length; ++i) {
                if (this.certificates[i] instanceof X509CertImpl) {
                    derEncoderArray[i] = (X509CertImpl)this.certificates[i];
                    continue;
                }
                try {
                    byte[] byArray = this.certificates[i].getEncoded();
                    derEncoderArray[i] = new X509CertImpl(byArray);
                    continue;
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException);
                }
            }
            derOutputStream2.putOrderedSetOf((byte)-96, derEncoderArray);
        }
        if (this.crls != null && this.crls.length != 0) {
            derEncoderArray = new HashSet(this.crls.length);
            for (X509CRL x509CRL : this.crls) {
                if (x509CRL instanceof X509CRLImpl) {
                    derEncoderArray.add((X509CRLImpl)x509CRL);
                    continue;
                }
                try {
                    byte[] byArray = x509CRL.getEncoded();
                    derEncoderArray.add(new X509CRLImpl(byArray));
                }
                catch (CRLException cRLException) {
                    throw new IOException(cRLException);
                }
            }
            derOutputStream2.putOrderedSetOf((byte)-95, derEncoderArray.toArray(new X509CRLImpl[derEncoderArray.size()]));
        }
        derOutputStream2.putOrderedSetOf((byte)49, this.signerInfos);
        derEncoderArray = new DerValue(48, derOutputStream2.toByteArray());
        ContentInfo contentInfo = new ContentInfo(ContentInfo.SIGNED_DATA_OID, (DerValue)derEncoderArray);
        contentInfo.encode(derOutputStream);
    }

    public SignerInfo verify(SignerInfo signerInfo, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        return signerInfo.verify(this, byArray);
    }

    public SignerInfo[] verify(byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        Vector<SignerInfo> vector = new Vector<SignerInfo>();
        for (int i = 0; i < this.signerInfos.length; ++i) {
            SignerInfo signerInfo = this.verify(this.signerInfos[i], byArray);
            if (signerInfo == null) continue;
            vector.addElement(signerInfo);
        }
        if (!vector.isEmpty()) {
            Object[] objectArray = new SignerInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])this.certificates.clone();
        }
        return null;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])this.crls.clone();
        }
        return null;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInteger bigInteger, X500Name x500Name) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            for (int i = 0; i < this.certificates.length; ++i) {
                X509Certificate x509Certificate = this.certificates[i];
                BigInteger bigInteger2 = x509Certificate.getSerialNumber();
                if (!bigInteger.equals(bigInteger2) || !x500Name.equals(this.certIssuerNames[i])) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[this.certificates.length];
        for (int i = 0; i < this.certificates.length; ++i) {
            X509Certificate x509Certificate = this.certificates[i];
            Principal principal = x509Certificate.getIssuerDN();
            if (!(principal instanceof X500Name)) {
                try {
                    X509CertInfo x509CertInfo = new X509CertInfo(x509Certificate.getTBSCertificate());
                    principal = (Principal)x509CertInfo.get("issuer.dname");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.certIssuerNames[i] = principal;
        }
    }

    public String toString() {
        int n;
        String string = "";
        string = string + this.contentInfo + "\n";
        if (this.version != null) {
            string = string + "PKCS7 :: version: " + Debug.toHexString(this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            string = string + "PKCS7 :: digest AlgorithmIds: \n";
            for (n = 0; n < this.digestAlgorithmIds.length; ++n) {
                string = string + "\t" + this.digestAlgorithmIds[n] + "\n";
            }
        }
        if (this.certificates != null) {
            string = string + "PKCS7 :: certificates: \n";
            for (n = 0; n < this.certificates.length; ++n) {
                string = string + "\t" + n + ".   " + this.certificates[n] + "\n";
            }
        }
        if (this.crls != null) {
            string = string + "PKCS7 :: crls: \n";
            for (n = 0; n < this.crls.length; ++n) {
                string = string + "\t" + n + ".   " + this.crls[n] + "\n";
            }
        }
        if (this.signerInfos != null) {
            string = string + "PKCS7 :: signer infos: \n";
            for (n = 0; n < this.signerInfos.length; ++n) {
                string = string + "\t" + n + ".  " + this.signerInfos[n] + "\n";
            }
        }
        return string;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    public static byte[] generateSignedData(byte[] byArray, X509Certificate[] x509CertificateArray, byte[] byArray2, String string, URI uRI, String string2, String string3) throws CertificateException, IOException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        PKCS9Attributes pKCS9Attributes = null;
        if (uRI != null) {
            object2 = new HttpTimestamper(uRI);
            object = PKCS7.generateTimestampToken((Timestamper)object2, string2, string3, byArray);
            pKCS9Attributes = new PKCS9Attributes(new PKCS9Attribute[]{new PKCS9Attribute(PKCS9Attribute.SIGNATURE_TIMESTAMP_TOKEN_OID, object)});
        }
        object2 = X500Name.asX500Name(x509CertificateArray[0].getIssuerX500Principal());
        object = x509CertificateArray[0].getSerialNumber();
        String string4 = AlgorithmId.getEncAlgFromSigAlg(string);
        String string5 = AlgorithmId.getDigAlgFromSigAlg(string);
        SignerInfo signerInfo = new SignerInfo((X500Name)object2, (BigInteger)object, AlgorithmId.get(string5), null, AlgorithmId.get(string4), byArray, pKCS9Attributes);
        SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
        AlgorithmId[] algorithmIdArray = new AlgorithmId[]{signerInfo.getDigestAlgorithmId()};
        ContentInfo contentInfo = byArray2 == null ? new ContentInfo(ContentInfo.DATA_OID, null) : new ContentInfo(byArray2);
        PKCS7 pKCS7 = new PKCS7(algorithmIdArray, contentInfo, x509CertificateArray, signerInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        pKCS7.encodeSignedData(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] generateTimestampToken(Timestamper timestamper, String string, String string2, byte[] byArray) throws IOException, CertificateException {
        MessageDigest messageDigest = null;
        TSRequest tSRequest = null;
        try {
            messageDigest = MessageDigest.getInstance(string2);
            tSRequest = new TSRequest(string, byArray, messageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
        BigInteger bigInteger = new BigInteger(64, JCAUtil.getDefSecureRandom());
        tSRequest.setNonce(bigInteger);
        tSRequest.requestCertificate(true);
        TSResponse tSResponse = timestamper.generateTimestamp(tSRequest);
        int n = tSResponse.getStatusCode();
        if (n != 0 && n != 1) {
            throw new IOException("Error generating timestamp: " + tSResponse.getStatusCodeAsText() + " " + tSResponse.getFailureCodeAsText());
        }
        if (string != null && !string.equals(tSResponse.getTimestampToken().getPolicyID())) {
            throw new IOException("TSAPolicyID changed in timestamp token");
        }
        PKCS7 pKCS7 = tSResponse.getToken();
        TimestampToken timestampToken = tSResponse.getTimestampToken();
        try {
            if (!timestampToken.getHashAlgorithm().equals(AlgorithmId.get(string2))) {
                throw new IOException("Digest algorithm not " + string2 + " in timestamp token");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException();
        }
        if (!MessageDigest.isEqual(timestampToken.getHashedMessage(), tSRequest.getHashedMessage())) {
            throw new IOException("Digest octets changed in timestamp token");
        }
        BigInteger bigInteger2 = timestampToken.getNonce();
        if (bigInteger2 == null && bigInteger != null) {
            throw new IOException("Nonce missing in timestamp token");
        }
        if (bigInteger2 != null && !bigInteger2.equals(bigInteger)) {
            throw new IOException("Nonce changed in timestamp token");
        }
        for (SignerInfo signerInfo : pKCS7.getSignerInfos()) {
            X509Certificate x509Certificate = signerInfo.getCertificate(pKCS7);
            if (x509Certificate == null) {
                throw new CertificateException("Certificate not included in timestamp token");
            }
            if (!x509Certificate.getCriticalExtensionOIDs().contains(KnownOIDs.extendedKeyUsage.value())) {
                throw new CertificateException("Certificate is not valid for timestamping");
            }
            List<String> list = x509Certificate.getExtendedKeyUsage();
            if (list != null && list.contains(KnownOIDs.KP_TimeStamping.value())) continue;
            throw new CertificateException("Certificate is not valid for timestamping");
        }
        return tSResponse.getEncodedToken();
    }
}

