/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.util.NoSuchElementException;

class QuadIterator
implements PathIterator {
    QuadCurve2D quad;
    AffineTransform affine;
    int index;

    QuadIterator(QuadCurve2D quadCurve2D, AffineTransform affineTransform) {
        this.quad = quadCurve2D;
        this.affine = affineTransform;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(float[] fArray) {
        int n;
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        if (this.index == 0) {
            fArray[0] = (float)this.quad.getX1();
            fArray[1] = (float)this.quad.getY1();
            n = 0;
        } else {
            fArray[0] = (float)this.quad.getCtrlX();
            fArray[1] = (float)this.quad.getCtrlY();
            fArray[2] = (float)this.quad.getX2();
            fArray[3] = (float)this.quad.getY2();
            n = 2;
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, this.index == 0 ? 1 : 2);
        }
        return n;
    }

    @Override
    public int currentSegment(double[] dArray) {
        int n;
        if (this.isDone()) {
            throw new NoSuchElementException("quad iterator iterator out of bounds");
        }
        if (this.index == 0) {
            dArray[0] = this.quad.getX1();
            dArray[1] = this.quad.getY1();
            n = 0;
        } else {
            dArray[0] = this.quad.getCtrlX();
            dArray[1] = this.quad.getCtrlY();
            dArray[2] = this.quad.getX2();
            dArray[3] = this.quad.getY2();
            n = 2;
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, this.index == 0 ? 1 : 2);
        }
        return n;
    }
}

