/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sound;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.FileUtils;

public class AntSoundPlayer
implements LineListener,
BuildListener {
    private File fileSuccess = null;
    private int loopsSuccess = 0;
    private Long durationSuccess = null;
    private File fileFail = null;
    private int loopsFail = 0;
    private Long durationFail = null;

    public void addBuildSuccessfulSound(File file, int loops, Long duration) {
        this.fileSuccess = file;
        this.loopsSuccess = loops;
        this.durationSuccess = duration;
    }

    public void addBuildFailedSound(File fileFail, int loopsFail, Long durationFail) {
        this.fileFail = fileFail;
        this.loopsFail = loopsFail;
        this.durationFail = durationFail;
    }

    /*
     * Unable to fully structure code
     */
    private void play(Project project, File file, int loops, Long duration) {
        block13: {
            block12: {
                audioClip = null;
                audioInputStream = null;
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(file);
                }
                catch (UnsupportedAudioFileException uafe) {
                    project.log("Audio format is not yet supported: " + uafe.getMessage());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                if (audioInputStream == null) break block12;
                format = audioInputStream.getFormat();
                info = new DataLine.Info(Clip.class, format, -1);
                try {
                    audioClip = (Clip)AudioSystem.getLine(info);
                    audioClip.addLineListener(this);
                    audioClip.open(audioInputStream);
                    ** GOTO lbl27
                }
                catch (LineUnavailableException e) {
                    project.log("The sound device is currently unavailable");
                    FileUtils.close(audioClip);
                    return;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
lbl27:
                        // 2 sources

                        if (duration != null) {
                            this.playClip(audioClip, duration);
                        } else {
                            this.playClip(audioClip, loops);
                        }
                        if (audioClip != null) {
                            audioClip.drain();
                        }
                    }
                    catch (Throwable var10_13) {
                        FileUtils.close(audioClip);
                        throw var10_13;
                    }
                }
                FileUtils.close(audioClip);
                break block13;
            }
            project.log("Can't get data from file " + file.getName());
        }
    }

    private void playClip(Clip clip, int loops) {
        clip.loop(loops);
        do {
            try {
                long timeLeft = (clip.getMicrosecondLength() - clip.getMicrosecondPosition()) / 1000L;
                if (timeLeft <= 0L) continue;
                Thread.sleep(timeLeft);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (clip.isRunning());
        if (clip.isRunning()) {
            clip.stop();
        }
    }

    private void playClip(Clip clip, long duration) {
        clip.loop(-1);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        clip.stop();
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType().equals(LineEvent.Type.STOP)) {
            Line line = event.getLine();
            line.close();
        }
    }

    @Override
    public void buildStarted(BuildEvent event) {
    }

    @Override
    public void buildFinished(BuildEvent event) {
        if (event.getException() == null && this.fileSuccess != null) {
            this.play(event.getProject(), this.fileSuccess, this.loopsSuccess, this.durationSuccess);
        } else if (event.getException() != null && this.fileFail != null) {
            this.play(event.getProject(), this.fileFail, this.loopsFail, this.durationFail);
        }
    }

    @Override
    public void targetStarted(BuildEvent event) {
    }

    @Override
    public void targetFinished(BuildEvent event) {
    }

    @Override
    public void taskStarted(BuildEvent event) {
    }

    @Override
    public void taskFinished(BuildEvent event) {
    }

    @Override
    public void messageLogged(BuildEvent event) {
    }
}

