/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import jp.co.extreme.base.util.BcWords;

public class SwgCheckBox
extends JCheckBox {
    private static final long serialVersionUID = 1036378847703615497L;
    protected ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            SwgCheckBox.this.actionPerformed1(ev);
        }
    };
    private boolean antialias = false;

    public SwgCheckBox() {
        this.init();
    }

    public SwgCheckBox(String text) {
        super(text);
        this.init();
    }

    public SwgCheckBox(String text, ImageIcon imageIcon) {
        super(text, imageIcon);
        this.init();
    }

    public SwgCheckBox(ImageIcon imageIcon) {
        super(imageIcon);
        this.init();
    }

    protected void init() {
        this.addActionListener(this.actionListener);
    }

    public boolean getAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean flag) {
        this.antialias = flag;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.calc();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.calc();
    }

    protected void actionPerformed1(ActionEvent ev) {
        try {
            this.actionPerformed2(ev);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
        }
    }

    protected void actionPerformed2(ActionEvent ev) throws Exception {
    }

    public void calc() {
        if (this.getText() == null || this.getFont() == null) {
            return;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.antialias) {
            HashMap<RenderingHints.Key, Object> newHint = new HashMap<RenderingHints.Key, Object>();
            newHint.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            newHint.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            RenderingHints oldHint = g2.getRenderingHints();
            g2.setRenderingHints(newHint);
            super.paint(g2);
            g2.setRenderingHints(oldHint);
        } else {
            super.paint(g2);
        }
    }
}

