/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.TreePath;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.scf4.model.ScfMenuContext;
import jp.co.extreme.scf5.model.ZScfIntProperties;
import jp.co.extreme.scf5.stub.ZScfDomainPropertyStub;
import jp.co.extreme.scf5.swg.IswgAbstractPropertyEditor;
import jp.co.extreme.scf5.swg.IswgIntPropertyEditor;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgTreeView;
import jp.co.extreme.swing.SwgUtil;
import jp.co.extreme.swing.tree.BcTreeNode;
import nlc.lib.tree.LbTreeModel;

public class IswgSharePropertyPanel
extends SwgDecoratePanel {
    private static final long serialVersionUID = -4146667552250405683L;
    protected JSplitPane splitPane = new JSplitPane();
    protected JPanel cardPanel = new JPanel();
    protected CardLayout cardLayout = new CardLayout();
    protected LbTreeModel treeModel;
    protected SwgTreeView treeView;
    protected Map<String, Object> panelMap = new HashMap<String, Object>();
    protected Window window;
    public static BcTreeNode rootTreeNode = new BcTreeNode(new ScfMenuContext("\u5171\u6709\u30d7\u30ed\u30d1\u30c6\u30a3"));
    public static BcTreeNode systemTreeNode = new BcTreeNode(new ScfMenuContext("\u62e1\u5f35"));

    public IswgSharePropertyPanel() throws Exception {
        this.setBorderSize(10, 40, 0, 0);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.splitPane, "Center");
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        LbTreeModel treeModel = new LbTreeModel(rootTreeNode);
        this.treeView = new SwgTreeView(treeModel);
        this.treeView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                try {
                    IswgSharePropertyPanel.this.mousePressed2(ev);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.splitPane.add((Component)this.treeView, "left");
        this.splitPane.setDividerSize(4);
        this.splitPane.setDividerLocation(180);
        this.splitPane.add((Component)this.cardPanel, "right");
        this.cardPanel.setLayout(this.cardLayout);
    }

    protected void mousePressed2(MouseEvent ev) throws Exception {
        TreePath treePath = this.treeView.getPathForLocation(ev.getX(), ev.getY());
        if (treePath == null) {
            return;
        }
        BcTreeNode treeNode = (BcTreeNode)treePath.getLastPathComponent();
        ScfMenuContext menuContext = (ScfMenuContext)treeNode.getUserObject();
        if (menuContext == null) {
            return;
        }
        if (BcStringUtil.isEmpty(menuContext.getJavaClassName())) {
            return;
        }
        BcLogUtil.debug("menuContext.getJavaClassName()=" + menuContext.getJavaClassName());
        Object propertyEditorTmp = this.panelMap.get(menuContext.getJavaClassName());
        if (propertyEditorTmp == null) {
            Class<?> clazz = Class.forName(menuContext.getJavaClassName());
            Object classInstance = BcReflectUtil.getInstance(clazz);
            if (IswgIntPropertyEditor.class.isAssignableFrom(clazz)) {
                IswgIntPropertyEditor intPropertyEditor = (IswgIntPropertyEditor)classInstance;
                ZScfIntProperties intProps = ZScfDomainPropertyStub.getInstance().getDomainPropertiesAll();
                intPropertyEditor.setProperty(intProps);
                JPanel tmpPanel = new JPanel();
                tmpPanel.setLayout(new BorderLayout());
                tmpPanel.add(intPropertyEditor.getComponent(), "Center");
                this.cardPanel.add(menuContext.getJavaClassName(), tmpPanel);
            } else if (IswgAbstractPropertyEditor.class.isAssignableFrom(clazz)) {
                IswgAbstractPropertyEditor propertyEditor = (IswgAbstractPropertyEditor)classInstance;
                propertyEditor.componentShownFirst(null);
                JPanel tmpPanel = new JPanel();
                tmpPanel.setLayout(new BorderLayout());
                tmpPanel.add(propertyEditor.getComponent(), "Center");
                this.cardPanel.add(menuContext.getJavaClassName(), tmpPanel);
            }
            this.panelMap.put(menuContext.getJavaClassName(), classInstance);
        }
        this.cardLayout.show(this.cardPanel, menuContext.getJavaClassName());
        this.cardPanel.validate();
    }

    @Override
    protected void okButtonAction() throws Exception {
        ArrayList msgList = new ArrayList();
        Object[] propertyEditorArray = this.panelMap.values().toArray();
        int i = 0;
        while (i < propertyEditorArray.length) {
            ++i;
        }
        if (msgList.size() > 0) {
            JOptionPane.showMessageDialog(this, SwgUtil.createMessageComponent(null, msgList), BcWords.getInstance().warning, 2);
            return;
        }
        try {
            ZScfIntProperties intProps = new ZScfIntProperties();
            int i2 = 0;
            while (i2 < propertyEditorArray.length) {
                Object propertyEditorTmp = propertyEditorArray[i2];
                BcLogUtil.debug("propertyEditorTmp=" + propertyEditorTmp.getClass().getName());
                if (IswgIntPropertyEditor.class.isAssignableFrom(propertyEditorTmp.getClass())) {
                    IswgIntPropertyEditor intPropertyEditor = (IswgIntPropertyEditor)propertyEditorTmp;
                    intPropertyEditor.storeProperty(intProps);
                } else if (IswgAbstractPropertyEditor.class.isAssignableFrom(propertyEditorTmp.getClass())) {
                    IswgAbstractPropertyEditor propertyEditor = (IswgAbstractPropertyEditor)propertyEditorTmp;
                    propertyEditor.storeProperty();
                }
                ++i2;
            }
            ZScfDomainPropertyStub.getInstance().putDomainProperties(intProps);
            this.close();
            String msg = "\u8a2d\u5b9a\u3092\u6709\u52b9\u306b\u3059\u308b\u306b\u306f\u30b7\u30b9\u30c6\u30e0\u306e\u518d\u8d77\u52d5\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002";
            JOptionPane.showMessageDialog(this, msg, BcWords.getInstance().confirmation, 1);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
        }
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        super.cancelButtonAction();
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public void showAsDialog(Component ownerCompo) throws Exception {
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    IswgSharePropertyPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    IswgSharePropertyPanel.this.handleException(ex);
                }
            }
        });
        dialog.setTitle("\u5171\u6709\u30d7\u30ed\u30d1\u30c6\u30a3");
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        this.window = dialog;
        SwgUtil.setCenter(this.window, 1020.0, 640.0);
        dialog.setVisible(true);
    }
}

