/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.orm.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmSequenceDAO;
import jp.co.extreme.orm.entity.OrmAddition;
import jp.co.extreme.orm.entity.OrmDataId;
import jp.co.extreme.orm.entity.OrmGeneralData;
import jp.co.extreme.orm.persistence.OrmAbstractPersistence;
import jp.co.extreme.orm.persistence.OrmPersistenceProxy;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlPreparedStatement;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSetClause;
import jp.co.extreme.sql.model.SqlUpdateQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class OrmPersistenceAddition
extends OrmAbstractPersistence {
    boolean copyFlag = false;

    @Override
    public void setSetClause(SqlContext sqlContext, List<String> setElementList, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        setElementList.add("sy_noid=" + etdmAddition.getNoid());
        setElementList.add("sy_timestamp=" + sqlContext.toSet(etdmAddition.getAddTimestamp()));
        setElementList.add("sy_user_id=" + etdmAddition.getAddUserId());
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        updateQuery.addSetClause(new SqlSetClause("sy_noid", etdmAddition.getNoid()));
        updateQuery.addSetClause(new SqlSetClause("sy_timestamp", etdmAddition.getAddTimestamp()));
        updateQuery.addSetClause(new SqlSetClause("sy_user_id", etdmAddition.getAddUserId()));
    }

    @Override
    public void setSetClause(List<String> setColumnList, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        setColumnList.add("sy_noid");
        setColumnList.add("sy_timestamp");
        setColumnList.add("sy_user_id");
    }

    @Override
    public void setValueList(List<Object> valueList, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        valueList.add(etdmAddition.getNoid());
        valueList.add(etdmAddition.getAddTimestamp());
        valueList.add(etdmAddition.getAddUserId());
    }

    @Override
    public void getJdbcTypes(List<Integer> sqlTypeList, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        sqlTypeList.add(4);
        sqlTypeList.add(93);
        sqlTypeList.add(4);
    }

    @Override
    public void setPreStmtValue(SqlContext sqlContext, PreparedStatement preStmt, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        sqlContext.setPreStmtValue(preStmt, columnIndex, 4, (Object)etdmAddition.getNoid());
        sqlContext.setPreStmtValue(preStmt, columnIndex, 93, (Object)etdmAddition.getAddTimestamp());
        sqlContext.setPreStmtValue(preStmt, columnIndex, 4, (Object)etdmAddition.getAddUserId());
    }

    @Override
    public void setSetClause(SqlUpdateQuery updateQuery, OrmGeneralData generalData, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        int i = 0;
        while (i < generalData.getModel().getFieldCount()) {
            MmdField mmdField = generalData.getModel().getField(i);
            Object valueObject = generalData.getValue(i);
            if (mmdField.columnName.equals("sy_noid")) {
                updateQuery.addSetClause(new SqlSetClause("sy_noid", valueObject));
            } else if (mmdField.columnName.equals("sy_timestamp")) {
                updateQuery.addSetClause(new SqlSetClause("sy_timestamp", valueObject));
            } else if (mmdField.columnName.equals("sy_user_id")) {
                updateQuery.addSetClause(new SqlSetClause("sy_user_id", valueObject));
            }
            ++i;
        }
    }

    @Override
    public void getSelectColumnName(List<String> columnNameList, String tableAlias, Class entityType) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(entityType)) {
            return;
        }
        String tableAlias2 = SqlUtil.tableAliasToNotNull(tableAlias);
        columnNameList.add(String.valueOf(tableAlias2) + "sy_noid");
        columnNameList.add(String.valueOf(tableAlias2) + "sy_timestamp");
        columnNameList.add(String.valueOf(tableAlias2) + "sy_user_id");
    }

    @Override
    public void setResultSet(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, Object dataObject) throws Exception {
        if (!OrmAddition.class.isAssignableFrom(dataObject.getClass())) {
            return;
        }
        OrmAddition etdmAddition = (OrmAddition)dataObject;
        SqlContext sqlContext = dtsSession.getSqlContext();
        etdmAddition.setNoid(rs.getInt(columnIndex));
        etdmAddition.setAddTimestamp(rs.getCalendar(columnIndex));
        etdmAddition.setAddUserId(rs.getInt(columnIndex));
    }

    public boolean preTrans(DtsSession dtsSession, int userId, String tableName, Object entity) throws Exception {
        OrmDataId etdmDataId;
        long newObjectId;
        String dataName;
        SqlContext sqlContext = dtsSession.getSqlContext();
        Class<?> entityType = entity.getClass();
        OrmAddition etdmAddition = (OrmAddition)entity;
        boolean isInsert = false;
        if (etdmAddition.isAddition()) {
            dataName = MmdUtil.createTableColumnName(tableName, "sy_oid");
            newObjectId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, dataName);
            OrmPersistenceAddition.updateNextObjectId(dtsSession, tableName, etdmAddition.getObjectId(), newObjectId);
            etdmAddition.setObjectId(newObjectId);
            etdmAddition.setNoid(-1L);
            etdmAddition.setAddTimestamp(BcTimeUtil.createCalendar());
            if (userId > 0) {
                etdmAddition.setAddUserId(userId);
            }
            isInsert = true;
        } else if (etdmAddition.getObjectId() <= 0L) {
            dataName = MmdUtil.createTableColumnName(tableName, "sy_oid");
            newObjectId = OrmSequenceDAO.getInstance().generateNumber(dtsSession, dataName);
            etdmAddition.setObjectId(newObjectId);
            etdmAddition.setNoid(-1L);
            isInsert = true;
        }
        etdmAddition.setAddTimestamp(BcTimeUtil.createCalendar());
        if (OrmDataId.class.isAssignableFrom(entityType) && (etdmDataId = (OrmDataId)entity).getDataId() <= 0) {
            int newDataId = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, MmdUtil.createTableColumnName(tableName, "id"));
            etdmDataId.setDataId(newDataId);
        }
        return isInsert;
    }

    @Override
    public int putEntity(DtsSession dtsSession, OrmPersistenceProxy persistenceProxy, String tableName, List<String> columnList, List<Object> valueList, Object entity, boolean doInsertCheck) throws Exception {
        int updateCount;
        block13: {
            SqlContext sqlContext = dtsSession.getSqlContext();
            Class<?> entityType = entity.getClass();
            OrmAddition etdmAddition = (OrmAddition)entity;
            boolean doInsert = false;
            doInsert = doInsertCheck ? this.preTrans(dtsSession, etdmAddition.getAddUserId(), tableName, entity) : true;
            SqlUpdateQuery updateQuery = new SqlUpdateQuery();
            updateQuery.tableName = tableName;
            persistenceProxy.createCommonSetPhrase(updateQuery, entity);
            int i = 0;
            while (i < columnList.size()) {
                Object value = valueList.get(i);
                SqlSetClause setClause = new SqlSetClause(columnList.get(i), value);
                updateQuery.addSetClause(setClause);
                ++i;
            }
            updateCount = 0;
            if (doInsert) {
                String sql = sqlContext.buildInsertQuery(updateQuery);
                try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                    try {
                        updateCount = stmt.executeUpdate(sql);
                        break block13;
                    }
                    catch (Exception ex) {
                        BcLogUtil.error("error:sql=" + sql);
                        throw ex;
                    }
                }
            }
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("sy_oid=" + etdmAddition.getObjectId());
            updateQuery.getWhereElementList().add(whereElement);
            String sql = sqlContext.buildUpdateQuery(updateQuery);
            try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
                try {
                    updateCount = stmt.executeUpdate(sql);
                    if (updateCount <= 0) {
                        sql = sqlContext.buildInsertQuery(updateQuery);
                        updateCount = stmt.executeUpdate(sql);
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.debug("error:sql=" + sql);
                    throw ex;
                }
            }
        }
        return updateCount;
    }

    public static int updateNextObjectId(DtsSession dtsSession, String tableName, long oid, long noid) throws Exception {
        String query = "UPDATE " + tableName + " SET " + "sy_noid" + "=" + noid + " WHERE " + "sy_oid" + "=" + oid;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int logicalDeleted(DtsSession dtsSession, String tableName, long oid, int userid, BcLogger logger) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlConnection sqlConn = dtsSession.getConnection();
        boolean resValue = false;
        MmdModel mmdModel = sqlContext.createModelMetaData(sqlConn, tableName);
        StringBuilder selectQuery = new StringBuilder();
        selectQuery.append(sqlContext.createSelectQuery(mmdModel));
        selectQuery.append(" WHERE sy_oid=" + oid);
        String insertSql = sqlContext.createInsertQueryForPrepareStatement(mmdModel);
        int dataCount = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(insertSql);
            ResultSetMetaData rsmd = rs.getMetaData();
            try (SqlPreparedStatement ppst = sqlConn.prepareStatement(insertSql);){
                try {
                    if (!rs.next()) return dataCount;
                    ++dataCount;
                    String sequenceName = MmdUtil.createTableColumnName(tableName, "sy_oid");
                    long newOid = OrmSequenceDAO.getInstance().generateNumber(dtsSession, sequenceName);
                    int i = 0;
                    while (true) {
                        block23: {
                            int sqlTypeId;
                            String columnName;
                            int colmunIndex;
                            block24: {
                                if (i >= rsmd.getColumnCount()) {
                                    ppst.executeUpdate();
                                    OrmPersistenceAddition.updateNextObjectId(dtsSession, tableName, oid, newOid);
                                    return dataCount;
                                }
                                colmunIndex = i + 1;
                                columnName = rsmd.getColumnName(colmunIndex);
                                sqlTypeId = rsmd.getColumnType(colmunIndex);
                                if (!BcStringUtil.equalsIgnoreCase(columnName, "sy_oid")) break block24;
                                if (sqlTypeId == -5) {
                                    ppst.setObject(colmunIndex, newOid);
                                    break block23;
                                } else if (sqlTypeId == 4) {
                                    ppst.setObject(colmunIndex, (int)newOid);
                                    break block23;
                                } else {
                                    if (sqlTypeId != 5) {
                                        String msg = "Not supported SQL Type. " + sqlTypeId;
                                        throw new SQLException(msg);
                                    }
                                    ppst.setObject(colmunIndex, (short)newOid);
                                }
                                break block23;
                            }
                            if (BcStringUtil.equalsIgnoreCase(columnName, "sy_noid")) {
                                ppst.setObject(colmunIndex, -9);
                            } else if (BcStringUtil.equalsIgnoreCase(columnName, "sy_timestamp")) {
                                ppst.setObject(colmunIndex, new Timestamp(System.currentTimeMillis()));
                            } else if (BcStringUtil.equalsIgnoreCase(columnName, "sy_user_id")) {
                                ppst.setObject(colmunIndex, userid);
                            } else {
                                sqlContext.copyRow(rs, colmunIndex, sqlContext, ppst, colmunIndex, sqlTypeId, null, logger);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    logger.error("selectQuery=" + selectQuery);
                    logger.error("insertSql=" + insertSql);
                    throw ex;
                }
            }
        }
    }

    public static int logicalDeleted(DtsSession dtsSession, String tableName, long oid, BcLogger logger) throws Exception {
        return OrmPersistenceAddition.logicalDeleted(dtsSession, tableName, oid, -1, logger);
    }
}

