/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.util.List;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.impt.common.ImptAbstractRecordParser;
import jp.co.extreme.module.impt.common.ImptImportDataParser;
import jp.co.extreme.module.impt.common.ImptParseEventHandler;
import jp.co.extreme.module.impt.model.ImptImportDefine;
import jp.co.extreme.module.xdts.common.XdtsWorkbookParser;
import jp.co.extreme.module.xdts.model.XdtsImportContext;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.task.TskAbstractCallable;

class XdtsImportTask
extends TskAbstractCallable
implements ImptParseEventHandler {
    XdtsImportContext importContext;
    ImptImportDefine importDefine;
    MmdModel mmdModel;
    DtsSession dtsSession;
    SqlContext sqlContext;
    PreparedStatement ppst;

    XdtsImportTask() {
    }

    public void setCondition(XdtsImportContext importContext, DtsSession dtsSession) throws Exception {
        this.importContext = importContext;
        this.importDefine = importContext.importDefine;
        this.mmdModel = importContext.mmdModel;
        this.dtsSession = dtsSession;
        this.sqlContext = dtsSession.getSqlContext();
    }

    protected Object taskProcess() throws Exception {
        ImptAbstractRecordParser recordParser;
        if (this.importDefine.datasourceType == 11 || this.importDefine.datasourceType == 21) {
            recordParser = new ImptImportDataParser();
            recordParser.addEventHandler(this);
        } else if (this.importDefine.datasourceType == 31) {
            recordParser = new XdtsWorkbookParser(this.importContext);
            recordParser.addEventHandler(this);
        } else {
            throw new Exception("importDefine.formatType=" + this.importDefine.datasourceType);
        }
        String insertQuery = this.sqlContext.createInsertQueryForPrepareStatement(this.importContext.mmdModel);
        this.getLogger().info("insertQuery=" + insertQuery);
        this.ppst = this.dtsSession.getConnection().prepareStatement(insertQuery);
        try {
            FileInputStream fileInputStream = new FileInputStream(this.importContext.file);
            recordParser.doParse(this.importDefine, fileInputStream);
        }
        finally {
            this.ppst.close();
        }
        return null;
    }

    @Override
    public void parseStarted() throws Exception {
    }

    @Override
    public void parseFinished() throws Exception {
    }

    @Override
    public void parsedRow(int page, int rowNo, int totalCnt, List<String> valueList) throws Exception {
        if (rowNo % 1000 == 0) {
            this.getLogger().info("page=" + page + " rowNo=" + rowNo + " totalCnt=" + totalCnt);
        }
        try {
            this.parsedRow2(page, rowNo, totalCnt, valueList);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            this.getLogger().debug("valueList=" + valueList);
        }
    }

    protected void parsedRow2(int page, int rowNo, int totalCnt, List valueList) throws Exception {
        if (rowNo < this.importDefine.headerRow) {
            return;
        }
        int mmdModelIndex = -1;
        if (this.importDefine.rowNumberEnabled) {
            int colmunIndex = ++mmdModelIndex + 1;
            int newRowNbr = totalCnt;
            if (this.importDefine.headerRow > 0) {
                newRowNbr -= this.importDefine.headerRow;
            }
            this.ppst.setObject(colmunIndex, newRowNbr);
        }
        BcCollectionUtil.fill(valueList, this.mmdModel.getFieldCount());
        int i = 0;
        while (i < valueList.size()) {
            int colmunIndex = ++mmdModelIndex + 1;
            Object value = valueList.get(i);
            MmdField mmdField = this.mmdModel.getField(mmdModelIndex);
            String strVal = "";
            if (value != null) {
                strVal = value.toString();
            }
            switch (mmdField.sqlTypeId) {
                case -1: {
                    this.sqlContext.set_LONGVARCHAR(this.ppst, colmunIndex, strVal);
                    break;
                }
                case -4: {
                    break;
                }
                case 2004: {
                    break;
                }
                default: {
                    if (value == null) {
                        this.ppst.setNull(colmunIndex, mmdField.sqlTypeId);
                        break;
                    }
                    Class javaClassType = SqlUtil.toJavaType(mmdField.sqlTypeId);
                    Object value2 = BcObjectConvertor.getInstance().convert(value, javaClassType);
                    this.ppst.setObject(colmunIndex, value2);
                }
            }
            ++i;
        }
        this.ppst.executeUpdate();
    }

    @Override
    public void characterDecodingException(int page, int row, int totalCnt, int columnIndex, byte[] bytes, Throwable throwable) throws Exception {
        this.getLogger().error(throwable);
    }
}

