/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.server;

import java.io.File;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionArgument;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.common.Wbs1MailConstants;
import jp.co.extreme.module.wbs1.dao.Wbs1MessageDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Message;

public class Wbs1ServerUtil {
    File marchandiseIamgeDir = null;

    private Wbs1ServerUtil() {
    }

    public static Wbs1ServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public DtsSession createSession_accessLog(DtsSessionArgument sessionArgument, Object owner) throws Exception {
        DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession("access_log", owner);
        return dtsSession;
    }

    public DtsSession createSession(DtsSessionArgument sessionArgument, Object owner) throws Exception {
        String datasourceName = Wbs1Constants.getDatasourceName();
        DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession(datasourceName, owner);
        return dtsSession;
    }

    public DtsSession createSession(Object owner) throws Exception {
        String datasourceName = Wbs1Constants.getDatasourceName();
        DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession(datasourceName, owner);
        return dtsSession;
    }

    public DtsSession createSession_imageeE01(Object owner) throws Exception {
        DtsSession dtsSession = DtsSessionFactoryManegaer.getInstance().createSession("image_e01", owner);
        return dtsSession;
    }

    public File getmMarchandiseIamgeDir() throws Exception {
        if (this.marchandiseIamgeDir == null) {
            String filepPath = AfbApplication.getInstance().toReal("${APP}data/marchandise_iamge");
            this.marchandiseIamgeDir = new File(filepPath);
        }
        return this.marchandiseIamgeDir;
    }

    public Wbs1Message addMailToQueue(DtsSession dtsSession, Wbs1Message wbs1Mail) throws Exception {
        wbs1Mail.fairCopyDatetime = BcTimeUtil.createCalendar();
        Wbs1MessageDAO mailDAO = Wbs1MessageDAO.getInstance(Wbs1MailConstants.MessageCategory.mail.tableName);
        mailDAO.putEntity(dtsSession, wbs1Mail);
        return wbs1Mail;
    }

    /* synthetic */ Wbs1ServerUtil(Wbs1ServerUtil wbs1ServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1ServerUtil instance = new Wbs1ServerUtil(null);

        private SingletonHolder() {
        }
    }
}

