/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.Ser;
import java.time.ZoneOffset;
import java.time.ZoneRegion;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;

public abstract class ZoneId
implements Serializable {
    public static final Map<String, String> SHORT_IDS;
    private static final long serialVersionUID = 8352817235686L;

    public static ZoneId systemDefault() {
        return TimeZone.getDefault().toZoneId();
    }

    public static Set<String> getAvailableZoneIds() {
        return ZoneRulesProvider.getAvailableZoneIds();
    }

    public static ZoneId of(String string, Map<String, String> map) {
        Objects.requireNonNull(string, "zoneId");
        Objects.requireNonNull(map, "aliasMap");
        String string2 = map.get(string);
        string2 = string2 != null ? string2 : string;
        return ZoneId.of(string2);
    }

    public static ZoneId of(String string) {
        return ZoneId.of(string, true);
    }

    public static ZoneId ofOffset(String string, ZoneOffset zoneOffset) {
        Objects.requireNonNull(string, "prefix");
        Objects.requireNonNull(zoneOffset, "offset");
        if (string.isEmpty()) {
            return zoneOffset;
        }
        if (!(string.equals("GMT") || string.equals("UTC") || string.equals("UT"))) {
            throw new IllegalArgumentException("prefix should be GMT, UTC or UT, is: " + string);
        }
        if (zoneOffset.getTotalSeconds() != 0) {
            string = string.concat(zoneOffset.getId());
        }
        return new ZoneRegion(string, zoneOffset.getRules());
    }

    static ZoneId of(String string, boolean bl) {
        Objects.requireNonNull(string, "zoneId");
        if (string.length() <= 1 || string.startsWith("+") || string.startsWith("-")) {
            return ZoneOffset.of(string);
        }
        if (string.startsWith("UTC") || string.startsWith("GMT")) {
            return ZoneId.ofWithPrefix(string, 3, bl);
        }
        if (string.startsWith("UT")) {
            return ZoneId.ofWithPrefix(string, 2, bl);
        }
        return ZoneRegion.ofId(string, bl);
    }

    private static ZoneId ofWithPrefix(String string, int n, boolean bl) {
        String string2 = string.substring(0, n);
        if (string.length() == n) {
            return ZoneId.ofOffset(string2, ZoneOffset.UTC);
        }
        if (string.charAt(n) != '+' && string.charAt(n) != '-') {
            return ZoneRegion.ofId(string, bl);
        }
        try {
            ZoneOffset zoneOffset = ZoneOffset.of(string.substring(n));
            if (zoneOffset == ZoneOffset.UTC) {
                return ZoneId.ofOffset(string2, zoneOffset);
            }
            return ZoneId.ofOffset(string2, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Invalid ID for offset-based ZoneId: " + string, dateTimeException);
        }
    }

    public static ZoneId from(TemporalAccessor temporalAccessor) {
        ZoneId zoneId = temporalAccessor.query(TemporalQueries.zone());
        if (zoneId == null) {
            throw new DateTimeException("Unable to obtain ZoneId from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName());
        }
        return zoneId;
    }

    ZoneId() {
        if (this.getClass() != ZoneOffset.class && this.getClass() != ZoneRegion.class) {
            throw new AssertionError((Object)"Invalid subclass");
        }
    }

    public abstract String getId();

    public String getDisplayName(TextStyle textStyle, Locale locale) {
        return new DateTimeFormatterBuilder().appendZoneText(textStyle).toFormatter(locale).format(this.toTemporal());
    }

    private TemporalAccessor toTemporal() {
        return new TemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField temporalField) {
                return false;
            }

            @Override
            public long getLong(TemporalField temporalField) {
                throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
            }

            @Override
            public <R> R query(TemporalQuery<R> temporalQuery) {
                if (temporalQuery == TemporalQueries.zoneId()) {
                    return (R)ZoneId.this;
                }
                return TemporalAccessor.super.query(temporalQuery);
            }
        };
    }

    public abstract ZoneRules getRules();

    public ZoneId normalized() {
        try {
            ZoneRules zoneRules = this.getRules();
            if (zoneRules.isFixedOffset()) {
                return zoneRules.getOffset(Instant.EPOCH);
            }
        }
        catch (ZoneRulesException zoneRulesException) {
            // empty catch block
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneId) {
            ZoneId zoneId = (ZoneId)object;
            return this.getId().equals(zoneId.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    public String toString() {
        return this.getId();
    }

    private Object writeReplace() {
        return new Ser(7, this);
    }

    abstract void write(DataOutput var1) throws IOException;

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>(64);
        hashMap.put("ACT", "Australia/Darwin");
        hashMap.put("AET", "Australia/Sydney");
        hashMap.put("AGT", "America/Argentina/Buenos_Aires");
        hashMap.put("ART", "Africa/Cairo");
        hashMap.put("AST", "America/Anchorage");
        hashMap.put("BET", "America/Sao_Paulo");
        hashMap.put("BST", "Asia/Dhaka");
        hashMap.put("CAT", "Africa/Harare");
        hashMap.put("CNT", "America/St_Johns");
        hashMap.put("CST", "America/Chicago");
        hashMap.put("CTT", "Asia/Shanghai");
        hashMap.put("EAT", "Africa/Addis_Ababa");
        hashMap.put("ECT", "Europe/Paris");
        hashMap.put("IET", "America/Indiana/Indianapolis");
        hashMap.put("IST", "Asia/Kolkata");
        hashMap.put("JST", "Asia/Tokyo");
        hashMap.put("MIT", "Pacific/Apia");
        hashMap.put("NET", "Asia/Yerevan");
        hashMap.put("NST", "Pacific/Auckland");
        hashMap.put("PLT", "Asia/Karachi");
        hashMap.put("PNT", "America/Phoenix");
        hashMap.put("PRT", "America/Puerto_Rico");
        hashMap.put("PST", "America/Los_Angeles");
        hashMap.put("SST", "Pacific/Guadalcanal");
        hashMap.put("VST", "Asia/Ho_Chi_Minh");
        hashMap.put("EST", "-05:00");
        hashMap.put("MST", "-07:00");
        hashMap.put("HST", "-10:00");
        SHORT_IDS = Collections.unmodifiableMap(hashMap);
    }
}

