/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantValue
extends Attribute {
    private int constantValueIndex;

    public ConstantValue(ConstantValue c) {
        this(c.getNameIndex(), c.getLength(), c.getConstantValueIndex(), c.getConstantPool());
    }

    ConstantValue(int nameIndex, int length, DataInput input, ConstantPool constantPool) throws IOException {
        this(nameIndex, length, input.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int nameIndex, int length, int constantValueIndex, ConstantPool constantPool) {
        super((byte)1, nameIndex, Args.require(length, 2, "ConstantValue attribute length"), constantPool);
        this.constantValueIndex = constantValueIndex;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantValue(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ConstantValue c = (ConstantValue)this.clone();
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.constantValueIndex);
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex;
    }

    public void setConstantValueIndex(int constantValueIndex) {
        this.constantValueIndex = constantValueIndex;
    }

    @Override
    public String toString() {
        String buf;
        Object c = super.getConstantPool().getConstant(this.constantValueIndex);
        switch (((Constant)c).getTag()) {
            case 5: {
                buf = String.valueOf(((ConstantLong)c).getBytes());
                break;
            }
            case 4: {
                buf = String.valueOf(((ConstantFloat)c).getBytes());
                break;
            }
            case 6: {
                buf = String.valueOf(((ConstantDouble)c).getBytes());
                break;
            }
            case 3: {
                buf = String.valueOf(((ConstantInteger)c).getBytes());
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = super.getConstantPool().getConstantUtf8(i);
                buf = "\"" + Utility.convertString(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            default: {
                throw new IllegalStateException("Type of ConstValue invalid: " + c);
            }
        }
        return buf;
    }
}

