/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class ManifestTask
extends Task {
    public static final String VALID_ATTRIBUTE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_";
    private Manifest nestedManifest = new Manifest();
    private File manifestFile;
    private Mode mode = new Mode();
    private String encoding;
    private boolean mergeClassPaths = false;
    private boolean flattenClassPaths = false;

    public ManifestTask() {
        this.mode.setValue("replace");
    }

    public void addConfiguredSection(Manifest.Section section) throws ManifestException {
        Enumeration<String> attributeKeys = section.getAttributeKeys();
        while (attributeKeys.hasMoreElements()) {
            Manifest.Attribute attribute = section.getAttribute(attributeKeys.nextElement());
            this.checkAttribute(attribute);
        }
        this.nestedManifest.addConfiguredSection(section);
    }

    public void addConfiguredAttribute(Manifest.Attribute attribute) throws ManifestException {
        this.checkAttribute(attribute);
        this.nestedManifest.addConfiguredAttribute(attribute);
    }

    private void checkAttribute(Manifest.Attribute attribute) throws BuildException {
        String name = attribute.getName();
        char ch = name.charAt(0);
        if (ch == '-' || ch == '_') {
            throw new BuildException("Manifest attribute names must not start with '" + ch + "'.");
        }
        int i = 0;
        while (i < name.length()) {
            ch = name.charAt(i);
            if (VALID_ATTRIBUTE_CHARS.indexOf(ch) < 0) {
                throw new BuildException("Manifest attribute names must not contain '" + ch + "'");
            }
            ++i;
        }
    }

    public void setFile(File f) {
        this.manifestFile = f;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    public void setMergeClassPathAttributes(boolean b) {
        this.mergeClassPaths = b;
    }

    public void setFlattenAttributes(boolean b) {
        this.flattenClassPaths = b;
    }

    @Override
    public void execute() throws BuildException {
        BuildException error;
        Manifest current;
        Manifest toWrite;
        block21: {
            if (this.manifestFile == null) {
                throw new BuildException("the file attribute is required");
            }
            toWrite = Manifest.getDefaultManifest();
            current = null;
            error = null;
            if (this.manifestFile.exists()) {
                FileInputStream fis = null;
                InputStreamReader isr = null;
                try {
                    fis = new FileInputStream(this.manifestFile);
                    isr = this.encoding == null ? new InputStreamReader((InputStream)fis, "UTF-8") : new InputStreamReader((InputStream)fis, this.encoding);
                    current = new Manifest(isr);
                }
                catch (ManifestException m) {
                    error = new BuildException("Existing manifest " + this.manifestFile + " is invalid", m, this.getLocation());
                    FileUtils.close(isr);
                    break block21;
                }
                catch (IOException e) {
                    try {
                        error = new BuildException("Failed to read " + this.manifestFile, e, this.getLocation());
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(isr);
                        throw throwable;
                    }
                    FileUtils.close(isr);
                    break block21;
                }
                FileUtils.close(isr);
            }
        }
        Enumeration<String> e = this.nestedManifest.getWarnings();
        while (e.hasMoreElements()) {
            this.log("Manifest warning: " + e.nextElement(), 1);
        }
        try {
            if (this.mode.getValue().equals("update") && this.manifestFile.exists()) {
                if (current != null) {
                    toWrite.merge(current, false, this.mergeClassPaths);
                } else if (error != null) {
                    throw error;
                }
            }
            toWrite.merge(this.nestedManifest, false, this.mergeClassPaths);
        }
        catch (ManifestException m) {
            throw new BuildException("Manifest is invalid", m, this.getLocation());
        }
        if (toWrite.equals(current)) {
            this.log("Manifest has not changed, do not recreate", 3);
            return;
        }
        PrintWriter w = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(this.manifestFile);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                w = new PrintWriter(osw);
                toWrite.write(w, this.flattenClassPaths);
                if (w.checkError()) {
                    throw new IOException("Encountered an error writing manifest");
                }
            }
            catch (IOException e2) {
                throw new BuildException("Failed to write " + this.manifestFile, e2, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(w);
            throw throwable;
        }
        FileUtils.close(w);
    }

    public static class Mode
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"update", "replace"};
        }
    }
}

