/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import org.apache.commons.net.io.DotTerminatedMessageWriter;
import org.apache.commons.net.smtp.RelayPath;
import org.apache.commons.net.smtp.SMTP;
import org.apache.commons.net.smtp.SMTPReply;

public class SMTPClient
extends SMTP {
    public SMTPClient() {
    }

    public SMTPClient(String encoding) {
        super(encoding);
    }

    public boolean addRecipient(RelayPath path) throws IOException {
        return SMTPReply.isPositiveCompletion(this.rcpt(path.toString()));
    }

    public boolean addRecipient(String address) throws IOException {
        return SMTPReply.isPositiveCompletion(this.rcpt("<" + address + ">"));
    }

    public boolean completePendingCommand() throws IOException {
        return SMTPReply.isPositiveCompletion(this.getReply());
    }

    public String listHelp() throws IOException {
        if (SMTPReply.isPositiveCompletion(this.help())) {
            return this.getReplyString();
        }
        return null;
    }

    public String listHelp(String command) throws IOException {
        if (SMTPReply.isPositiveCompletion(this.help(command))) {
            return this.getReplyString();
        }
        return null;
    }

    public boolean login() throws IOException {
        InetAddress host = this.getLocalAddress();
        String name = host.getHostName();
        if (name == null) {
            return false;
        }
        return SMTPReply.isPositiveCompletion(this.helo(name));
    }

    public boolean login(String hostname) throws IOException {
        return SMTPReply.isPositiveCompletion(this.helo(hostname));
    }

    public boolean logout() throws IOException {
        return SMTPReply.isPositiveCompletion(this.quit());
    }

    public boolean reset() throws IOException {
        return SMTPReply.isPositiveCompletion(this.rset());
    }

    public Writer sendMessageData() throws IOException {
        if (!SMTPReply.isPositiveIntermediate(this.data())) {
            return null;
        }
        return new DotTerminatedMessageWriter(this.writer);
    }

    public boolean sendNoOp() throws IOException {
        return SMTPReply.isPositiveCompletion(this.noop());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendShortMessageData(String message) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Writer writer = this.sendMessageData();){
            if (writer == null) {
                return false;
            }
            writer.write(message);
            return this.completePendingCommand();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public boolean sendSimpleMessage(String sender, String recipient, String message) throws IOException {
        if (!this.setSender(sender)) {
            return false;
        }
        if (!this.addRecipient(recipient)) {
            return false;
        }
        return this.sendShortMessageData(message);
    }

    public boolean sendSimpleMessage(String sender, String[] recipients, String message) throws IOException {
        if (!this.setSender(sender)) {
            return false;
        }
        boolean oneSuccess = false;
        String[] stringArray = recipients;
        int n = recipients.length;
        int n2 = 0;
        while (n2 < n) {
            String recipient = stringArray[n2];
            if (this.addRecipient(recipient)) {
                oneSuccess = true;
            }
            ++n2;
        }
        if (!oneSuccess) {
            return false;
        }
        return this.sendShortMessageData(message);
    }

    public boolean setSender(RelayPath path) throws IOException {
        return SMTPReply.isPositiveCompletion(this.mail(path.toString()));
    }

    public boolean setSender(String address) throws IOException {
        return SMTPReply.isPositiveCompletion(this.mail("<" + address + ">"));
    }

    public boolean verify(String user) throws IOException {
        int result = this.vrfy(user);
        return result == 250 || result == 251;
    }
}

