/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;

public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private static final String REGEX = "(.*?);([0-9]{1,20})\\s{0,80}.{0,80}";
    private static final Pattern PATTERN = Pattern.compile("(.*?);([0-9]{1,20})\\s{0,80}.{0,80}");

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig config) {
        this.configure(config);
    }

    @Override
    protected boolean isVersioning() {
        return true;
    }

    @Override
    public List<String> preParse(List<String> original) {
        Integer existing;
        String version;
        String name;
        MatchResult result;
        Matcher matcher;
        String entry;
        HashMap<String, Integer> existingEntries = new HashMap<String, Integer>();
        ListIterator<String> iter = original.listIterator();
        while (iter.hasNext()) {
            entry = iter.next().trim();
            matcher = PATTERN.matcher(entry);
            if (!matcher.matches()) continue;
            result = matcher.toMatchResult();
            name = result.group(1);
            version = result.group(2);
            Integer nv = Integer.valueOf(version);
            existing = (Integer)existingEntries.get(name);
            if (existing != null && nv < existing) {
                iter.remove();
                continue;
            }
            existingEntries.put(name, nv);
        }
        while (iter.hasPrevious()) {
            entry = iter.previous().trim();
            result = null;
            matcher = PATTERN.matcher(entry);
            if (!matcher.matches()) continue;
            result = matcher.toMatchResult();
            name = result.group(1);
            version = result.group(2);
            int nv = Integer.parseInt(version);
            existing = (Integer)existingEntries.get(name);
            if (existing == null || nv >= existing) continue;
            iter.remove();
        }
        return original;
    }
}

