/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.script;

import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SrpClosureCompiler {
    private boolean doCompile = false;

    public static SrpClosureCompiler getInstance() {
        return SingletonHolder.instance;
    }

    public String compile(List<SourceFile> externs, List<SourceFile> sources, CompilerOptions compilerOptions) {
        Compiler compiler = new Compiler(System.err);
        compiler.disableThreads();
        Result result = compiler.compile(externs, sources, compilerOptions);
        if (!result.success) {
            throw new RuntimeException("Closure Compiler returned error");
        }
        return compiler.toSource();
    }

    public String compile(Collection<File> fileCollection) {
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        ArrayList<SourceFile> sources = new ArrayList<SourceFile>();
        for (File file : fileCollection) {
            sources.add(SourceFile.fromFile((String)file.getPath()));
        }
        CompilerOptions compilerOptions = new CompilerOptions();
        return this.compile(externs, sources, compilerOptions);
    }

    public String compile(String code) {
        if (!this.doCompile) {
            return code;
        }
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        ArrayList<SourceFile> sources = new ArrayList<SourceFile>();
        SourceFile sourceFile = SourceFile.fromCode((String)"temp.js", (String)code);
        sources.add(sourceFile);
        CompilerOptions compilerOptions = new CompilerOptions();
        return this.compile(externs, sources, compilerOptions);
    }

    private static final class SingletonHolder {
        private static final SrpClosureCompiler instance = new SrpClosureCompiler();

        private SingletonHolder() {
        }
    }
}

