/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgTextArea;
import jp.co.extreme.swing.SwgUtil;

public class IswgGeneralDialog
extends SwgDialog
implements WindowListener {
    private static final long serialVersionUID = -7611964786665172098L;
    protected final JPanel basePanel = new JPanel();
    protected final JPanel northPanel = new JPanel();
    protected final JPanel southPanel = new JPanel();
    protected final JPanel westPanel = new JPanel();
    protected final JPanel eastPanel = new JPanel();
    protected final JPanel centerPanel = new JPanel();
    protected SwgTextArea explanationTextArea = new SwgTextArea();
    protected JScrollPane explanationScrollPane = new JScrollPane();
    protected int charWidth = 16;
    protected int margin = 40;
    protected int buttonHeight = 30;
    protected ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                IswgGeneralDialog.this.actionEvent(ev);
            }
            catch (Exception ex) {
                IswgGeneralDialog.this.handleException(ex);
            }
        }
    };
    protected SwgButton okButton = new SwgButton();
    protected SwgButton cancelButton = new SwgButton();

    public IswgGeneralDialog(Frame ownerWindow) throws Exception {
        super(ownerWindow);
        this.init();
    }

    public IswgGeneralDialog(Dialog ownerWindow) throws Exception {
        super(ownerWindow);
        this.init();
    }

    protected void init() throws Exception {
        this.basePanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.basePanel, "Center");
        this.basePanel.add((Component)this.northPanel, "North");
        this.southPanel.setLayout(new FlowLayout());
        this.southPanel.setPreferredSize(new Dimension(10, 44));
        this.basePanel.add((Component)this.southPanel, "South");
        this.basePanel.add((Component)this.westPanel, "West");
        this.basePanel.add((Component)this.eastPanel, "East");
        this.basePanel.add((Component)this.centerPanel, "Center");
        this.explanationTextArea.setEditable(false);
        this.explanationTextArea.setLineWrap(true);
        this.explanationScrollPane.setBorder(new EmptyBorder(new Insets(4, 4, 4, 4)));
        this.explanationScrollPane.getViewport().add(this.explanationTextArea);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setModal(true);
        this.setResizable(false);
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        this.close();
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }

    public void setOkButton(String label) {
        if (label != null) {
            this.okButton.setText(label);
        } else {
            this.okButton.setText(BcWords.getInstance().ok);
        }
        this.okButton.setPreferredSize(new Dimension(this.okButton.getText().length() * this.charWidth + this.margin, this.buttonHeight));
        this.southPanel.add(this.okButton);
        this.okButton.addActionListener(this.actionListener);
    }

    protected void okButtonAction() throws Exception {
        this.close();
    }

    public void setCancelButton(String label) {
        if (label != null) {
            this.cancelButton.setText(label);
        } else {
            this.cancelButton.setText(BcWords.getInstance().cancel);
        }
        this.cancelButton.setPreferredSize(new Dimension(this.cancelButton.getText().length() * this.charWidth + this.margin, this.buttonHeight));
        this.southPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this.actionListener);
    }

    protected void cancelButtonAction() {
        this.close();
    }

    protected void actionEvent(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.okButton) {
            this.okButtonAction();
        } else if (ev.getSource() == this.cancelButton) {
            this.cancelButtonAction();
        }
    }

    protected void close() {
        this.dispose();
    }

    public void setExplanation(String msg, int height) {
        if (height <= 0) {
            height = 64;
        }
        this.northPanel.setPreferredSize(new Dimension(10, height));
        this.northPanel.setLayout(new CardLayout(4, 4));
        this.northPanel.add((Component)this.explanationScrollPane, "");
        this.explanationTextArea.setText(msg);
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

